/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.xiongyingqi.util.EntityHelper;
import com.xiongyingqi.util.StackTraceHelper;
import com.xiongyingqi.util.StringHelper;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrintHelper {
    private Map<String, String> commentMap;
    private Collection<String> ignoreProperties;
    private String commentPattern = "{0}<{1}>";
    private String ignorePattern = "({0}=.*?,\\s*)|({0}=.*?])";
    private Pattern pattern = Pattern.compile("password=.*((,\\s)|])*");

    public static PrintHelper needComment() {
        PrintHelper printHelper = new PrintHelper();
        printHelper.commentMap = new HashMap<String, String>();
        printHelper.ignoreProperties = new ArrayList<String>();
        return printHelper;
    }

    public PrintHelper addComment(String word, String comment) {
        this.commentMap.put(word, comment);
        return this;
    }

    public PrintHelper ignoreProperty(String propertyName) {
        this.ignoreProperties.add(propertyName);
        return this;
    }

    private String buildContent(String content) {
        Set<Map.Entry<String, String>> entries = this.commentMap.entrySet();
        StringBuilder builder = new StringBuilder(content);
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.replaceWord(builder, key, value);
        }
        return builder.toString();
    }

    private void handleIgnoreProperty(StringBuilder builder, String propertyName) {
        String s = builder.toString();
        String patternStr = MessageFormat.format(this.ignorePattern, propertyName);
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(builder);
        while (matcher.find()) {
            s = matcher.replaceAll("");
        }
        builder.replace(0, builder.length(), s);
    }

    private String buildWordAndComment(String word, String comment) {
        String rs = MessageFormat.format(this.commentPattern, word, comment);
        return rs;
    }

    private void replaceWord(StringBuilder builder, String word, String comment) {
        int index;
        String replacement = this.buildWordAndComment(word, comment);
        int fromIndex = 0;
        while ((index = builder.indexOf(word, fromIndex)) > 0) {
            fromIndex = index + 1;
            builder.replace(index, index + word.length(), replacement);
        }
    }

    public void printC(Object object) {
        StackTraceElement[] stackTraceElements = StackTraceHelper.getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElements[2];
        StringBuilder builder = new StringBuilder();
        builder.append(" ------------------------------------------------------------ ");
        builder.append(StringHelper.line());
        builder.append(StackTraceHelper.buildStackTrace(new StackTraceElement[]{stackTraceElement}));
        builder.append("    ");
        if (object == null) {
            builder.append("<null>");
        } else {
            builder.append(object.getClass().getSimpleName());
            builder.append(" =============== ");
            String content = this.buildObjectToString(object);
            builder.append(this.buildContent(content));
        }
        builder.append(StringHelper.line());
        builder.append(" ------------------------------------------------------------ ");
        System.out.println(builder.toString());
    }

    private String buildObjectToString(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        StringBuilder builder = new StringBuilder();
        if (clazz.isArray()) {
            builder.append("[");
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                Object one = Array.get(object, i);
                builder.append(this.buildObjectToString(one));
                if (i >= length - 1) continue;
                builder.append(", ");
            }
            builder.append("]");
        } else {
            builder.append(this.reflectToString(object));
        }
        return builder.toString();
    }

    public String reflectToString(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        StringBuilder builder = new StringBuilder(clazz.getName());
        builder.append("@");
        builder.append(Integer.toHexString(object.hashCode()));
        builder.append("[");
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        Collection<Class> classes = EntityHelper.getAllSuperClassesOfClass(clazz);
        for (Class claxx : classes) {
            Method[] clazzMethods = claxx.getDeclaredMethods();
            for (int i = 0; i < clazzMethods.length; ++i) {
                Method method = clazzMethods[i];
                methods.add(method);
            }
        }
        for (Method method : methods) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") || Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
            try {
                Object value = method.invoke(object, new Object[0]);
                String propertyName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                if (propertyName.equals("class") || this.ignoreProperties.contains(propertyName)) continue;
                builder.append(propertyName);
                builder.append("=");
                if (value == null) {
                    builder.append("<null>");
                } else if (value.getClass().isArray()) {
                    int arraySuperLength = Array.getLength(value);
                    builder.append("{");
                    for (int j = 0; j < arraySuperLength; ++j) {
                        Object object2 = Array.get(value, j);
                        builder.append(object2.toString());
                        if (j >= arraySuperLength - 1) continue;
                        builder.append(", ");
                    }
                    builder.append("}");
                } else {
                    builder.append(value.toString());
                }
                builder.append(", ");
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {}
        }
        if (builder.toString().contains(", ")) {
            builder.replace(builder.length() - 2, builder.length(), "");
        }
        builder.append("]");
        return builder.toString();
    }

    public static void printDetail(Object object) {
        StackTraceElement[] stackTraceElements = StackTraceHelper.getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElements[2];
        StringBuilder builder = new StringBuilder();
        builder.append(" ------------------------------------------------------------ ");
        builder.append(StringHelper.line());
        builder.append(StackTraceHelper.buildStackTrace(new StackTraceElement[]{stackTraceElement}));
        builder.append("    ");
        if (object == null) {
            builder.append("<null>");
        } else {
            builder.append(object.getClass().getSimpleName());
            builder.append(" =============== ");
            builder.append(EntityHelper.reflectToString(object));
        }
        builder.append(StringHelper.line());
        builder.append(" ------------------------------------------------------------ ");
        System.out.println(builder.toString());
    }

    public static void print(Object object) {
        StackTraceElement[] stackTraceElements = StackTraceHelper.getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElements[2];
        StringBuilder builder = new StringBuilder();
        builder.append(" ------------------------------------------------------------ ");
        builder.append(StringHelper.line());
        builder.append(StackTraceHelper.buildStackTrace(new StackTraceElement[]{stackTraceElement}));
        builder.append("    ");
        if (object == null) {
            builder.append("<null>");
        } else {
            builder.append(object.getClass().getSimpleName());
            builder.append(" =============== ");
            builder.append(EntityHelper.buildObjectToString(object));
        }
        builder.append(StringHelper.line());
        builder.append(" ------------------------------------------------------------ ");
        System.out.println(builder.toString());
    }

    public static void print() {
        StackTraceElement[] stackTraceElements = StackTraceHelper.getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElements[2];
        StringBuilder builder = new StringBuilder();
        builder.append(" ------------------------------------------------------------ ");
        builder.append(StringHelper.line());
        builder.append(StackTraceHelper.buildStackTrace(new StackTraceElement[]{stackTraceElement}));
        builder.append("    ");
        builder.append(StringHelper.line());
        builder.append(" ------------------------------------------------------------ ");
        System.out.println(builder.toString());
    }
}

