/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xiongyingqi.util.EntityHelper;
import com.xiongyingqi.util.ThreadPool;
import com.xiongyingqi.util.TimerHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class PhoneNumberAddress {
    public static XmlProvince getMobileAddress(String mobileNumber) throws MalformedURLException {
        String urlString = "http://life.tenpay.com/cgi-bin/mobile/MobileQueryAttribution.cgi?chgmobile=" + mobileNumber;
        URL url = new URL(urlString);
        XmlProvince result = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{XmlProvince.class});
            Unmarshaller u = jc.createUnmarshaller();
            try {
                StreamSource streamSource = new StreamSource(url.openStream());
                JAXBElement element = u.unmarshal((Source)streamSource, XmlProvince.class);
                result = (XmlProvince)element.getValue();
                EntityHelper.print(result);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String calcMobileCity(String mobileNumber) throws MalformedURLException {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonString = null;
        String urlString = "http://tcc.taobao.com/cc/json/mobile_tel_segment.htm?tel=" + mobileNumber;
        StringBuffer sb = new StringBuffer();
        URL url = new URL(urlString);
        try {
            InputStream in = url.openStream();
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in, "gb2312"));
            String line = null;
            while ((line = buffer.readLine()) != null) {
                sb.append(line);
            }
            in.close();
            buffer.close();
            jsonString = sb.toString();
            EntityHelper.print(jsonString);
            jsonString = jsonString.replaceAll("^[__]\\w{14}+[_ = ]+", "[");
            String jsonString2 = jsonString + "]";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        TimerHelper.getTime();
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            long number = 13000000000L + (long)random.nextInt(1000000000);
            String testMobileNumber = "" + number;
            ThreadPool.invoke(null, PhoneNumberAddress.class.getMethod("getMobileAddress", String.class), testMobileNumber);
        }
        ThreadPool.shutDown();
        System.out.println(TimerHelper.getTime());
    }

    static class PhoneProvince {
        private String mts;
        private String province;
        private String catName;
        private String telString;
        private String areaVid;
        private String ispVid;

        PhoneProvince() {
        }

        public String getMts() {
            return this.mts;
        }

        public void setMts(String mts) {
            this.mts = mts;
        }

        public String getProvince() {
            return this.province;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public String getCatName() {
            return this.catName;
        }

        public void setCatName(String catName) {
            this.catName = catName;
        }

        public String getTelString() {
            return this.telString;
        }

        public void setTelString(String telString) {
            this.telString = telString;
        }

        public String getAreaVid() {
            return this.areaVid;
        }

        public void setAreaVid(String areaVid) {
            this.areaVid = areaVid;
        }

        public String getIspVid() {
            return this.ispVid;
        }

        public void setIspVid(String ispVid) {
            this.ispVid = ispVid;
        }
    }

    static class XmlProvince
    extends EntityHelper {
        private String chgmobile;
        private String city;
        private String province;
        private String retcode;
        private String retmsg;
        private String supplier;
        private String tid;

        XmlProvince() {
        }

        public String getChgmobile() {
            return this.chgmobile;
        }

        public void setChgmobile(String chgmobile) {
            this.chgmobile = chgmobile;
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getProvince() {
            return this.province;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public String getRetcode() {
            return this.retcode;
        }

        public void setRetcode(String retcode) {
            this.retcode = retcode;
        }

        public String getRetmsg() {
            return this.retmsg;
        }

        public void setRetmsg(String retmsg) {
            this.retmsg = retmsg;
        }

        public String getSupplier() {
            return this.supplier;
        }

        public void setSupplier(String supplier) {
            this.supplier = supplier;
        }

        public String getTid() {
            return this.tid;
        }

        public void setTid(String tid) {
            this.tid = tid;
        }
    }
}

