/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageUtil {
    private static String[] CLASS_PATH_PROP = new String[]{"user.dir", "java.class.path", "java.ext.dirs", "sun.boot.class.path"};
    private static List<File> CLASS_PATH_ARRAY = PackageUtil.getClassPath();

    public static void main(String[] args) throws IOException {
        System.out.println(PackageUtil.getRootClassPath());
    }

    public static File getRootClassPath() {
        URL url = PackageUtil.class.getClassLoader().getResource("");
        File file = new File(url.getFile());
        return file;
    }

    private static List<File> getClassPath() {
        ArrayList<File> ret = new ArrayList<File>();
        String delim = ":";
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            delim = ";";
        }
        for (String pro : CLASS_PATH_PROP) {
            try {
                String[] pathes;
                for (String path : pathes = System.getProperty(pro).split(delim)) {
                    ret.add(new File(path));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    public static Set<Class<?>> getclass(String pakage) {
        LinkedHashSet classes = new LinkedHashSet();
        boolean flag = true;
        String packName = pakage;
        String packDir = packName.replace(".", "/");
        try {
            Enumeration<URL> dir = Thread.currentThread().getContextClassLoader().getResources(packDir);
            while (dir.hasMoreElements()) {
                URL url = dir.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    PackageUtil.findAndAddClassesInPackageByFile(packName, filePath, flag, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
                JarFile jar = urlConnection.getJarFile();
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static File getClassDirectory(Package pakage) {
        LinkedHashSet classes = new LinkedHashSet();
        boolean flag = true;
        String packName = pakage.getName();
        String packDir = packName.replace(".", "/");
        String filePath = null;
        try {
            Enumeration<URL> dir = Thread.currentThread().getContextClassLoader().getResources(packDir);
            while (dir.hasMoreElements()) {
                URL url = dir.nextElement();
                String protocol = url.getProtocol();
                if (!"file".equals(protocol)) continue;
                filePath = URLDecoder.decode(url.getFile(), "UTF-8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static Set<Class<?>> getclass(Package pakage) {
        LinkedHashSet classes = new LinkedHashSet();
        boolean flag = true;
        String packName = pakage.getName();
        String packDir = packName.replace(".", "/");
        try {
            Enumeration<URL> dir = Thread.currentThread().getContextClassLoader().getResources(packDir);
            while (dir.hasMoreElements()) {
                URL url = dir.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    PackageUtil.findAndAddClassesInPackageByFile(packName, filePath, flag, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
                JarFile jar = urlConnection.getJarFile();
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    private static void findAndAddClassesInPackageByFile(String packName, String filePath, final boolean flag, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(filePath);
        if (!dir.exists() || !dir.isDirectory()) {
            System.out.println("\u6b64\u8def\u5f84\u4e0b\u6ca1\u6709\u6587\u4ef6");
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return flag && pathname.isDirectory() || pathname.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                PackageUtil.findAndAddClassesInPackageByFile(packName + "." + file.getName(), file.getAbsolutePath(), flag, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packName + "." + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

