/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.xiongyingqi.util.Base64;
import com.xiongyingqi.util.EntityHelper;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class MessageEncryptionHelper {
    public static final boolean toUpperCase = true;

    private static String encode(String code, String message) {
        return MessageEncryptionHelper.encode(code, message.getBytes());
    }

    private static String encode(String code, byte[] message) {
        String encode = null;
        try {
            MessageDigest md = MessageDigest.getInstance(code);
            encode = MessageEncryptionHelper.byteArrayToHexString(md.digest(message));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return encode;
    }

    private static String byteArrayToHexString(byte[] digest) {
        StringBuffer md5StrBuff = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            if (Integer.toHexString(0xFF & digest[i]).length() == 1) {
                md5StrBuff.append("0").append(Integer.toHexString(0xFF & digest[i]));
                continue;
            }
            String hex = Integer.toHexString(0xFF & digest[i]);
            hex = hex.toUpperCase();
            md5StrBuff.append(hex);
        }
        return md5StrBuff.toString();
    }

    public static String md5Encode(String message) {
        return MessageEncryptionHelper.encode("MD5", message);
    }

    public static String shaEncode(String message) {
        return MessageEncryptionHelper.encode("SHA", message);
    }

    public static String sha256Encode(String message) {
        return MessageEncryptionHelper.encode("SHA-256", message);
    }

    public static String sha512Encode(String message) {
        return MessageEncryptionHelper.encode("SHA-512", message);
    }

    public static String shaEncode(byte[] message) {
        return MessageEncryptionHelper.encode("SHA", message);
    }

    public static String sha256Encode(byte[] message) {
        return MessageEncryptionHelper.encode("SHA-256", message);
    }

    public static String sha512Encode(byte[] message) {
        return MessageEncryptionHelper.encode("SHA-512", message);
    }

    public static byte[] desEncrypt(byte[] rawKeyData, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, InvalidKeySpecException {
        SecureRandom sr = new SecureRandom();
        DESKeySpec dks = new DESKeySpec(rawKeyData);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey key = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(1, (Key)key, sr);
        byte[] encryptedData = cipher.doFinal(data);
        return encryptedData;
    }

    public static byte[] desDecrypt(byte[] rawKeyData, byte[] encryptedData) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException {
        SecureRandom sr = new SecureRandom();
        DESKeySpec dks = new DESKeySpec(rawKeyData);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey key = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, (Key)key, sr);
        byte[] decryptedData = cipher.doFinal(encryptedData);
        return decryptedData;
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException {
        EntityHelper.print(MessageEncryptionHelper.sha256Encode(""));
        EntityHelper.print(MessageEncryptionHelper.sha512Encode(""));
        EntityHelper.print(MessageEncryptionHelper.md5Encode(""));
        SecureRandom sr = new SecureRandom();
        KeyGenerator kg = KeyGenerator.getInstance("DES");
        kg.init(sr);
        SecretKey key = kg.generateKey();
        byte[] rawKeyData = key.getEncoded();
        System.out.println("\u5bc6\u5319\u957f\u5ea6===>" + rawKeyData.length);
        System.out.println("\u5bc6\u5319Base64===>" + Base64.encodeBytes(rawKeyData));
        String str = "hi.baidu.com/beijingalana";
        byte[] encryptedData = MessageEncryptionHelper.desEncrypt(rawKeyData, str.getBytes());
        encryptedData = MessageEncryptionHelper.desEncrypt(rawKeyData, encryptedData);
        byte[] decrypt = MessageEncryptionHelper.desDecrypt(rawKeyData, encryptedData);
        decrypt = MessageEncryptionHelper.desDecrypt(rawKeyData, decrypt);
        System.out.println("\u89e3\u5bc6===>" + new String(decrypt));
    }
}

