/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.xiongyingqi.util.Assert;
import com.xiongyingqi.util.EntityHelper;
import com.xiongyingqi.util.FileEncode;
import com.xiongyingqi.util.StringUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FileHelper {
    public static final Logger LOGGER = Logger.getLogger(FileHelper.class);
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final long PB = 0x4000000000000L;

    public static boolean checkFileSizeLessThen(File file, long size) {
        try {
            FileHelper.fileNotFullAndExists(file);
        }
        catch (Exception e) {
            return false;
        }
        return file.length() <= size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File appendStringToFile(File file, String string) {
        OutputStreamWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file, true);
            fileWriter.append(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fileWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File appendBytesToFile(File file, byte[] bts) {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file, true));
            outputStream.write(bts);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static String getMimeType(File data) {
        if (!data.exists()) {
            return null;
        }
        BodyContentHandler contenthandler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        metadata.set("resourceName", data.getName());
        AutoDetectParser parser = new AutoDetectParser();
        try {
            parser.parse((InputStream)new FileInputStream(data), (ContentHandler)contenthandler, metadata, null);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        catch (SAXException e) {
            LOGGER.error((Object)e);
        }
        catch (TikaException e) {
            LOGGER.error((Object)e);
        }
        return metadata.get("Content-Type");
    }

    public static File[] listFilesBySuffix(File folder, final String suffix) {
        File[] files = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File paramFile, String paramString) {
                String newSuffix = suffix;
                if (!newSuffix.startsWith(".")) {
                    newSuffix = "." + newSuffix;
                }
                return paramString.endsWith(newSuffix);
            }
        });
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File readBufferImage(BufferedImage bufferedImage) {
        File file = null;
        OutputStream outputStream = null;
        try {
            file = File.createTempFile(System.currentTimeMillis() + StringUtil.randomString(8), "gif");
            outputStream = new FileOutputStream(file);
            ImageIO.write((RenderedImage)bufferedImage, "gif", outputStream);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }
        }
        return file;
    }

    public static File readURL(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        InputStream inputStream = null;
        if (url.getHost().trim().equals("")) {
            File file = new File(url.getFile());
            return file;
        }
        inputStream = url.openStream();
        return FileHelper.readInputStream(inputStream);
    }

    public static String readInputStreamToString(InputStream inputStream, Charset charset) {
        byte[] bts = null;
        try {
            bts = FileHelper.readInputStreamToBytes(inputStream);
            if (bts == null) {
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = new String(bts, charset);
        return content;
    }

    public static String readInputStreamToString(InputStream inputStream, String encoding) {
        return FileHelper.readInputStreamToString(inputStream, Charset.forName(encoding));
    }

    public static InputStream openStream(File file) {
        Assert.isTrue(file.exists(), "\u6587\u4ef6\uff1a" + file + "\u4e0d\u5b58\u5728\uff01");
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return inputStream;
    }

    public static Reader openReader(File file) {
        Assert.isTrue(file.exists(), "\u6587\u4ef6\uff1a" + file + "\u4e0d\u5b58\u5728\uff01");
        FileReader reader = null;
        try {
            reader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return reader;
    }

    public static BufferedReader openBufferedReader(File file) {
        BufferedReader bufferedReader = new BufferedReader(FileHelper.openReader(file));
        return bufferedReader;
    }

    public static String readInputStreamToString(InputStream inputStream) {
        return FileHelper.readInputStreamToString(inputStream, "UTF-8");
    }

    public static File readInputStream(InputStream inputStream) {
        String filePath = System.getProperty("java.io.tmpdir", "tmp/");
        filePath = filePath + System.currentTimeMillis() + StringUtil.randomString(8) + ".tmp";
        return FileHelper.readInputStream(inputStream, filePath);
    }

    public static URL toURL(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        URI uri = file.toURI();
        URL url = null;
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)e);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File readInputStream(InputStream inputStream, File file) {
        try {
            FileHelper.validateFile(file);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            int length = -1;
            try {
                int bufferSize = 128;
                byte[] buffer = new byte[bufferSize];
                while ((length = inputStream.read(buffer)) != -1) {
                    if (length != bufferSize) {
                        System.arraycopy(buffer, 0, buffer, 0, length);
                    }
                    outputStream.write(buffer);
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    outputStream.flush();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return null;
        }
        return file;
    }

    public static File readInputStream(InputStream inputStream, String path) {
        File file = new File(path);
        return FileHelper.readInputStream(inputStream, file);
    }

    public static String readFileToString(String fileName) {
        return FileHelper.readFileToString(new File(fileName));
    }

    public static String readFileToString(File file) {
        byte[] bts = null;
        try {
            bts = FileHelper.readFileToBytes(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = null;
        try {
            content = new String(bts, FileHelper.getEncode(file));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return content;
    }

    public static String getEncode(File file) {
        return FileEncode.getEncodeByUtil((File)file);
    }

    public static File validateFile(File file) throws Exception {
        if (file != null) {
            if (file.isDirectory()) {
                if (!file.exists()) {
                    file.mkdirs();
                }
            } else {
                File parentFolder = file.getParentFile();
                if (parentFolder != null && !parentFolder.exists()) {
                    parentFolder.mkdirs();
                }
                file.createNewFile();
            }
        } else {
            throw new Exception("\u4f20\u5165 \u7684\u5f15\u7528\u4e3anull\uff01");
        }
        return file;
    }

    public static void copyFile(String originFilePath, String targetFilePath) {
        File originFile = new File(originFilePath);
        File targetFile = new File(targetFilePath);
        FileHelper.copyFile(originFile, targetFile);
    }

    public static void copyFile(URL originURL, File targetFile) {
        try {
            FileHelper.copyFile(originURL.openStream(), targetFile);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream inputStream, File targetFile) {
        if (inputStream == null) {
            return;
        }
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        if (!targetFile.exists()) {
            try {
                targetFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(targetFile);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        byte[] buffer = new byte[0x100000];
        try {
            int length = inputStream.read(buffer);
            while (length > 0) {
                byte[] targetBuffer = new byte[length];
                System.arraycopy(buffer, 0, targetBuffer, 0, length);
                ((OutputStream)outputStream).write(targetBuffer);
                length = inputStream.read(buffer);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        finally {
            try {
                outputStream.flush();
                ((OutputStream)outputStream).close();
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File originFile, File targetFile) {
        if (originFile.length() == targetFile.length()) {
            return;
        }
        try {
            FileHelper.validateFile(targetFile);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (!targetFile.exists()) {
            try {
                targetFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(originFile);
            outputStream = new FileOutputStream(targetFile);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        byte[] buffer = new byte[0x100000];
        try {
            int length = ((InputStream)inputStream).read(buffer);
            while (length > 0) {
                byte[] targetBuffer = new byte[length];
                System.arraycopy(buffer, 0, targetBuffer, 0, length);
                ((OutputStream)outputStream).write(targetBuffer);
                length = ((InputStream)inputStream).read(buffer);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        finally {
            try {
                outputStream.flush();
                ((OutputStream)outputStream).close();
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    public static boolean cutFile(File originFile, File targetFile) {
        Assert.notNull(originFile);
        Assert.notNull(targetFile);
        FileHelper.copyFile(originFile, targetFile);
        if (originFile.length() == targetFile.length()) {
            return originFile.delete();
        }
        return false;
    }

    public static void fileNotFullAndExists(File file) throws Exception {
        if (file == null || !file.exists()) {
            throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStreamToBytes(InputStream inputStream) throws Exception {
        byte[] data = null;
        try {
            int bufferSize = 128;
            byte[] buffer = new byte[bufferSize];
            int offset = 0;
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            int length = -1;
            while ((length = inputStream.read(buffer)) != -1) {
                if (offset + length > byteBuffer.limit()) {
                    byteBuffer = FileHelper.growByteBuffer(byteBuffer, (int)((double)byteBuffer.limit() * 1.5));
                }
                byteBuffer.put(buffer, 0, length);
                offset += length;
            }
            byteBuffer.flip();
            data = new byte[offset];
            byteBuffer.get(data, 0, offset);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return data;
    }

    public static ByteBuffer growByteBuffer(ByteBuffer byteBuffer, int size) {
        Assert.isTrue(size > byteBuffer.limit(), "\u6269\u5bb9\u7684\u5927\u5c0f\u5c0f\u4e8e\u5df2\u7ecf\u5b58\u5728\u7684\u5b57\u8282\u7f13\u51b2\uff01");
        ByteBuffer byteBufferNew = ByteBuffer.allocate(size);
        byteBuffer.flip();
        byteBufferNew.put(byteBuffer);
        return byteBufferNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToBytes(File iconFile) throws Exception {
        try {
            FileHelper.validateFile(iconFile);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        long fileSize = iconFile.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new Exception("\u8bfb\u53d6\u7684\u6587\u4ef6\u8fc7\u5927\uff01");
        }
        byte[] data = new byte[(int)fileSize];
        try {
            int length = -1;
            FileInputStream inputStream = new FileInputStream(iconFile);
            try {
                int bufferSize = 128;
                byte[] buffer = new byte[bufferSize];
                int offset = 0;
                while ((length = inputStream.read(buffer)) != -1) {
                    System.arraycopy(buffer, 0, data, offset, length);
                    offset += length;
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return null;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeBytesToFile(byte[] data, File file) {
        try {
            FileHelper.validateFile(file);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            outputStream.write(data);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOGGER.error((Object)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error((Object)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error((Object)e);
                }
            }
        }
        return file;
    }

    public static File writeStringToFile(File file, String string) {
        try {
            byte[] bts = string.getBytes(FileHelper.getEncode(file));
            file = FileHelper.writeBytesToFile(bts, file);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            LOGGER.error((Object)e);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeObjectToFile(File targetFile, Serializable serializable) {
        block7: {
            FileOutputStream fileOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(targetFile);
                try {
                    objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeObject(serializable);
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
                FileHelper.closeOutStream(objectOutputStream);
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)e);
                break block7;
            }
            finally {
                FileHelper.closeOutStream(objectOutputStream);
                FileHelper.closeOutStream(fileOutputStream);
            }
            FileHelper.closeOutStream(fileOutputStream);
        }
    }

    public static void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    public static void closeOutStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.flush();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
            try {
                outputStream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unSerializeObjectFromFile(File targetFile) {
        Object object;
        block9: {
            FileInputStream fileInputStream = null;
            ObjectInputStream objectInputStream = null;
            object = null;
            try {
                fileInputStream = new FileInputStream(targetFile);
                try {
                    objectInputStream = new ObjectInputStream(fileInputStream);
                    try {
                        object = objectInputStream.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.error((Object)e);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                FileHelper.closeInputStream(objectInputStream);
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)e);
                break block9;
            }
            finally {
                FileHelper.closeInputStream(objectInputStream);
                FileHelper.closeInputStream(fileInputStream);
            }
            FileHelper.closeInputStream(fileInputStream);
        }
        return object;
    }

    public static void main(String[] args) {
        File file = new File("C:\\Users\\\u745b\u742a\\Desktop\\test.txt");
        File file_bak = new File("C:\\Users\\\u745b\u742a\\Desktop\\test2.txt");
        String charset = FileHelper.getEncode(file);
        EntityHelper.print(charset);
        byte[] content = new byte[]{};
        try {
            content = FileHelper.readFileToBytes(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            EntityHelper.print(new String(content, charset));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        FileHelper.writeBytesToFile(content, file_bak);
    }

    public static void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void flushAndCloseWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean initFile(File file) {
        if (file == null) {
            return false;
        }
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            return parentFile.mkdirs();
        }
        return false;
    }
}

