/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.xiongyingqi.util.Assert;
import com.xiongyingqi.util.StackTraceHelper;
import com.xiongyingqi.util.StringHelper;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class EntityHelper {
    public static final Map<Class<?>, Method[]> getMethodCache = new HashMap();
    public static final Map<Class<?>, Class<?>> baseTypePackagingMap = new HashMap();
    public static final Object LOCK;
    private static Map<Class<?>, Object> singletonMap;

    public static Type[] getGenericTypes(Class<?> clazz) {
        Type mySuperClass = clazz.getGenericSuperclass();
        System.out.println(mySuperClass);
        System.out.println(mySuperClass.getClass());
        Type[] types = ((ParameterizedType)mySuperClass).getActualTypeArguments();
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            System.out.println(type);
        }
        return types;
    }

    public static String[] getClassFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        int length = fields.length;
        String[] fieldNames = new String[length];
        for (int i = 0; i < length; ++i) {
            Field field = fields[i];
            fieldNames[i] = field.getName();
        }
        return fieldNames;
    }

    public static Collection<String> getUnstaticClassFieldNameCollection(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("\u4f20\u5165\u7684clazz\u4e3a\u7a7a\u5bf9\u8c61\uff01");
        }
        Field[] fields = clazz.getDeclaredFields();
        int length = fields.length;
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            Field field = fields[i];
            if (Modifier.isStatic(field.getModifiers())) continue;
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }

    public static String[] getUnstaticClassFields(Class<?> clazz) {
        return EntityHelper.getUnstaticClassFieldNameCollection(clazz).toArray(new String[0]);
    }

    public static String[] getClassSimpleFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        int length = fields.length;
        ArrayList<Field> fieldCollection = new ArrayList<Field>();
        for (int i = 0; i < length; ++i) {
            Field field = fields[i];
            if (!EntityHelper.isSimpleType(field)) continue;
            fieldCollection.add(field);
        }
        String[] fieldNames = new String[fieldCollection.size()];
        int i = 0;
        for (Field field : fieldCollection) {
            fieldNames[i] = field.getName();
            ++i;
        }
        return fieldNames;
    }

    public static String getFieldNameByGetMethod(Method method) {
        Assert.notNull(method);
        String methodName = method.getName();
        EntityHelper.print(methodName);
        if (methodName.startsWith("get")) {
            String name = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            return name;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T getSingleton(Class<T> clazz, Object ... args) throws Exception {
        Object instance = null;
        Object object = LOCK;
        synchronized (object) {
            instance = singletonMap.get(clazz);
            if (instance == null) {
                Constructor<?> constructor = null;
                try {
                    constructor = EntityHelper.getConstructor(clazz, args);
                }
                catch (SecurityException e1) {
                }
                catch (NoSuchMethodException e1) {
                    // empty catch block
                }
                if (constructor != null) {
                    try {
                        instance = constructor.newInstance(args);
                    }
                    catch (IllegalArgumentException e) {
                    }
                    catch (InstantiationException e) {
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                if (instance == null) {
                    Constructor<?>[] constructors = clazz.getConstructors();
                    for (int i = 0; i < constructors.length; ++i) {
                        Constructor<?> constructorVar = constructors[i];
                        try {
                            instance = constructorVar.newInstance(args);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            continue;
                        }
                        catch (InstantiationException e) {
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            continue;
                        }
                        catch (InvocationTargetException e) {
                            // empty catch block
                        }
                    }
                }
                if (instance == null) {
                    throw new NoSuchMethodException("\u65e0\u6cd5\u521d\u59cb\u5316\u5bf9\u8c61: " + clazz + "; \u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u543b\u5408");
                }
            }
            singletonMap.put(clazz, instance);
        }
        return (T)instance;
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Object ... args) throws SecurityException, NoSuchMethodException {
        Constructor<?> constructor = null;
        int length = args.length;
        Class[] classes = new Class[length];
        for (int i = 0; i < length; ++i) {
            Object object = args[i];
            classes[i] = object.getClass();
        }
        constructor = clazz.getConstructor(classes);
        return constructor;
    }

    public static Method getMethod(Class<? extends Object> clazz, String methodName, Object ... args) throws SecurityException, NoSuchMethodException {
        Method method = null;
        int length = args.length;
        Class[] classes = new Class[length];
        for (int i = 0; i < length; ++i) {
            Object object = args[i];
            classes[i] = object.getClass();
        }
        try {
            method = clazz.getDeclaredMethod(methodName, classes);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (method == null && args.length > 0) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method methodVar = methods[i];
                Class<?>[] types = methodVar.getParameterTypes();
                boolean isThisMethod = false;
                if (types.length == args.length) {
                    isThisMethod = true;
                    for (int j = 0; j < types.length && isThisMethod; ++j) {
                        Class<?> type = types[j];
                        Object parameter = args[j];
                        if (EntityHelper.typeEquals(type, parameter)) continue;
                        isThisMethod = false;
                    }
                }
                if (!isThisMethod) continue;
                method = methodVar;
                break;
            }
        }
        return method;
    }

    public static Method getMethodOfBeanByField(Class<?> clazz, Field field) {
        Method method = EntityHelper.prefixMethodOfBeanByField("get", clazz, field, new Class[0]);
        if (method == null && (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE))) {
            method = EntityHelper.prefixMethodOfBeanByField("is", clazz, field, new Class[0]);
        }
        return method;
    }

    public static Method setMethodOfBeanByField(Class<?> clazz, Field field) {
        return EntityHelper.prefixMethodOfBeanByField("set", clazz, field, field.getType());
    }

    public static Method prefixMethodOfBeanByField(String prefix, Class<?> clazz, Field field, Class<?> ... argTypes) {
        Method method = null;
        String fieldName = field.getName();
        StringBuilder builder = new StringBuilder(prefix);
        builder.append(fieldName.substring(0, 1).toUpperCase());
        builder.append(fieldName.substring(1, fieldName.length()));
        String methodName = builder.toString();
        try {
            method = clazz.getDeclaredMethod(methodName, argTypes);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return method;
    }

    private static String reflectToString2(Object object) {
        int superLength;
        int length;
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        Class<?> superClazz = clazz.getSuperclass();
        StringBuilder builder = new StringBuilder(clazz.getName());
        builder.append("@");
        builder.append(object.hashCode());
        builder.append("[");
        Field[] fields = clazz.getDeclaredFields();
        Field[] superFields = superClazz.getDeclaredFields();
        int countLength = length = fields.length;
        for (int i = 0; i < length; ++i) {
            Field field = fields[i];
            if (Modifier.isStatic(field.getModifiers())) {
                --countLength;
                continue;
            }
            String fieldName = field.getName();
            String methodGet = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1, fieldName.length());
            try {
                Method method = clazz.getDeclaredMethod(methodGet, new Class[0]);
                try {
                    Object value = method.invoke(object, new Object[0]);
                    builder.append(fieldName);
                    builder.append("=");
                    if (value == null) {
                        builder.append("<null>");
                    } else if (value.getClass().isArray()) {
                        int arrayLength = Array.getLength(value);
                        builder.append("{");
                        for (int j = 0; j < arrayLength; ++j) {
                            Object object2 = Array.get(value, j);
                            builder.append(object2.toString());
                            if (j >= arrayLength - 1) continue;
                            builder.append(", ");
                        }
                        builder.append("}");
                    } else {
                        builder.append(value.toString());
                    }
                    if (i >= countLength - 1) continue;
                    builder.append(", ");
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {}
                continue;
            }
            catch (SecurityException e) {
                continue;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        countLength = superLength = superFields.length;
        for (int i = 0; i < superLength; ++i) {
            Field field = superFields[i];
            if (Modifier.isStatic(field.getModifiers())) {
                --countLength;
                continue;
            }
            if (countLength > 0) {
                builder.append(", ");
            }
            String fieldName = field.getName();
            String methodGet = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1, fieldName.length());
            try {
                Method method = superClazz.getDeclaredMethod(methodGet, new Class[0]);
                try {
                    Object value = method.invoke(object, new Object[0]);
                    builder.append(fieldName);
                    builder.append("=");
                    if (value == null) {
                        builder.append("<null>");
                    } else if (value.getClass().isArray()) {
                        int arraysuperLength = Array.getLength(value);
                        builder.append("{");
                        for (int j = 0; j < arraysuperLength; ++j) {
                            Object object2 = Array.get(value, j);
                            builder.append(object2.toString());
                            if (j >= arraysuperLength - 1) continue;
                            builder.append(", ");
                        }
                        builder.append("}");
                    } else {
                        builder.append(value.toString());
                    }
                    if (i >= countLength - 1) continue;
                    builder.append(", ");
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {}
                continue;
            }
            catch (SecurityException e) {
                continue;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static Collection<Class> getAllSuperClassesOfClass(Class clazz) {
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
        classes.add(clazz);
        for (Class superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            classes.add(superClass);
        }
        return classes;
    }

    public static String reflectToString(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        StringBuilder builder = new StringBuilder(clazz.getName());
        builder.append("@");
        builder.append(Integer.toHexString(object.hashCode()));
        builder.append("[");
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        Collection<Class> classes = EntityHelper.getAllSuperClassesOfClass(clazz);
        for (Class claxx : classes) {
            Method[] clazzMethods = claxx.getDeclaredMethods();
            for (int i = 0; i < clazzMethods.length; ++i) {
                Method method = clazzMethods[i];
                methods.add(method);
            }
        }
        for (Method method : methods) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") && !methodName.startsWith("is") || Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
            try {
                Object value = method.invoke(object, new Object[0]);
                String propertyName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                if (propertyName.equals("class")) continue;
                builder.append(propertyName);
                builder.append("=");
                if (value == null) {
                    builder.append("<null>");
                } else if (value.getClass().isArray()) {
                    int arraysuperLength = Array.getLength(value);
                    builder.append("{");
                    for (int j = 0; j < arraysuperLength; ++j) {
                        Object object2 = Array.get(value, j);
                        builder.append(object2.toString());
                        if (j >= arraysuperLength - 1) continue;
                        builder.append(", ");
                    }
                    builder.append("}");
                } else {
                    builder.append(value.toString());
                }
                builder.append(", ");
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {}
        }
        if (builder.toString().contains(", ")) {
            builder.replace(builder.length() - 2, builder.length(), "");
        }
        builder.append("]");
        return builder.toString();
    }

    public static String simpleReflectToString(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        Class<?> superClazz = clazz.getSuperclass();
        StringBuilder builder = new StringBuilder(clazz.getName());
        builder.append("@");
        builder.append(Integer.toHexString(object.hashCode()));
        builder.append("[");
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName;
            Method method = methods[i];
            if (!EntityHelper.isSimpleType(method.getReturnType()) || !(methodName = method.getName()).startsWith("get") || Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
            try {
                Object value = method.invoke(object, new Object[0]);
                String propertyName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                builder.append(propertyName);
                builder.append("=");
                if (value == null) {
                    builder.append("<null>");
                } else if (value.getClass().isArray()) {
                    int arraysuperLength = Array.getLength(value);
                    builder.append("{");
                    for (int j = 0; j < arraysuperLength; ++j) {
                        Object object2 = Array.get(value, j);
                        builder.append(object2.toString());
                        if (j >= arraysuperLength - 1) continue;
                        builder.append(", ");
                    }
                    builder.append("}");
                } else {
                    builder.append(value.toString());
                }
                builder.append(", ");
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (builder.toString().contains(", ")) {
            builder.replace(builder.length() - 2, builder.length(), "");
        }
        builder.append("]");
        return builder.toString();
    }

    private static String simpleReflectToString2(Object object) {
        int superLength;
        int length;
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        Class<?> superClazz = clazz.getSuperclass();
        StringBuilder builder = new StringBuilder(clazz.getName());
        builder.append("@");
        builder.append(Integer.toHexString(object.hashCode()));
        builder.append("[");
        Field[] fields = clazz.getDeclaredFields();
        Field[] superFields = superClazz.getDeclaredFields();
        int countLength = length = fields.length;
        for (int i = 0; i < length; ++i) {
            Field field = fields[i];
            if (Modifier.isStatic(field.getModifiers()) || !EntityHelper.isSimpleType(field)) {
                --countLength;
                continue;
            }
            String fieldName = field.getName();
            String methodGet = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1, fieldName.length());
            try {
                Method method = clazz.getDeclaredMethod(methodGet, new Class[0]);
                try {
                    Object value = method.invoke(object, new Object[0]);
                    builder.append(fieldName);
                    builder.append("=");
                    if (value == null) {
                        builder.append("<null>");
                    } else if (value.getClass().isArray()) {
                        int arrayLength = Array.getLength(value);
                        builder.append("{");
                        for (int j = 0; j < arrayLength; ++j) {
                            Object object2 = Array.get(value, j);
                            builder.append(object2.toString());
                            if (j >= countLength - 1) continue;
                            builder.append(", ");
                        }
                        builder.append("}");
                    } else {
                        builder.append(value.toString());
                    }
                    builder.append(", ");
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {}
                continue;
            }
            catch (SecurityException e) {
                continue;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (builder.toString().contains(", ")) {
            builder.replace(builder.length() - 2, builder.length(), "");
        }
        countLength = superLength = superFields.length;
        for (int i = 0; i < superLength; ++i) {
            Field field = superFields[i];
            if (Modifier.isStatic(field.getModifiers()) || !EntityHelper.isSimpleType(field)) {
                --countLength;
                continue;
            }
            if (countLength > 0) {
                builder.append(", ");
            }
            String fieldName = field.getName();
            String methodGet = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1, fieldName.length());
            try {
                Method method = superClazz.getDeclaredMethod(methodGet, new Class[0]);
                try {
                    Object value = method.invoke(object, new Object[0]);
                    builder.append(fieldName);
                    builder.append("=");
                    if (value == null) {
                        builder.append("<null>");
                    } else if (value.getClass().isArray()) {
                        int arraysuperLength = Array.getLength(value);
                        builder.append("{");
                        for (int j = 0; j < arraysuperLength; ++j) {
                            Object object2 = Array.get(value, j);
                            builder.append(object2.toString());
                            if (j >= arraysuperLength - 1) continue;
                            builder.append(", ");
                        }
                        builder.append("}");
                    } else {
                        builder.append(value.toString());
                    }
                    if (i >= countLength - 1) continue;
                    builder.append(", ");
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {}
                continue;
            }
            catch (SecurityException e) {
                continue;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static boolean typeEquals(Class<?> type, Object parameter) {
        Class<?> paramenterClass = parameter.getClass();
        if (EntityHelper.isSimpleType(paramenterClass) && EntityHelper.isSimpleType(type) && EntityHelper.getPackagingType(type).asSubclass(EntityHelper.getPackagingType(paramenterClass)) != null) {
            return true;
        }
        return type.isInstance(parameter);
    }

    public static Class<?> getPackagingType(Class<?> clazz) {
        return baseTypePackagingMap.get(clazz);
    }

    public static boolean isSimpleType(Field field) {
        if (field == null) {
            return false;
        }
        return EntityHelper.isSimpleType(field.getType());
    }

    public static boolean isSimpleType(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.equals(Boolean.class)) {
            return true;
        }
        if (clazz.equals(Float.class)) {
            return true;
        }
        if (clazz.equals(Long.class)) {
            return true;
        }
        if (clazz.equals(Double.class)) {
            return true;
        }
        if (clazz.equals(Byte.class)) {
            return true;
        }
        if (clazz.equals(Integer.class)) {
            return true;
        }
        if (clazz.equals(Short.class)) {
            return true;
        }
        if (clazz.equals(Character.class)) {
            return true;
        }
        if (clazz.equals(BigInteger.class)) {
            return true;
        }
        if (clazz.equals(BigDecimal.class)) {
            return true;
        }
        if (clazz.equals(String.class)) {
            return true;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return true;
        }
        if (clazz.equals(Float.TYPE)) {
            return true;
        }
        if (clazz.equals(Long.TYPE)) {
            return true;
        }
        if (clazz.equals(Double.TYPE)) {
            return true;
        }
        if (clazz.equals(Byte.TYPE)) {
            return true;
        }
        if (clazz.equals(Integer.TYPE)) {
            return true;
        }
        if (clazz.equals(Short.TYPE)) {
            return true;
        }
        return clazz.equals(Character.TYPE);
    }

    public static Method findGetMethod(Field field) {
        Method[] methods;
        Class<?> inClass = field.getDeclaringClass();
        for (Method method : methods = inClass.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            String name = method.getName();
            if (name.startsWith("get") && name.toLowerCase().equals("get" + field.getName().toLowerCase())) {
                return method;
            }
            if (!name.startsWith("is") || field.getType() != Boolean.class && field.getType() != Boolean.TYPE && field.getType() != Byte.TYPE && field.getType() != Byte.class || !name.toLowerCase().equals("is" + field.getName().toLowerCase()) && !name.toLowerCase().equals(field.getName().toLowerCase())) continue;
            return method;
        }
        return null;
    }

    public static Method findSetMethod(Field field) {
        Method[] methods;
        Class<?> inClass = field.getDeclaringClass();
        for (Method method : methods = inClass.getDeclaredMethods()) {
            String name;
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || !(name = method.getName()).startsWith("set") || !name.toLowerCase().equals("set" + field.getName().toLowerCase())) continue;
            return method;
        }
        return null;
    }

    public static boolean arrayEquals(Object one, Object anotherOne) {
        if (one == null || anotherOne == null) {
            return false;
        }
        if (!one.getClass().equals(anotherOne.getClass()) || !one.getClass().isArray()) {
            return false;
        }
        if (Array.getLength(one) != Array.getLength(anotherOne)) {
            return false;
        }
        return EntityHelper.arrayHashCode(one) == EntityHelper.arrayHashCode(anotherOne);
    }

    public static int arrayHashCode(Object array) {
        int hashCode = 0;
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object one = Array.get(array, i);
            hashCode = hashCode * 31 + (one == null ? 0 : one.hashCode());
        }
        return hashCode;
    }

    private static Method[] getMethodsInClass(Class<?> clazz) {
        Method[] methods = getMethodCache.get(clazz);
        if (methods == null) {
            ArrayList<Method> methodList = new ArrayList<Method>();
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (Modifier.isStatic(field.getModifiers())) continue;
                String fieldName = field.getName();
                String methodGet = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1, fieldName.length());
                try {
                    Method method = clazz.getDeclaredMethod(methodGet, new Class[0]);
                    methodList.add(method);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Class<?> superClazz = clazz.getSuperclass();
            Field[] superFields = superClazz.getDeclaredFields();
            for (int i = 0; i < superFields.length; ++i) {
                Field field = superFields[i];
                if (Modifier.isStatic(field.getModifiers())) continue;
                String fieldName = field.getName();
                String methodGet = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1, fieldName.length());
                try {
                    Method method = superClazz.getDeclaredMethod(methodGet, new Class[0]);
                    methodList.add(method);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (methodList.size() > 0) {
                methods = methodList.toArray(new Method[0]);
                getMethodCache.put(clazz, methods);
            }
        }
        return methods;
    }

    public static int hashCode(Object object) {
        Method[] methodsInClass;
        if (object == null) {
            return 0;
        }
        int hashCode = 17;
        Class<?> clazz = object.getClass();
        for (Method method : methodsInClass = EntityHelper.getMethodsInClass(clazz)) {
            try {
                Object value = method.invoke(object, new Object[0]);
                if (method.getReturnType().isArray()) {
                    hashCode = hashCode * 31 + (value == null ? 0 : EntityHelper.arrayHashCode(value));
                    continue;
                }
                hashCode = hashCode * 31 + (value == null ? 0 : value.hashCode());
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        return hashCode;
    }

    public static boolean equals(Object origin, Object target) {
        boolean isEquals = false;
        isEquals = origin == null ? target == null : (target == null ? false : (origin.getClass() == target.getClass() ? origin.hashCode() == target.hashCode() : false));
        return isEquals;
    }

    public static void printDetail(Object object) {
        StackTraceElement[] stackTraceElements = StackTraceHelper.getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElements[2];
        StringBuilder builder = new StringBuilder();
        builder.append(" ------------------------------------------------------------ ");
        builder.append(StringHelper.line());
        builder.append(StackTraceHelper.buildStackTrace(new StackTraceElement[]{stackTraceElement}));
        builder.append("    ");
        if (object == null) {
            builder.append("<null>");
        } else {
            builder.append(object.getClass().getSimpleName());
            builder.append(" =============== ");
            builder.append(EntityHelper.reflectToString(object));
        }
        builder.append(StringHelper.line());
        builder.append(" ------------------------------------------------------------ ");
        System.out.println(builder.toString());
    }

    public static void print(Object object) {
        StackTraceElement[] stackTraceElements = StackTraceHelper.getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElements[2];
        StringBuilder builder = new StringBuilder();
        builder.append(" ------------------------------------------------------------ ");
        builder.append(StringHelper.line());
        builder.append(StackTraceHelper.buildStackTrace(new StackTraceElement[]{stackTraceElement}));
        builder.append("    ");
        if (object == null) {
            builder.append("<null>");
        } else {
            builder.append(object.getClass().getSimpleName());
            builder.append(" =============== ");
            builder.append(EntityHelper.buildObjectToString(object));
        }
        builder.append(StringHelper.line());
        builder.append(" ------------------------------------------------------------ ");
        System.out.println(builder.toString());
    }

    public static void print() {
        StackTraceElement[] stackTraceElements = StackTraceHelper.getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElements[2];
        StringBuilder builder = new StringBuilder();
        builder.append(" ------------------------------------------------------------ ");
        builder.append(StringHelper.line());
        builder.append(StackTraceHelper.buildStackTrace(new StackTraceElement[]{stackTraceElement}));
        builder.append("    ");
        builder.append(StringHelper.line());
        builder.append(" ------------------------------------------------------------ ");
        System.out.println(builder.toString());
    }

    public static String buildObjectToString(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        StringBuilder builder = new StringBuilder();
        if (clazz.isArray()) {
            builder.append("[");
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                Object one = Array.get(object, i);
                builder.append(EntityHelper.buildObjectToString(one));
                if (i >= length - 1) continue;
                builder.append(", ");
            }
            builder.append("]");
        } else {
            builder.append(object.toString());
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        return EntityHelper.equals(this, obj);
    }

    public int hashCode() {
        return EntityHelper.hashCode(this);
    }

    private String reflectToString() {
        return EntityHelper.reflectToString(this);
    }

    public String toString() {
        return this.reflectToString();
    }

    public static String getClassToBeanName(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        String firstWord = simpleName.substring(0, 1).toLowerCase();
        String otherWords = simpleName.substring(1);
        return firstWord + otherWords;
    }

    public static Object getFieldValue(Object object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Assert.notNull(object);
        Class<?> clazz = object.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(object);
    }

    public static void main(String[] args) throws NoSuchFieldException, IllegalAccessException {
        String str = "asf";
        System.out.println(EntityHelper.getFieldValue(str, "hash"));
        String[] as = new String[]{"af", "asf"};
        EntityHelper.print(as);
        ArrayList<String> strs = new ArrayList<String>();
        strs.add("asf");
        strs.add("asdf");
        strs.add("ff");
        strs.add("asf");
        EntityHelper.print(strs);
    }

    static {
        baseTypePackagingMap.put(Integer.TYPE, Integer.class);
        baseTypePackagingMap.put(Long.TYPE, Long.class);
        baseTypePackagingMap.put(Double.TYPE, Double.class);
        baseTypePackagingMap.put(Float.TYPE, Float.class);
        baseTypePackagingMap.put(Boolean.TYPE, Boolean.class);
        baseTypePackagingMap.put(Character.TYPE, Character.class);
        baseTypePackagingMap.put(Byte.TYPE, Byte.class);
        baseTypePackagingMap.put(Short.TYPE, Short.class);
        baseTypePackagingMap.put(Integer.class, Integer.class);
        baseTypePackagingMap.put(Long.class, Long.class);
        baseTypePackagingMap.put(Double.class, Double.class);
        baseTypePackagingMap.put(Float.class, Float.class);
        baseTypePackagingMap.put(Boolean.class, Boolean.class);
        baseTypePackagingMap.put(Character.class, Character.class);
        baseTypePackagingMap.put(Byte.class, Byte.class);
        baseTypePackagingMap.put(Short.class, Short.class);
        LOCK = new Object();
        singletonMap = new HashMap();
    }
}

