/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.xiongyingqi.util.ByteHelper;
import java.util.Random;

public class DynamicPassword {
    public static final int KEY_LENGTH = 16;
    private static final int SECOND = 1000;
    public static final int DEFAULT_REFRESH_TIME = 4;

    public byte[] generateKey(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("\u957f\u5ea6\u4e3a\uff1a" + length + "\uff0c \u6307\u5b9a\u7684\u5bc6\u94a5\u957f\u5ea6\u9519\u8bef\uff01");
        }
        byte[] bts = new byte[length];
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            bts[i] = (byte)random.nextInt(255);
        }
        return bts;
    }

    public byte[] getTimeBytes() {
        return this.getTimeBytes(4);
    }

    public byte[] getTimeBytes(int seconds) {
        if (seconds <= 0) {
            throw new IllegalArgumentException("\u79d2\u6570\u4e3a\uff1a" + seconds + "\uff0c \u6307\u5b9a\u7684\u5bc6\u94a5\u66f4\u65b0\u5468\u671f\u9519\u8bef\uff01");
        }
        long currentTimeMillis = System.currentTimeMillis();
        return ByteHelper.longToBytes(currentTimeMillis /= (long)(seconds * 1000));
    }

    public byte[] generateCode(byte[] key, int refreshTime) {
        byte[] bs = this.getTimeBytes(refreshTime);
        int length = bs.length;
        for (int i = 0; i < length; ++i) {
            byte b = bs[i];
            for (int j = 0; j < length; ++j) {
                bs[i] = (byte)(bs[j] | b);
                bs[i] = (byte)(bs[j] ^ b);
            }
        }
        int keyLength = key.length;
        byte[] rs = new byte[keyLength];
        System.arraycopy(key, 0, rs, 0, keyLength);
        for (int i = 0; i < keyLength; ++i) {
            byte k = rs[i];
            for (int j = 0; j < length; ++j) {
                rs[i] = (byte)(bs[j] ^ k);
                rs[i] = (byte)(bs[j] | k);
            }
        }
        return rs;
    }

    public long bytesToLong(byte[] bts) {
        int inputLength = bts.length;
        long data = 0L;
        long temp = 0L;
        for (int i = 0; i < inputLength; ++i) {
            data <<= 8;
            byte b = bts[i];
            temp = b & 0xFF;
            data |= temp;
        }
        return data;
    }

    public byte[] compressBytes(byte[] bts, int length) {
        int inputLength = bts.length;
        if (inputLength < length) {
            throw new ArrayIndexOutOfBoundsException("\u65e0\u6cd5\u538b\u7f29\uff1a\u76ee\u6807\u53c2\u6570length\u5c0f\u4e8ebts\u7684\u957f\u5ea6\uff01");
        }
        float multiple = inputLength / length;
        int leastLength = inputLength % length;
        int index = 0;
        int i = 0;
        byte[] rs = new byte[length];
        while (i < length) {
            byte bt = 0;
            int j = 0;
            while ((float)j < multiple) {
                bt = (byte)(bt + bts[index++]);
                ++j;
            }
            rs[i++] = bt;
        }
        for (int j = 0; j < length; ++j) {
            for (int k = 0; k < leastLength; ++k) {
                int n = j;
                rs[n] = (byte)(rs[n] ^ bts[index + k]);
            }
        }
        return rs;
    }

    public void printBytes(byte[] bts) {
        for (int i = 0; i < bts.length; ++i) {
            byte b = bts[i];
            System.out.println(b);
        }
    }

    public long generatePassword(byte[] key, int refreshTime) {
        int minApproach = DynamicPassword.minApproach(6);
        int i = minApproach / 8;
        if (minApproach % 8 > 0) {
            ++i;
        }
        byte[] rs = this.generateCode(key, refreshTime);
        byte[] data = this.compressBytes(rs, i);
        long code = this.bytesToLong(data);
        long l = code & 0xF423FL;
        return l;
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 10) {
            final int j = i++;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    DynamicPassword dynamicPassword = new DynamicPassword();
                    byte[] key = dynamicPassword.generateKey(16);
                    while (true) {
                        System.out.println(j + "\u5f53\u524d\u52a8\u6001\u5bc6\u7801\uff1a" + dynamicPassword.generatePassword(key, 4));
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.start();
        }
    }

    public static int minApproach(int digit) {
        int max = (int)(Math.pow(10.0, digit) - 1.0);
        int i = 0;
        while (max > 0) {
            max >>= 1;
            ++i;
        }
        return i;
    }
}

