/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.xiongyingqi.util.Assert;
import com.xiongyingqi.util.DateHelper;
import com.xiongyingqi.util.FileHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ConsoleHelper {
    private File file;
    private OutputStream outputStream;
    private PipedInputStream pipedInputStream;
    private boolean isSetPipedInputStream;
    private boolean running;
    private FileStrategy fileStrategy;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
    private long nextCheckTime = new Date().getTime();
    private long maxFileSize = 0x1E00000L;

    public ConsoleHelper(File file, FileStrategy fileStrategy) {
        Assert.notNull(file);
        this.file = file;
        if (fileStrategy == null) {
            fileStrategy = FileStrategy.DAILY;
        }
        this.fileStrategy = fileStrategy;
        FileHelper.initFile(file);
        try {
            this.outputStream = new FileOutputStream(file, true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.init();
    }

    public ConsoleHelper(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.init();
    }

    public ConsoleHelper(PipedInputStream pipedInputStream) {
        this.pipedInputStream = pipedInputStream;
        this.isSetPipedInputStream = true;
        this.init();
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void init() {
        if (this.pipedInputStream == null) {
            this.isSetPipedInputStream = false;
            this.pipedInputStream = new PipedInputStream();
        }
        PipedOutputStream pipedOS = new PipedOutputStream();
        try {
            pipedOS.connect(this.pipedInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrintStream ps = new PrintStream(pipedOS);
        System.setOut(ps);
        System.setErr(ps);
        if (!this.isSetPipedInputStream) {
            this.running = true;
            ReadThread readThread = new ReadThread();
            readThread.start();
        }
    }

    public void stop() {
        this.running = false;
    }

    private void append(byte[] bts) {
        this.checkFile();
        try {
            this.outputStream.write(bts);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkFile() {
        if (this.fileStrategy != null) {
            long length;
            if (this.fileStrategy == FileStrategy.DAILY && System.currentTimeMillis() >= this.nextCheckTime) {
                long l = this.file.lastModified();
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(l);
                int i = DateHelper.diffOfDay(calendar.getTime(), new Date());
                if (i != 0) {
                    this.renameFile();
                }
                Date day = DateHelper.getDay(new Date());
                Calendar calendarTomorrow = Calendar.getInstance();
                calendarTomorrow.setTimeInMillis(day.getTime());
                calendarTomorrow.set(6, calendarTomorrow.get(6) + 1);
                this.nextCheckTime = calendarTomorrow.getTimeInMillis();
            } else if (this.fileStrategy == FileStrategy.MAX_SIZE && (length = this.file.length()) > this.maxFileSize) {
                this.renameFile();
            }
        }
    }

    private void renameFile() {
        long l = this.file.lastModified();
        Date date = new Date(l);
        String dateToStr = this.dateFormat.format(date);
        String fileName = this.file.getName();
        String parent = this.file.getParent();
        File newFile = new File(fileName + "." + dateToStr);
        try {
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean b = this.file.renameTo(newFile);
        if (b) {
            this.file = new File(parent, fileName);
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public File[] listFiles() {
        final String fileName = this.file.getName();
        File parentFile = this.file.getParentFile();
        File[] files = parentFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(fileName + ".");
            }
        });
        return files;
    }

    public static void main(String[] args) throws FileNotFoundException {
        final PipedInputStream pipedIS = new PipedInputStream();
        PipedOutputStream pipedOS = new PipedOutputStream();
        Thread thread = new Thread(){

            @Override
            public void run() {
                int bufferLength = 1024;
                byte[] bts = new byte[bufferLength];
                try {
                    while (true) {
                        int length;
                        if ((length = pipedIS.read(bts, 0, bufferLength)) == -1) {
                            continue;
                        }
                        byte[] data = new byte[length];
                        System.arraycopy(bts, 0, data, 0, length);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        };
        thread.start();
        try {
            pipedOS.connect(pipedIS);
        }
        catch (IOException e) {
            System.err.println("\u8fde\u63a5\u5931\u8d25");
            System.exit(1);
        }
        PrintStream ps = new PrintStream(new FileOutputStream(new File("out.txt")));
        System.setOut(ps);
        System.setErr(ps);
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < 1000; ++i) {
                    System.out.println("\u5475\u5475" + i);
                }
            }
        };
        thread2.start();
    }

    class ReadThread
    extends Thread {
        ReadThread() {
        }

        @Override
        public void run() {
            int bufferLength = 1024;
            byte[] bts = new byte[bufferLength];
            try {
                while (ConsoleHelper.this.running) {
                    int length = ConsoleHelper.this.pipedInputStream.read(bts, 0, bufferLength);
                    if (length == -1) continue;
                    byte[] data = new byte[length];
                    System.arraycopy(bts, 0, data, 0, length);
                    ConsoleHelper.this.append(data);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum FileStrategy {
        DAILY,
        MAX_SIZE;

    }
}

