/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Random;

public class ComparatorHelper<T> {
    public List sortByNumber(Collection<? extends T> collection, final boolean asc) {
        ArrayList<? extends T> list = new ArrayList<T>();
        list.addAll(collection);
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int result = 0;
                if (o1 instanceof Number && o1 instanceof Number) {
                    Number number1 = (Number)o1;
                    Number number2 = (Number)o2;
                    if (number1.hashCode() < number2.hashCode()) {
                        result = -1;
                    } else if (number1.hashCode() > number2.hashCode()) {
                        result = -1;
                    }
                    if (!asc) {
                        result = -result;
                    }
                }
                return result;
            }
        });
        return list;
    }

    public List sortByDateTime(Collection<? extends T> collection, final Field field, final boolean asc) {
        if (collection == null) {
            return null;
        }
        ArrayList<? extends T> list = new ArrayList<T>();
        list.addAll(collection);
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Object object = ComparatorHelper.this.invokeMethod(o1, field);
                Object object2 = ComparatorHelper.this.invokeMethod(o2, field);
                if (object == null || object2 == null) {
                    return 0;
                }
                int value = 0;
                if (object instanceof Date) {
                    Date v1 = (Date)object;
                    Date v2 = (Date)object2;
                    if (v1.getTime() < v2.getTime()) {
                        value = -1;
                    } else if (v1.getTime() > v2.getTime()) {
                        value = 1;
                    }
                    if (!asc) {
                        value = -value;
                    }
                }
                return value;
            }
        });
        return list;
    }

    public Collection sortByString(Collection<? extends T> collection, final Field field, final boolean asc) {
        if (collection == null) {
            return null;
        }
        ArrayList<? extends T> list = new ArrayList<T>();
        list.addAll(collection);
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Object object = ComparatorHelper.this.invokeMethod(o1, field);
                Object object2 = ComparatorHelper.this.invokeMethod(o2, field);
                if (object == null || object2 == null) {
                    return 0;
                }
                int value = 0;
                if (object instanceof String) {
                    String v1 = (String)object;
                    String v2 = (String)object2;
                    value = v1.hashCode() < v2.hashCode() ? -1 : 1;
                    if (!asc) {
                        value = -value;
                    }
                }
                return value;
            }
        });
        return list;
    }

    private Object invokeMethod(Object target, Field filed) {
        Object returnObject = null;
        Class<?> clazz = target.getClass();
        String fieldName = filed.getName();
        String methodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            Method method = clazz.getMethod(methodName, new Class[0]);
            returnObject = method.invoke(target, new Object[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return returnObject;
    }

    public static void main(String[] args) {
        Random random = new Random();
        Collection<Test> collection = new ArrayList();
        for (int i = 0; i < 100; ++i) {
            String string = random.nextInt(1000) + "";
            Test test = new Test();
            test.setI(string);
            collection.add(test);
        }
        ComparatorHelper comparatorHelper = new ComparatorHelper();
        try {
            collection = comparatorHelper.sortByString(collection, Test.class.getDeclaredField("i"), true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        for (Test test : collection) {
            System.out.println(test.getI());
        }
    }

    static class Test {
        String i;

        Test() {
        }

        public String getI() {
            return this.i;
        }

        public void setI(String i) {
            this.i = i;
        }

        public int hashCode() {
            return this.i.hashCode();
        }
    }
}

