/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;

public class ClipBoardHelper {
    public static Map<Object, ClipBoardType> getClipBoardTypeMap() {
        LinkedHashMap<Object, ClipBoardType> map = new LinkedHashMap<Object, ClipBoardType>();
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        DataFlavor[] dataFlavors = t.getTransferDataFlavors();
        for (int i = 0; i < dataFlavors.length; ++i) {
            DataFlavor dataFlavor = dataFlavors[i];
            ClipBoardType clipBoardType = ClipBoardHelper.parseType(dataFlavor);
            try {
                Object object = t.getTransferData(dataFlavor);
                if (dataFlavor.isMimeTypeEqual("text/html") && dataFlavor.isRepresentationClassCharBuffer()) {
                    System.out.println(dataFlavor);
                    System.out.println("object.toString() =========== " + object.toString());
                }
                if (clipBoardType == null) continue;
                map.put(object, clipBoardType);
                continue;
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private static ClipBoardType parseType(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            return null;
        }
        ClipBoardType type = null;
        if (dataFlavor.equals(DataFlavor.imageFlavor)) {
            type = ClipBoardType.IMAGE;
        } else if (dataFlavor.isMimeTypeEqual("text/html") && dataFlavor.isRepresentationClassCharBuffer()) {
            type = ClipBoardType.HTML;
        } else if (dataFlavor.isMimeTypeEqual("application/rtf") && dataFlavor.isRepresentationClassInputStream()) {
            type = ClipBoardType.HTML;
        } else if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
            type = ClipBoardType.FILE;
        } else if (dataFlavor.equals(DataFlavor.plainTextFlavor)) {
            type = ClipBoardType.STRINGREADER;
        } else if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            type = ClipBoardType.STRING;
        } else if (dataFlavor.isRepresentationClassInputStream()) {
            type = ClipBoardType.INPUT_STREAM;
        }
        return type;
    }

    public static JLabel[] buildClipBoard() {
        Map<Object, ClipBoardType> map = ClipBoardHelper.getClipBoardTypeMap();
        Set<Map.Entry<Object, ClipBoardType>> entries = map.entrySet();
        ArrayList<1> labels = new ArrayList<1>();
        int i = 0;
        for (Map.Entry<Object, ClipBoardType> entry : entries) {
            Object object = entry.getKey();
            ClipBoardType clipBoardType = entry.getValue();
            JLabel label = null;
            switch (clipBoardType) {
                case IMAGE: {
                    final Image image = (Image)object;
                    label = new JLabel(){
                        {
                            this.setSize(image.getWidth(null), image.getHeight(null));
                        }

                        @Override
                        public void paint(Graphics g) {
                            g.drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
                        }
                    };
                    break;
                }
                case FILE: {
                    break;
                }
                case STRING: {
                    break;
                }
            }
            if (label != null) {
                labels.add(label);
            }
            ++i;
        }
        return labels.toArray(new JLabel[0]);
    }

    public static void main(String[] args) {
        Map<Object, ClipBoardType> map = ClipBoardHelper.getClipBoardTypeMap();
        Set<Map.Entry<Object, ClipBoardType>> entries = map.entrySet();
        for (Map.Entry<Object, ClipBoardType> entry : entries) {
        }
    }

    public static enum ClipBoardType {
        FILE,
        IMAGE,
        STRING,
        STRINGREADER,
        INPUT_STREAM,
        HTML;

    }
}

