/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.xiongyingqi.util.DateHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CalendarHelper {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long MONTH = 2592000000L;
    public static final long YEAR = 31104000000L;
    public static final DateCalculator YEARS_BEFORE = new DateCalculator(31104000000L, 62208000000000L, "{0}\u5e74\u524d");
    public static final DateCalculator MONTHS_BEFORE = new DateCalculator(2592000000L, 31104000000L, "{0}\u4e2a\u6708\u524d");
    public static final DateCalculator DAYS_BEFORE = new DateCalculator(259200000L, 2592000000L, "{0}\u5929\u524d");
    public static final DateCalculator THE_DAY_BEFORE_YESTERDAY = new DateCalculator(172800000L, 259200000L, "\u524d\u5929");
    public static final DateCalculator YESTERDAY = new DateCalculator(86400000L, 172800000L, "\u6628\u5929");
    public static final DateCalculator HOURS_BEFORE = new DateCalculator(3600000L, 86400000L, "{0}\u5c0f\u65f6\u524d");
    public static final DateCalculator HALF_HOUR_BEFORE = new DateCalculator(1800000L, 3600000L, "\u534a\u5c0f\u65f6\u5de6\u53f3");
    public static final DateCalculator JUST_NOW = new DateCalculator(0L, 1800000L, "\u521a\u521a");

    public static long compareDate(Date thenDate) {
        return CalendarHelper.compareDate(new Date(), thenDate);
    }

    public static long compareDate(Date nearDate, Date farDate) {
        long farMilli;
        long nearMilli = nearDate.getTime();
        long result = nearMilli - (farMilli = farDate.getTime());
        if (result < 0L) {
            result = -result;
        }
        return result;
    }

    public static String caculatorDateToString(Date date) {
        long milliSecond = CalendarHelper.compareDate(date);
        List dateCaculators = DateCalculator.getDateCalculators();
        for (DateCalculator dateCalculator : dateCaculators) {
            if (milliSecond < dateCalculator.getMinMilliSecond() || milliSecond > dateCalculator.getMaxMilliSecond()) continue;
            String displayStr = dateCalculator.getDisplayStr();
            long numberOfUnit = 0L;
            numberOfUnit = dateCalculator.getMinMilliSecond() == 0L ? 0L : milliSecond / dateCalculator.getMinMilliSecond();
            Pattern p = Pattern.compile("(\\{.+?\\})");
            Matcher m = p.matcher(displayStr);
            displayStr = m.replaceAll(numberOfUnit + "");
            return displayStr;
        }
        return milliSecond + "";
    }

    public static boolean compareTwoDate(Date beforeDate, Date afterDate) {
        if (beforeDate == null && afterDate == null) {
            return false;
        }
        Calendar beforeCalendar = Calendar.getInstance();
        beforeCalendar.setTime(beforeDate);
        Calendar afterCalendar = Calendar.getInstance();
        afterCalendar.setTime(afterDate);
        return afterCalendar.compareTo(beforeCalendar) > 0;
    }

    public static void main(String[] args) {
        Date date = DateHelper.strToDateLong("2013-04-03 10:44:12");
        String rs = CalendarHelper.caculatorDateToString(date);
        System.out.println(rs);
        Date date2 = DateHelper.strToDateLong("2013-06-02 15:33:12");
        String rs2 = CalendarHelper.caculatorDateToString(date2);
        System.out.println(rs2);
        Date date5 = DateHelper.strToDateLong("2013-06-03 15:33:12");
        String rs5 = CalendarHelper.caculatorDateToString(date5);
        System.out.println(rs5);
        Date date3 = DateHelper.strToDateLong("2012-04-03 10:44:12");
        String rs3 = CalendarHelper.caculatorDateToString(date3);
        System.out.println(rs3);
    }

    static class DateCalculator {
        private long minMilliSecond;
        private long maxMilliSecond;
        private String displayStr;
        private static List dateCalculators;

        public DateCalculator(long minMilliSecond, long maxMilliSecond, String displayStr) {
            this.minMilliSecond = minMilliSecond;
            this.maxMilliSecond = maxMilliSecond;
            this.displayStr = displayStr;
            if (dateCalculators == null) {
                dateCalculators = new ArrayList();
            }
            dateCalculators.add(this);
        }

        public static List getDateCalculators() {
            return dateCalculators;
        }

        public long getMinMilliSecond() {
            return this.minMilliSecond;
        }

        public void setMinMilliSecond(long minMilliSecond) {
            this.minMilliSecond = minMilliSecond;
        }

        public long getMaxMilliSecond() {
            return this.maxMilliSecond;
        }

        public void setMaxMilliSecond(long maxMilliSecond) {
            this.maxMilliSecond = maxMilliSecond;
        }

        public String getDisplayStr() {
            return this.displayStr;
        }
    }
}

