/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.util;

import com.xiongyingqi.util.EntityHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class AnnotationHelper {
    public static <T extends Annotation> boolean isAnnotationType(Class<?> clazz, Class<T> annotationClass) {
        return clazz.isAnnotationPresent(annotationClass);
    }

    public static <T extends Annotation> T readAnnotationValue(Class<?> clazz, Class<T> annotationClass) {
        if (AnnotationHelper.isAnnotationType(clazz, annotationClass)) {
            T t = clazz.getAnnotation(annotationClass);
            return t;
        }
        return null;
    }

    public static <T extends Annotation> T readAnnotationValueOnField(Field field, Class<T> annotationClass) {
        if (field.isAnnotationPresent(annotationClass)) {
            T t = field.getAnnotation(annotationClass);
            return t;
        }
        Method method = EntityHelper.findGetMethod(field);
        if (method.isAnnotationPresent(annotationClass)) {
            T t = method.getAnnotation(annotationClass);
            return t;
        }
        return null;
    }

    public static Collection<? super Annotation> readAnnotationsOnField(Field field) {
        HashSet annotations = new HashSet();
        Annotation[] annotationArray = field.getAnnotations();
        if (annotationArray != null && annotationArray.length > 0) {
            Collections.addAll(annotations, annotationArray);
            return annotations;
        }
        Method method = EntityHelper.findGetMethod(field);
        Annotation[] methodAnnotations = method.getAnnotations();
        if (methodAnnotations != null && methodAnnotations.length > 0) {
            Collections.addAll(annotations, methodAnnotations);
            return annotations;
        }
        return null;
    }

    public static <T extends Annotation> Collection<T> readAnnotationsInClass(Class<?> clazz, Class<T> annotationClass) {
        Field[] fields;
        ArrayList<T> collection = null;
        for (Field field : fields = clazz.getDeclaredFields()) {
            T t = AnnotationHelper.readAnnotationValueOnField(field, annotationClass);
            if (t == null) continue;
            if (collection == null) {
                collection = new ArrayList<T>();
            }
            collection.add(t);
        }
        return collection;
    }

    public static <T extends Annotation> Collection<Field> getFieldsWithAnnotationInClass(Class<?> inClazz, Class<T> annotationClass) {
        Field[] fields;
        ArrayList<Field> fieldCollection = null;
        for (Field field : fields = inClazz.getDeclaredFields()) {
            T t;
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || (t = AnnotationHelper.readAnnotationValueOnField(field, annotationClass)) == null) continue;
            if (fieldCollection == null) {
                fieldCollection = new ArrayList<Field>();
            }
            fieldCollection.add(field);
        }
        return fieldCollection;
    }
}

