/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.jackson.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xiongyingqi.jackson.FilterPropertyHandler;
import com.xiongyingqi.jackson.annotation.AllowProperty;
import com.xiongyingqi.jackson.annotation.IgnoreProperties;
import com.xiongyingqi.jackson.annotation.IgnoreProperty;
import com.xiongyingqi.jackson.helper.ThreadJacksonMixInHolder;
import com.xiongyingqi.util.EntityHelper;
import com.xiongyingqi.util.StringHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.log4j.Logger;

public class JavassistFilterPropertyHandler
implements FilterPropertyHandler {
    public static final Logger LOGGER = Logger.getLogger(JavassistFilterPropertyHandler.class);
    private static Map<Method, Map<Class<?>, Class<?>>> proxyMethodMap = new HashMap();
    private static Map<Integer, Class<?>> proxyMixInAnnotationMap = new HashMap();
    private static String[] globalIgnoreProperties = new String[]{"hibernateLazyInitializer", "handler"};
    private boolean isResponseBodyAnnotation;
    private static int proxyIndex;

    public JavassistFilterPropertyHandler() {
    }

    public JavassistFilterPropertyHandler(String[] globalIgnoreProperties) {
        JavassistFilterPropertyHandler.globalIgnoreProperties = globalIgnoreProperties;
    }

    @Deprecated
    public JavassistFilterPropertyHandler(boolean isResponseBodyAnnotation) {
        this.isResponseBodyAnnotation = isResponseBodyAnnotation;
    }

    private Collection<String> checkAndPutToCollection(Collection<String> collection, String[] names) {
        if (collection == null) {
            collection = new HashSet<String>();
        }
        Collections.addAll(collection, names);
        return collection;
    }

    private Collection<String> putGlobalIgnoreProperties(Collection<String> collection) {
        if (globalIgnoreProperties != null) {
            if (collection == null) {
                collection = new HashSet<String>();
            }
            for (int i = 0; i < globalIgnoreProperties.length; ++i) {
                String name = globalIgnoreProperties[i];
                collection.add(name);
            }
        }
        return collection;
    }

    private void processIgnorePropertiesAnnotation(IgnoreProperties properties, Map<Class<?>, Collection<String>> pojoAndNamesMap) {
        IgnoreProperty[] values = properties.value();
        AllowProperty[] allowProperties = properties.allow();
        if (allowProperties != null) {
            for (Annotation annotation : allowProperties) {
                this.processAllowPropertyAnnotation((AllowProperty)annotation, pojoAndNamesMap);
            }
        }
        if (values != null) {
            for (Annotation annotation : values) {
                this.processIgnorePropertyAnnotation((IgnoreProperty)annotation, pojoAndNamesMap);
            }
        }
    }

    private void processIgnorePropertyAnnotation(IgnoreProperty property, Map<Class<?>, Collection<String>> pojoAndNamesMap) {
        String[] names = property.name();
        Class<?> pojoClass = property.pojo();
        Collection<String> nameCollection = pojoAndNamesMap.get(pojoClass);
        nameCollection = this.checkAndPutToCollection(nameCollection, names);
        pojoAndNamesMap.put(pojoClass, nameCollection);
    }

    private void processAllowPropertyAnnotation(AllowProperty property, Map<Class<?>, Collection<String>> pojoAndNamesMap) {
        String[] allowNames = property.name();
        Class<?> pojoClass = property.pojo();
        Collection<String> ignoreProperties = EntityHelper.getUnstaticClassFieldNameCollection(pojoClass);
        ArrayList allowNameCollection = new ArrayList();
        Collections.addAll(allowNameCollection, allowNames);
        Collection<String> nameCollection = pojoAndNamesMap.get(pojoClass);
        if (nameCollection != null) {
            nameCollection.removeAll(allowNameCollection);
        } else {
            ignoreProperties.removeAll(allowNameCollection);
            nameCollection = ignoreProperties;
        }
        pojoAndNamesMap.put(pojoClass, nameCollection);
    }

    public Map<Class<?>, Class<?>> getProxyMixInAnnotation(Method method) {
        Map<Class<?>, Class<?>> map = proxyMethodMap.get(method);
        if (map != null && map.entrySet().size() > 0) {
            return map;
        }
        map = new HashMap();
        Class<?> clazzOfMethodIn = method.getDeclaringClass();
        HashMap pojoAndNamesMap = new HashMap();
        IgnoreProperties classIgnoreProperties = clazzOfMethodIn.getAnnotation(IgnoreProperties.class);
        IgnoreProperty classIgnoreProperty = clazzOfMethodIn.getAnnotation(IgnoreProperty.class);
        AllowProperty classAllowProperty = clazzOfMethodIn.getAnnotation(AllowProperty.class);
        IgnoreProperties ignoreProperties = method.getAnnotation(IgnoreProperties.class);
        IgnoreProperty ignoreProperty = method.getAnnotation(IgnoreProperty.class);
        AllowProperty allowProperty = method.getAnnotation(AllowProperty.class);
        if (allowProperty != null) {
            this.processAllowPropertyAnnotation(allowProperty, pojoAndNamesMap);
        }
        if (classAllowProperty != null) {
            this.processAllowPropertyAnnotation(classAllowProperty, pojoAndNamesMap);
        }
        if (classIgnoreProperties != null) {
            this.processIgnorePropertiesAnnotation(classIgnoreProperties, pojoAndNamesMap);
        }
        if (classIgnoreProperty != null) {
            this.processIgnorePropertyAnnotation(classIgnoreProperty, pojoAndNamesMap);
        }
        if (ignoreProperties != null) {
            this.processIgnorePropertiesAnnotation(ignoreProperties, pojoAndNamesMap);
        }
        if (ignoreProperty != null) {
            this.processIgnorePropertyAnnotation(ignoreProperty, pojoAndNamesMap);
        }
        Set entries = pojoAndNamesMap.entrySet();
        for (Map.Entry entry : entries) {
            Collection<String> nameCollection = (Collection<String>)entry.getValue();
            nameCollection = this.putGlobalIgnoreProperties(nameCollection);
            String[] names = nameCollection.toArray(new String[0]);
            Class<?> clazz = this.createMixInAnnotation(names);
            map.put((Class<?>)entry.getKey(), clazz);
        }
        proxyMethodMap.put(method, map);
        return map;
    }

    private Class<?> createMixInAnnotation(String[] names) {
        Class clazz = null;
        clazz = proxyMixInAnnotationMap.get(StringHelper.hashCodeOfStringArray(names));
        if (clazz != null) {
            return clazz;
        }
        ClassPool pool = ClassPool.getDefault();
        CtClass cc = pool.makeInterface("ProxyMixInAnnotation" + System.currentTimeMillis() + proxyIndex++);
        ClassFile ccFile = cc.getClassFile();
        ConstPool constpool = ccFile.getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
        javassist.bytecode.annotation.Annotation jsonIgnorePropertiesAnnotation = new javassist.bytecode.annotation.Annotation(JsonIgnoreProperties.class.getName(), constpool);
        BooleanMemberValue ignoreUnknownMemberValue = new BooleanMemberValue(false, constpool);
        ArrayMemberValue arrayMemberValue = new ArrayMemberValue(constpool);
        HashSet<StringMemberValue> memberValues = new HashSet<StringMemberValue>();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            StringMemberValue memberValue = new StringMemberValue(constpool);
            memberValue.setValue(name);
            memberValues.add(memberValue);
        }
        arrayMemberValue.setValue(memberValues.toArray(new MemberValue[0]));
        jsonIgnorePropertiesAnnotation.addMemberValue("value", (MemberValue)arrayMemberValue);
        jsonIgnorePropertiesAnnotation.addMemberValue("ignoreUnknown", (MemberValue)ignoreUnknownMemberValue);
        attr.addAnnotation(jsonIgnorePropertiesAnnotation);
        ccFile.addAttribute((AttributeInfo)attr);
        try {
            clazz = cc.toClass();
            proxyMixInAnnotationMap.put(StringHelper.hashCodeOfStringArray(names), clazz);
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
        return clazz;
    }

    @Override
    public Object filterProperties(Method method, Object object) {
        Map<Class<?>, Class<?>> map = this.getProxyMixInAnnotation(method);
        if (map == null || map.entrySet().size() == 0) {
            return object;
        }
        ThreadJacksonMixInHolder.addMixIns(this.getEntries(map));
        return object;
    }

    public Set<Map.Entry<Class<?>, Class<?>>> getEntries(Map<Class<?>, Class<?>> map) {
        Set<Map.Entry<Class<?>, Class<?>>> entries = map.entrySet();
        return entries;
    }

    private ObjectMapper createObjectMapper(Map<Class<?>, Class<?>> map) {
        ObjectMapper mapper = new ObjectMapper();
        Set<Map.Entry<Class<?>, Class<?>>> entries = map.entrySet();
        for (Map.Entry<Class<?>, Class<?>> entry : entries) {
            mapper.addMixInAnnotations(entry.getKey(), entry.getValue());
        }
        return mapper;
    }

    public ObjectMapper createObjectMapper(Method method) {
        return this.createObjectMapper(this.getProxyMixInAnnotation(method));
    }

    private JsonEncoding getJsonEncoding(String characterEncoding) {
        for (JsonEncoding encoding : JsonEncoding.values()) {
            if (!characterEncoding.equals(encoding.getJavaName())) continue;
            return encoding;
        }
        return JsonEncoding.UTF8;
    }
}

