/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.jackson.helper;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ThreadJacksonMixInHolder {
    private static ThreadLocal<ThreadJacksonMixInHolder> holderThreadLocal = new ThreadLocal();
    private Set<Map.Entry<Class<?>, Class<?>>> mixIns;
    private ObjectMapper mapper;
    private org.codehaus.jackson.map.ObjectMapper codehausMapper;

    public static ObjectMapper builderMapper() {
        ThreadJacksonMixInHolder holder = holderThreadLocal.get();
        if (holder.mapper == null && ThreadJacksonMixInHolder.isContainsMixIn()) {
            holder.mapper = new ObjectMapper();
            for (Map.Entry<Class<?>, Class<?>> mixIn : holder.mixIns) {
                holder.mapper.addMixInAnnotations(mixIn.getKey(), mixIn.getValue());
            }
        }
        ThreadJacksonMixInHolder.clear();
        return holder.mapper;
    }

    public static org.codehaus.jackson.map.ObjectMapper builderCodehausMapper() {
        ThreadJacksonMixInHolder holder = holderThreadLocal.get();
        if (holder.codehausMapper == null && ThreadJacksonMixInHolder.isContainsMixIn()) {
            holder.codehausMapper = new org.codehaus.jackson.map.ObjectMapper();
            for (Map.Entry<Class<?>, Class<?>> mixIn : holder.mixIns) {
                holder.codehausMapper.getDeserializationConfig().addMixInAnnotations(mixIn.getKey(), mixIn.getValue());
                holder.codehausMapper.getSerializationConfig().addMixInAnnotations(mixIn.getKey(), mixIn.getValue());
            }
        }
        ThreadJacksonMixInHolder.clear();
        return holder.codehausMapper;
    }

    public static void clear() {
        holderThreadLocal.set(null);
    }

    public static void setMixIns(Set<Map.Entry<Class<?>, Class<?>>> resetMixIns) {
        ThreadJacksonMixInHolder holder = holderThreadLocal.get();
        if (holder == null) {
            holder = new ThreadJacksonMixInHolder();
            holderThreadLocal.set(holder);
        }
        holder.mixIns = resetMixIns;
    }

    public static void addMixIns(Set<Map.Entry<Class<?>, Class<?>>> toAddMixIns) {
        ThreadJacksonMixInHolder holder = holderThreadLocal.get();
        if (holder == null) {
            holder = new ThreadJacksonMixInHolder();
            holderThreadLocal.set(holder);
        }
        if (holder.mixIns == null) {
            holder.mixIns = new HashSet();
        }
        holder.mixIns.addAll(toAddMixIns);
    }

    public static Set<Map.Entry<Class<?>, Class<?>>> getMixIns() {
        ThreadJacksonMixInHolder holder = holderThreadLocal.get();
        return holder.mixIns;
    }

    public static boolean isContainsMixIn() {
        if (holderThreadLocal.get() == null) {
            return false;
        }
        return ThreadJacksonMixInHolder.holderThreadLocal.get().mixIns != null && ThreadJacksonMixInHolder.holderThreadLocal.get().mixIns.size() > 0;
    }
}

