/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.calendar;

import java.util.Calendar;
import java.util.Date;

public class CalendarBuilder {
    private Calendar calendar;
    private Calendar calculateCalendar;

    private CalendarBuilder() {
    }

    public static CalendarBuilder newBuilder(Date date) {
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        Calendar instance = Calendar.getInstance();
        Calendar instance2 = Calendar.getInstance();
        instance.setTime(date);
        instance2.setTime(date);
        calendarBuilder.calendar = instance;
        calendarBuilder.calculateCalendar = instance2;
        return calendarBuilder;
    }

    public static CalendarBuilder newBuilder() {
        return CalendarBuilder.newBuilder(new Date());
    }

    public CalendarBuilder time(Date date) {
        this.calendar.setTime(date);
        this.calculateCalendar.setTime(date);
        return this;
    }

    public CalendarBuilder nextMilliSeconds(int plusMilliSeconds) {
        this.calculateCalendar.add(14, plusMilliSeconds);
        return this;
    }

    public CalendarBuilder nextSeconds(int plusSeconds) {
        this.calculateCalendar.add(13, plusSeconds);
        return this;
    }

    public CalendarBuilder nextMinutes(int plusMinutes) {
        this.calculateCalendar.add(12, plusMinutes);
        return this;
    }

    public CalendarBuilder nextHours(int plusHours) {
        this.calculateCalendar.add(10, plusHours);
        return this;
    }

    public CalendarBuilder nextDays(int plusDays) {
        this.calculateCalendar.add(6, plusDays);
        return this;
    }

    public CalendarBuilder nextWeeks(int plusWeeks) {
        this.calculateCalendar.add(3, plusWeeks);
        return this;
    }

    public CalendarBuilder nextMonths(int plusMonths) {
        this.calculateCalendar.add(2, plusMonths);
        return this;
    }

    public CalendarBuilder nextYears(int plusYears) {
        this.calculateCalendar.add(1, plusYears);
        return this;
    }

    public CalendarBuilder next(int field, int plus) {
        this.calculateCalendar.set(field, this.calculateCalendar.get(field) + plus);
        return this;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public Calendar getCalculateCalendar() {
        return this.calculateCalendar;
    }

    public void setCalculateCalendar(Calendar calculateCalendar) {
        this.calculateCalendar = calculateCalendar;
    }

    public Date getResultTime() {
        return this.calculateCalendar.getTime();
    }

    public Date getTime() {
        return this.calendar.getTime();
    }
}

