/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.swagger;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.ApiRegistry;
import com.webcohesion.enunciate.api.InterfaceDescriptionFile;
import com.webcohesion.enunciate.api.PathSummary;
import com.webcohesion.enunciate.api.datatype.Syntax;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceApi;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.api.services.ServiceApi;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.artifacts.FileArtifact;
import com.webcohesion.enunciate.facets.FacetFilter;
import com.webcohesion.enunciate.javac.javadoc.DefaultJavaDocTagHandler;
import com.webcohesion.enunciate.javac.javadoc.JavaDocTagHandler;
import com.webcohesion.enunciate.module.ApiFeatureProviderModule;
import com.webcohesion.enunciate.module.ApiRegistryAwareModule;
import com.webcohesion.enunciate.module.ApiRegistryProviderModule;
import com.webcohesion.enunciate.module.BasicGeneratingModule;
import com.webcohesion.enunciate.module.DependencySpec;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.modules.jaxb.JaxbModule;
import com.webcohesion.enunciate.modules.swagger.BaseDatatypeNameForMethod;
import com.webcohesion.enunciate.modules.swagger.ConstraintsForMethod;
import com.webcohesion.enunciate.modules.swagger.DataFormatNameForMethod;
import com.webcohesion.enunciate.modules.swagger.DefinitionIdForMethod;
import com.webcohesion.enunciate.modules.swagger.FindBestDataTypeMethod;
import com.webcohesion.enunciate.modules.swagger.JsonExampleForMethod;
import com.webcohesion.enunciate.modules.swagger.JsonExamplesForMethod;
import com.webcohesion.enunciate.modules.swagger.OperationIdForMethod;
import com.webcohesion.enunciate.modules.swagger.ReferencedDatatypeNameForMethod;
import com.webcohesion.enunciate.modules.swagger.ResponsesOfMethod;
import com.webcohesion.enunciate.modules.swagger.SwaggerRegistrationContext;
import com.webcohesion.enunciate.modules.swagger.SwaggerResource;
import com.webcohesion.enunciate.modules.swagger.SwaggerUIObjectWrapper;
import com.webcohesion.enunciate.modules.swagger.UniqueMediaTypesForMethod;
import com.webcohesion.enunciate.modules.swagger.ValidParametersMethod;
import com.webcohesion.enunciate.util.freemarker.FileDirective;
import com.webcohesion.enunciate.util.freemarker.FreemarkerUtil;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class SwaggerModule
extends BasicGeneratingModule
implements ApiFeatureProviderModule,
ApiRegistryAwareModule,
ApiRegistryProviderModule {
    private ApiRegistry apiRegistry;
    JaxbModule jaxbModule;

    public String getName() {
        return "swagger";
    }

    public void setApiRegistry(ApiRegistry registry) {
        this.apiRegistry = registry;
    }

    public List<DependencySpec> getDependencySpecifications() {
        return Arrays.asList(new DependencySpec(){

            public boolean accept(EnunciateModule module) {
                if (module instanceof JaxbModule) {
                    SwaggerModule.this.jaxbModule = (JaxbModule)module;
                }
                return !SwaggerModule.this.getName().equals(module.getName()) && module instanceof ApiRegistryProviderModule;
            }

            public boolean isFulfilled() {
                return true;
            }

            public String toString() {
                return "all api registry provider modules";
            }
        });
    }

    protected URL getTemplateURL() throws MalformedURLException {
        String template = this.getFreemarkerProcessingTemplate();
        if (template != null) {
            return this.enunciate.getConfiguration().resolveFile(template).toURI().toURL();
        }
        return SwaggerModule.class.getResource("swagger.fmt");
    }

    public void call(EnunciateContext context) {
    }

    public ApiRegistry getApiRegistry() {
        return new ApiRegistry(){

            public List<ServiceApi> getServiceApis(ApiRegistrationContext context) {
                return Collections.emptyList();
            }

            public List<ResourceApi> getResourceApis(ApiRegistrationContext context) {
                return Collections.emptyList();
            }

            public Set<Syntax> getSyntaxes(ApiRegistrationContext context) {
                return Collections.emptySet();
            }

            public InterfaceDescriptionFile getSwaggerUI() {
                TreeSet<String> facetIncludes = new TreeSet<String>(SwaggerModule.this.enunciate.getConfiguration().getFacetIncludes());
                facetIncludes.addAll(SwaggerModule.this.getFacetIncludes());
                TreeSet<String> facetExcludes = new TreeSet<String>(SwaggerModule.this.enunciate.getConfiguration().getFacetExcludes());
                facetExcludes.addAll(SwaggerModule.this.getFacetExcludes());
                FacetFilter facetFilter = new FacetFilter(facetIncludes, facetExcludes);
                SwaggerRegistrationContext context = new SwaggerRegistrationContext(facetFilter);
                List resourceApis = SwaggerModule.this.apiRegistry.getResourceApis((ApiRegistrationContext)context);
                if (resourceApis == null || resourceApis.isEmpty()) {
                    SwaggerModule.this.info("No resource APIs registered: Swagger UI will not be generated.", new Object[0]);
                }
                return new SwaggerInterfaceDescription(resourceApis, context);
            }
        };
    }

    protected String getHost() {
        String root;
        String host = this.config.getString("[@host]", null);
        if (host == null && (root = this.enunciate.getConfiguration().getApplicationRoot()) != null) {
            try {
                URI uri = URI.create(root);
                host = uri.getHost();
                if (uri.getPort() > 0) {
                    host = host + ":" + uri.getPort();
                }
            }
            catch (IllegalArgumentException e) {
                host = null;
            }
        }
        return host;
    }

    protected String[] getSchemes() {
        return this.config.getStringArray("scheme");
    }

    protected String getBasePath() {
        String basePath = this.config.getString("[@basePath]", null);
        if (basePath == null) {
            String root = this.enunciate.getConfiguration().getApplicationRoot();
            if (root != null) {
                try {
                    URI uri = URI.create(root);
                    basePath = uri.getPath();
                }
                catch (IllegalArgumentException e) {
                    basePath = null;
                }
            }
            while (basePath != null && basePath.endsWith("/")) {
                basePath = basePath.substring(0, basePath.length() - 1);
            }
        }
        return basePath;
    }

    private boolean isIncludeApplicationPath() {
        return this.config.getBoolean("[@includeApplicationPath]", false);
    }

    public String processTemplate(URL templateURL, Object model) throws IOException, TemplateException {
        this.debug("Processing template %s.", new Object[]{templateURL});
        Configuration configuration = new Configuration(FreemarkerUtil.VERSION);
        configuration.setLocale(new Locale("en", "US"));
        configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

            protected URL getURL(String name) {
                try {
                    return new URL(name);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        });
        configuration.setTemplateExceptionHandler(new TemplateExceptionHandler(){

            public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) throws TemplateException {
                throw templateException;
            }
        });
        configuration.setLocalizedLookup(false);
        configuration.setDefaultEncoding("UTF-8");
        configuration.setObjectWrapper((ObjectWrapper)new SwaggerUIObjectWrapper());
        Template template = configuration.getTemplate(templateURL.toString());
        StringWriter unhandledOutput = new StringWriter();
        template.process(model, (Writer)unhandledOutput);
        unhandledOutput.close();
        return unhandledOutput.toString();
    }

    protected void buildBase(File buildDir) throws IOException {
        String base = this.getBase();
        if (base == null) {
            InputStream discoveredBase = SwaggerModule.class.getResourceAsStream("/META-INF/enunciate/swagger-base.zip");
            if (discoveredBase == null) {
                this.debug("Default base to be used for swagger base.", new Object[0]);
                this.enunciate.unzip(this.loadDefaultBase(), buildDir);
                String css = this.getCss();
                if (css != null) {
                    this.enunciate.copyFile(this.enunciate.getConfiguration().resolveFile(css), new File(new File(buildDir, "css"), "screen.css"));
                }
            } else {
                this.debug("Discovered documentation base at /META-INF/enunciate/swagger-base.zip", new Object[0]);
                this.enunciate.unzip(discoveredBase, buildDir);
            }
        } else {
            File baseFile = this.enunciate.getConfiguration().resolveFile(base);
            if (baseFile.isDirectory()) {
                this.debug("Directory %s to be used as the documentation base.", new Object[]{baseFile});
                this.enunciate.copyDir(baseFile, buildDir, new File[0]);
            } else {
                this.debug("Zip file %s to be extracted as the documentation base.", new Object[]{baseFile});
                this.enunciate.unzip((InputStream)new FileInputStream(baseFile), buildDir);
            }
        }
    }

    private void gatherJsonFiles(Set<File> bucket, File buildDir) {
        File[] files = buildDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.getName().endsWith(".json")) {
                    bucket.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.gatherJsonFiles(bucket, file);
            }
        }
    }

    protected InputStream loadDefaultBase() {
        return SwaggerModule.class.getResourceAsStream("/swagger-ui.zip");
    }

    public String getCss() {
        return this.config.getString("[@css]", null);
    }

    public String getFreemarkerProcessingTemplate() {
        return this.config.getString("[@freemarkerProcessingTemplate]", null);
    }

    public String getBase() {
        return this.config.getString("[@base]", null);
    }

    public Set<String> getFacetIncludes() {
        List includes = this.config.getList("facets.include[@name]");
        TreeSet<String> facetIncludes = new TreeSet<String>();
        for (Object include : includes) {
            facetIncludes.add(String.valueOf(include));
        }
        return facetIncludes;
    }

    public Set<String> getFacetExcludes() {
        List excludes = this.config.getList("facets.exclude[@name]");
        TreeSet<String> facetExcludes = new TreeSet<String>();
        for (Object exclude : excludes) {
            facetExcludes.add(String.valueOf(exclude));
        }
        return facetExcludes;
    }

    public String getDocsSubdir() {
        return this.config.getString("[@docsSubdir]", "ui");
    }

    static /* synthetic */ void access$1400(SwaggerModule x0, String x1, Object[] x2) {
        x0.warn(x1, x2);
    }

    private class SwaggerInterfaceDescription
    implements InterfaceDescriptionFile {
        private final List<ResourceApi> resourceApis;
        private final ApiRegistrationContext context;

        public SwaggerInterfaceDescription(List<ResourceApi> resourceApis, ApiRegistrationContext context) {
            this.resourceApis = resourceApis;
            this.context = context;
        }

        public String getHref() {
            return SwaggerModule.this.getDocsSubdir() + "/index.html";
        }

        public void writeTo(File srcDir) throws IOException {
            srcDir.mkdirs();
            String subdir = SwaggerModule.this.getDocsSubdir();
            if (subdir != null) {
                srcDir = new File(srcDir, subdir);
                srcDir.mkdirs();
            }
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("apis", this.resourceApis);
            boolean includeApplicationPath = SwaggerModule.this.isIncludeApplicationPath();
            TreeMap<String, SwaggerResource> resourcesByPath = new TreeMap<String, SwaggerResource>();
            for (ResourceApi resourceApi : this.resourceApis) {
                for (ResourceGroup resourceGroup : resourceApi.getResourceGroups()) {
                    for (PathSummary pathSummary : resourceGroup.getPaths()) {
                        SwaggerResource swaggerResource;
                        String path = pathSummary.getPath();
                        if (includeApplicationPath && !StringUtils.isEmpty((String)resourceGroup.getRelativeContextPath())) {
                            path = "/" + resourceGroup.getRelativeContextPath() + path;
                        }
                        if ((swaggerResource = (SwaggerResource)resourcesByPath.get(path)) == null) {
                            swaggerResource = new SwaggerResource(resourceGroup);
                            resourcesByPath.put(path, swaggerResource);
                        }
                        for (Resource resource : resourceGroup.getResources()) {
                            if (!path.equals(resource.getPath())) continue;
                            swaggerResource.getMethods().addAll(resource.getMethods());
                        }
                    }
                }
            }
            Map ns2prefix = Collections.emptyMap();
            if (SwaggerModule.this.jaxbModule != null) {
                ns2prefix = SwaggerModule.this.jaxbModule.getJaxbContext().getNamespacePrefixes();
            }
            model.put("resourcesByPath", resourcesByPath);
            model.put("syntaxes", SwaggerModule.this.apiRegistry.getSyntaxes(this.context));
            model.put("file", new FileDirective(srcDir, SwaggerModule.this.enunciate.getLogger()));
            model.put("projectVersion", SwaggerModule.this.enunciate.getConfiguration().getVersion());
            model.put("projectTitle", SwaggerModule.this.enunciate.getConfiguration().getTitle());
            model.put("projectDescription", SwaggerModule.this.enunciate.getConfiguration().readDescription(SwaggerModule.this.context, true, (JavaDocTagHandler)DefaultJavaDocTagHandler.INSTANCE));
            model.put("termsOfService", SwaggerModule.this.enunciate.getConfiguration().getTerms());
            List contacts = SwaggerModule.this.enunciate.getConfiguration().getContacts();
            model.put("contact", contacts == null || contacts.isEmpty() ? null : (Object)contacts.get(0));
            model.put("license", SwaggerModule.this.enunciate.getConfiguration().getApiLicense());
            model.put("baseDatatypeNameFor", new BaseDatatypeNameForMethod());
            model.put("referencedDatatypeNameFor", new ReferencedDatatypeNameForMethod());
            model.put("dataFormatNameFor", new DataFormatNameForMethod());
            model.put("constraintsFor", new ConstraintsForMethod());
            model.put("uniqueMediaTypesFor", new UniqueMediaTypesForMethod());
            model.put("jsonExamplesFor", new JsonExamplesForMethod());
            model.put("jsonExampleFor", new JsonExampleForMethod());
            model.put("operationIdFor", new OperationIdForMethod());
            model.put("responsesOf", new ResponsesOfMethod());
            model.put("findBestDataType", new FindBestDataTypeMethod());
            model.put("validParametersOf", new ValidParametersMethod());
            model.put("definitionIdFor", new DefinitionIdForMethod());
            model.put("prefixes", ns2prefix);
            model.put("host", SwaggerModule.this.getHost());
            model.put("schemes", SwaggerModule.this.getSchemes());
            model.put("basePath", SwaggerModule.this.getBasePath());
            SwaggerModule.this.buildBase(srcDir);
            try {
                SwaggerModule.this.processTemplate(SwaggerModule.this.getTemplateURL(), model);
            }
            catch (TemplateException e) {
                throw new EnunciateException((Throwable)e);
            }
            HashSet jsonFilesToValidate = new HashSet();
            SwaggerModule.this.gatherJsonFiles(jsonFilesToValidate, srcDir);
            ObjectMapper mapper = new ObjectMapper();
            for (File file : jsonFilesToValidate) {
                try (FileReader reader = new FileReader(file);){
                    mapper.readTree((Reader)reader);
                }
            }
            FileArtifact swaggerArtifact = new FileArtifact(SwaggerModule.this.getName(), "swagger", srcDir);
            swaggerArtifact.setPublic(false);
            SwaggerModule.this.enunciate.addArtifact((Artifact)swaggerArtifact);
        }
    }
}

