/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson1.model.types;

import com.webcohesion.enunciate.modules.jackson1.model.types.JsonType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;

public class JsonPrimitiveType
implements JsonType {
    private final PrimitiveType type;

    public JsonPrimitiveType(PrimitiveType delegate) {
        this.type = delegate;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isNumber() {
        switch (this.type.getKind()) {
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: 
            case BYTE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isWholeNumber() {
        switch (this.type.getKind()) {
            case INT: 
            case LONG: 
            case SHORT: 
            case BYTE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isBoolean() {
        return this.type.getKind() == TypeKind.BOOLEAN;
    }

    public TypeKind getKind() {
        return this.type.getKind();
    }

    @Override
    public String getFormat() {
        switch (this.getKind()) {
            case INT: {
                return "int32";
            }
            case LONG: {
                return "int64";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
        }
        return null;
    }
}

