/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.linkis.common.utils;

import com.webank.wedatasphere.linkis.common.exception.DwcCommonErrorException;
import com.webank.wedatasphere.linkis.common.exception.ErrorException;
import com.webank.wedatasphere.linkis.common.exception.FatalException;
import com.webank.wedatasphere.linkis.common.exception.WarnException;
import com.webank.wedatasphere.linkis.common.utils.ByteTimeUtils;
import com.webank.wedatasphere.linkis.common.utils.Logging;
import com.webank.wedatasphere.linkis.common.utils.Logging$class;
import com.webank.wedatasphere.linkis.common.utils.ShutdownUtils$;
import com.webank.wedatasphere.linkis.common.utils.Utils$;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.control.ControlThrowable;

public final class Utils$
implements Logging {
    public static final Utils$ MODULE$;
    private final ScheduledThreadPoolExecutor defaultScheduler;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new Utils$();
    }

    private Logger logger$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public void trace(Function0<String> message) {
        Logging$class.trace(this, message);
    }

    @Override
    public void debug(Function0<String> message) {
        Logging$class.debug(this, message);
    }

    @Override
    public void info(Function0<String> message) {
        Logging$class.info(this, message);
    }

    @Override
    public void info(Function0<String> message, Throwable t) {
        Logging$class.info(this, message, t);
    }

    @Override
    public void warn(Function0<String> message) {
        Logging$class.warn(this, message);
    }

    @Override
    public void warn(Function0<String> message, Throwable t) {
        Logging$class.warn(this, message, t);
    }

    @Override
    public void error(Function0<String> message, Throwable t) {
        Logging$class.error(this, message, t);
    }

    @Override
    public void error(Function0<String> message) {
        Logging$class.error(this, message);
    }

    public <T> T tryQuietly(Function0<T> tryOp) {
        Object object;
        try {
            object = tryOp.apply();
        }
        catch (Throwable throwable) {
            Object var5_6;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 instanceof FatalException) {
                FatalException fatalException = (FatalException)throwable2;
                this.error((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Fatal Error, system exit...";
                    }
                }, fatalException);
                System.exit(fatalException.getErrCode());
                var5_6 = null;
            } else {
                var5_6 = null;
            }
            object = var5_6;
        }
        return (T)object;
    }

    public <T> T tryCatch(Function0<T> tryOp, Function1<Throwable, T> catchOp) {
        Throwable throwable2;
        block5: {
            Object object;
            try {
                object = tryOp.apply();
            }
            catch (Throwable throwable2) {
                Object object2;
                Throwable throwable3 = throwable2;
                if (throwable3 instanceof ControlThrowable) {
                    ControlThrowable controlThrowable = (ControlThrowable)throwable3;
                    throw (Throwable)controlThrowable;
                }
                if (throwable3 instanceof FatalException) {
                    FatalException fatalException = (FatalException)throwable3;
                    this.error((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Fatal Error, system exit...";
                        }
                    }, fatalException);
                    System.exit(fatalException.getErrCode());
                    object2 = null;
                } else {
                    if (throwable3 == null) break block5;
                    Throwable throwable4 = throwable3;
                    object2 = catchOp.apply((Object)throwable4);
                }
                object = object2;
            }
            return (T)object;
        }
        throw throwable2;
    }

    public <T> T tryThrow(Function0<T> tryOp, Function1<Throwable, Throwable> exception) {
        return this.tryCatch(tryOp, (Function1<Throwable, T>)new Serializable(exception){
            public static final long serialVersionUID = 0L;
            private final Function1 exception$1;

            public final Nothing$ apply(Throwable t) {
                throw (Throwable)this.exception$1.apply((Object)t);
            }
            {
                this.exception$1 = exception$1;
            }
        });
    }

    public <T> T tryFinally(Function0<T> tryOp, Function0<BoxedUnit> finallyOp) {
        try {
            return (T)tryOp.apply();
        }
        finally {
            finallyOp.apply$mcV$sp();
        }
    }

    public <T> T tryQuietly(Function0<T> tryOp, Function1<Throwable, BoxedUnit> catchOp) {
        return this.tryCatch(tryOp, (Function1<Throwable, T>)new Serializable(catchOp){
            public static final long serialVersionUID = 0L;
            private final Function1 catchOp$1;

            public final T apply(Throwable x0$1) {
                Throwable throwable;
                block4: {
                    Object var4_4;
                    block3: {
                        block2: {
                            throwable = x0$1;
                            if (!(throwable instanceof FatalException)) break block2;
                            FatalException fatalException = (FatalException)throwable;
                            Utils$.MODULE$.error((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Fatal Error, system exit...";
                                }
                            }, fatalException);
                            System.exit(fatalException.getErrCode());
                            var4_4 = null;
                            break block3;
                        }
                        if (throwable == null) break block4;
                        Throwable throwable2 = throwable;
                        this.catchOp$1.apply((Object)throwable2);
                        var4_4 = null;
                    }
                    return var4_4;
                }
                throw new MatchError((Object)throwable);
            }
            {
                this.catchOp$1 = catchOp$1;
            }
        });
    }

    public <T> T tryAndWarn(Function0<T> tryOp, Logger log) {
        return this.tryCatch(tryOp, (Function1<Throwable, T>)new Serializable(log){
            public static final long serialVersionUID = 0L;
            private final Logger log$2;

            public final T apply(Throwable x0$2) {
                Throwable throwable;
                block5: {
                    Object var4_5;
                    block3: {
                        block4: {
                            block2: {
                                throwable = x0$2;
                                if (!(throwable instanceof ErrorException)) break block2;
                                ErrorException errorException = (ErrorException)throwable;
                                String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"error code\uff08\u9519\u8bef\u7801\uff09: ", ", Error message\uff08\u9519\u8bef\u4fe1\u606f\uff09: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errorException.getErrCode()), errorException.getDesc()}));
                                this.log$2.error(errorMsg, (Throwable)errorException);
                                var4_5 = null;
                                break block3;
                            }
                            if (!(throwable instanceof WarnException)) break block4;
                            WarnException warnException = (WarnException)throwable;
                            String warnMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Warning code\uff08\u8b66\u544a\u7801\uff09: ", ", Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)warnException.getErrCode()), warnException.getDesc()}));
                            this.log$2.warn(warnMsg, (Throwable)warnException);
                            var4_5 = null;
                            break block3;
                        }
                        if (throwable == null) break block5;
                        Throwable throwable2 = throwable;
                        this.log$2.warn("", throwable2);
                        var4_5 = null;
                    }
                    return var4_5;
                }
                throw new MatchError((Object)throwable);
            }
            {
                this.log$2 = log$2;
            }
        });
    }

    public <T> T tryAndWarnMsg(Function0<T> tryOp, String message, Logger log) {
        return this.tryCatch(tryOp, (Function1<Throwable, T>)new Serializable(message, log){
            public static final long serialVersionUID = 0L;
            private final String message$1;
            private final Logger log$3;

            public final T apply(Throwable x0$3) {
                Throwable throwable;
                block5: {
                    Object var4_4;
                    block3: {
                        block4: {
                            block2: {
                                throwable = x0$3;
                                if (!(throwable instanceof ErrorException)) break block2;
                                ErrorException errorException = (ErrorException)throwable;
                                this.log$3.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"error code\uff08\u9519\u8bef\u7801\uff09: ", ", Error message\uff08\u9519\u8bef\u4fe1\u606f\uff09: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errorException.getErrCode()), errorException.getDesc()})));
                                this.log$3.error(this.message$1, (Throwable)errorException);
                                var4_4 = null;
                                break block3;
                            }
                            if (!(throwable instanceof WarnException)) break block4;
                            WarnException warnException = (WarnException)throwable;
                            this.log$3.warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Warning code\uff08\u8b66\u544a\u7801\uff09: ", ", Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)warnException.getErrCode()), warnException.getDesc()})));
                            this.log$3.warn(this.message$1, (Throwable)warnException);
                            var4_4 = null;
                            break block3;
                        }
                        if (throwable == null) break block5;
                        Throwable throwable2 = throwable;
                        this.log$3.warn(this.message$1, throwable2);
                        var4_4 = null;
                    }
                    return var4_4;
                }
                throw new MatchError((Object)throwable);
            }
            {
                this.message$1 = message$1;
                this.log$3 = log$3;
            }
        });
    }

    public <T> T tryAndError(Function0<T> tryOp, Logger log) {
        return this.tryCatch(tryOp, (Function1<Throwable, T>)new Serializable(log){
            public static final long serialVersionUID = 0L;
            private final Logger log$1;

            public final T apply(Throwable x0$4) {
                Throwable throwable;
                block5: {
                    Object var4_5;
                    block3: {
                        block4: {
                            block2: {
                                throwable = x0$4;
                                if (!(throwable instanceof ErrorException)) break block2;
                                ErrorException errorException = (ErrorException)throwable;
                                String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"error code\uff08\u9519\u8bef\u7801\uff09: ", ", Error message\uff08\u9519\u8bef\u4fe1\u606f\uff09: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errorException.getErrCode()), errorException.getDesc()}));
                                this.log$1.error(errorMsg, (Throwable)errorException);
                                var4_5 = null;
                                break block3;
                            }
                            if (!(throwable instanceof WarnException)) break block4;
                            WarnException warnException = (WarnException)throwable;
                            String warnMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Warning code\uff08\u8b66\u544a\u7801\uff09: ", ", Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)warnException.getErrCode()), warnException.getDesc()}));
                            this.log$1.warn(warnMsg, (Throwable)warnException);
                            var4_5 = null;
                            break block3;
                        }
                        if (throwable == null) break block5;
                        Throwable throwable2 = throwable;
                        this.log$1.error("", throwable2);
                        var4_5 = null;
                    }
                    return var4_5;
                }
                throw new MatchError((Object)throwable);
            }
            {
                this.log$1 = log$1;
            }
        });
    }

    public <T> T tryAndErrorMsg(Function0<T> tryOp, String message, Logger log) {
        return this.tryCatch(tryOp, (Function1<Throwable, T>)new Serializable(message, log){
            public static final long serialVersionUID = 0L;
            private final String message$2;
            private final Logger log$4;

            public final T apply(Throwable x0$5) {
                Throwable throwable;
                block5: {
                    Object var4_4;
                    block3: {
                        block4: {
                            block2: {
                                throwable = x0$5;
                                if (!(throwable instanceof ErrorException)) break block2;
                                ErrorException errorException = (ErrorException)throwable;
                                this.log$4.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"error code\uff08\u9519\u8bef\u7801\uff09: ", ", Error message\uff08\u9519\u8bef\u4fe1\u606f\uff09: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errorException.getErrCode()), errorException.getDesc()})));
                                this.log$4.error(this.message$2, (Throwable)errorException);
                                var4_4 = null;
                                break block3;
                            }
                            if (!(throwable instanceof WarnException)) break block4;
                            WarnException warnException = (WarnException)throwable;
                            this.log$4.warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Warning code\uff08\u8b66\u544a\u7801\uff09: ", ", Warning message\uff08\u8b66\u544a\u4fe1\u606f\uff09: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)warnException.getErrCode()), warnException.getDesc()})));
                            this.log$4.warn(this.message$2, (Throwable)warnException);
                            var4_4 = null;
                            break block3;
                        }
                        if (throwable == null) break block5;
                        Throwable throwable2 = throwable;
                        this.log$4.error(this.message$2, throwable2);
                        var4_4 = null;
                    }
                    return var4_4;
                }
                throw new MatchError((Object)throwable);
            }
            {
                this.message$2 = message$2;
                this.log$4 = log$4;
            }
        });
    }

    public void sleepQuietly(long mills) {
        this.tryQuietly((Function0)new Serializable(mills){
            public static final long serialVersionUID = 0L;
            private final long mills$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Thread.sleep(this.mills$1);
            }
            {
                this.mills$1 = mills$1;
            }
        });
    }

    public ThreadFactory threadFactory(String threadName, boolean isDaemon) {
        return new ThreadFactory(threadName, isDaemon){
            private final AtomicInteger num;
            private final String threadName$1;
            private final boolean isDaemon$1;

            private AtomicInteger num() {
                return this.num;
            }

            /*
             * WARNING - void declaration
             */
            public Thread newThread(Runnable r) {
                void var2_2;
                Thread t = new Thread(r);
                t.setDaemon(this.isDaemon$1);
                t.setName(new StringBuilder().append((Object)this.threadName$1).append((Object)BoxesRunTime.boxToInteger((int)this.num().incrementAndGet())).toString());
                return var2_2;
            }
            {
                this.threadName$1 = threadName$1;
                this.isDaemon$1 = isDaemon$1;
                this.num = new AtomicInteger(0);
            }
        };
    }

    public boolean threadFactory$default$2() {
        return true;
    }

    public ThreadPoolExecutor newCachedThreadPool(int threadNum, String threadName, boolean isDaemon) {
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(threadNum, threadNum, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10 * threadNum), this.threadFactory(threadName, isDaemon));
        threadPool.allowCoreThreadTimeOut(true);
        return threadPool;
    }

    public boolean newCachedThreadPool$default$3() {
        return true;
    }

    public ExecutionContextExecutorService newCachedExecutionContext(int threadNum, String threadName, boolean isDaemon) {
        return ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.newCachedThreadPool(threadNum, threadName, isDaemon));
    }

    public boolean newCachedExecutionContext$default$3() {
        return true;
    }

    public ExecutorService newFixedThreadPool(int threadNum, String threadName, boolean isDaemon) {
        return Executors.newFixedThreadPool(threadNum, this.threadFactory(threadName, isDaemon));
    }

    public boolean newFixedThreadPool$default$3() {
        return true;
    }

    public ExecutionContextExecutorService newFixedExecutionContext(int threadNum, String threadName, boolean isDaemon) {
        return ExecutionContext$.MODULE$.fromExecutorService(this.newFixedThreadPool(threadNum, threadName, isDaemon));
    }

    public boolean newFixedExecutionContext$default$3() {
        return true;
    }

    public ScheduledThreadPoolExecutor defaultScheduler() {
        return this.defaultScheduler;
    }

    public String getLocalHostname() {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public String getComputerName() {
        return (String)this.tryCatch((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return InetAddress.getLocalHost().getCanonicalHostName();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Throwable t) {
                return (String)package$.MODULE$.env().apply((Object)"COMPUTERNAME");
            }
        });
    }

    public final void waitUntil(Function0<Object> checkForEvent, Duration atMost, int radix, long maxPeriod) throws TimeoutException, InterruptedException {
        long l;
        try {
            l = System.currentTimeMillis() + atMost.toMillis();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            l = 0L;
        }
        long endTime = l;
        this.aux$1(1, checkForEvent, radix, maxPeriod, endTime);
    }

    public final void waitUntil(Function0<Object> checkForEvent, Duration atMost) {
        this.waitUntil(checkForEvent, atMost, 100, 2000L);
    }

    public String exec(String[] commandLine) {
        return this.exec(commandLine, -1L);
    }

    public String exec(List<String> commandLine) {
        return this.exec(commandLine, -1L);
    }

    public String exec(String[] commandLine, long maxWaitTime) {
        return this.exec((List<String>)Predef$.MODULE$.refArrayOps((Object[])commandLine).toList(), maxWaitTime);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String exec(List<String> commandLine, long maxWaitTime) {
        int n;
        ProcessBuilder pb = new ProcessBuilder(JavaConversions$.MODULE$.seqAsJavaList(commandLine));
        pb.redirectErrorStream(true);
        pb.redirectInput(ProcessBuilder.Redirect.PIPE);
        Process process = pb.start();
        BufferedReader log = new BufferedReader(new InputStreamReader(process.getInputStream()));
        if (maxWaitTime > 0L) {
            boolean completed = process.waitFor(maxWaitTime, TimeUnit.MILLISECONDS);
            if (!completed) {
                IOUtils.closeQuietly((Reader)log);
                process.destroy();
                throw new TimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exec timeout with ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ByteTimeUtils.msDurationToString(maxWaitTime)})));
            }
            n = process.exitValue();
        } else {
            n = BoxesRunTime.unboxToInt(this.tryThrow((Function0)new Serializable(process){
                public static final long serialVersionUID = 0L;
                private final Process process$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.process$1.waitFor();
                }
                {
                    this.process$1 = process$1;
                }
            }, (Function1<Throwable, Throwable>)new Serializable(process, log){
                public static final long serialVersionUID = 0L;
                private final Process process$1;
                private final BufferedReader log$5;

                public final Throwable apply(Throwable t) {
                    this.process$1.destroy();
                    IOUtils.closeQuietly((Reader)this.log$5);
                    return t;
                }
                {
                    this.process$1 = process$1;
                    this.log$5 = log$5;
                }
            }));
        }
        int exitCode = n;
        Object[] lines = log.lines().toArray();
        IOUtils.closeQuietly((Reader)log);
        if (exitCode != 0) {
            throw new DwcCommonErrorException(0, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exec failed with exit code: ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)exitCode), Predef$.MODULE$.refArrayOps(lines).mkString(". ")})));
        }
        return Predef$.MODULE$.refArrayOps(lines).mkString("\n");
    }

    public void addShutdownHook(Function0<BoxedUnit> hook) {
        ShutdownUtils$.MODULE$.addShutdownHook(hook);
    }

    public <T> T getClassInstance(String className) {
        return this.tryThrow((Function0<T>)new Serializable(className){
            public static final long serialVersionUID = 0L;
            private final String className$1;

            public final T apply() {
                return (T)Thread.currentThread().getContextClassLoader().loadClass(this.className$1).newInstance();
            }
            {
                this.className$1 = className$1;
            }
        }, (Function1<Throwable, Throwable>)new Serializable(className){
            public static final long serialVersionUID = 0L;
            public final String className$1;

            public final Nothing$ apply(Throwable t) {
                Utils$.MODULE$.error((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getClassInstance.2 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to instance: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.className$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, t);
                throw t;
            }
            {
                this.className$1 = className$1;
            }
        });
    }

    public String msDurationToString(long ms) {
        int second = 1000;
        int minute = 60 * second;
        int hour = 60 * minute;
        long l = ms;
        String string = l < (long)second ? new StringOps(Predef$.MODULE$.augmentString("%d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l)})) : (l < (long)minute ? new StringOps(Predef$.MODULE$.augmentString("%.1f \u79d2")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)second))})) : (l < (long)hour ? new StringOps(Predef$.MODULE$.augmentString("%.1f \u5206\u949f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)minute))})) : new StringOps(Predef$.MODULE$.augmentString("%.2f \u5c0f\u65f6")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)hour))}))));
        return string;
    }

    private final void aux$1(int count, Function0 checkForEvent$1, int radix$1, long maxPeriod$1, long endTime$1) {
        while (true) {
            if (checkForEvent$1.apply$mcZ$sp()) {
                return;
            }
            long now = System.currentTimeMillis();
            if (endTime$1 != 0L && now >= endTime$1) break;
            long sleepTime = Math.max(Math.min((long)(radix$1 * count), maxPeriod$1), 100L);
            Thread.sleep(sleepTime);
            ++count;
        }
        throw new TimeoutException();
    }

    /*
     * WARNING - void declaration
     */
    private Utils$() {
        void var1_1;
        MODULE$ = this;
        Logging$class.$init$(this);
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(20, this.threadFactory("BDP-Default-Scheduler-Thread-", true));
        scheduler.setMaximumPoolSize(20);
        scheduler.setKeepAliveTime(5L, TimeUnit.MINUTES);
        this.defaultScheduler = var1_1;
    }
}

