/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.linkis.common.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class FsPath {
    public static final String CUR_DIR = ".";
    public static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    public static final char SEPARATOR_CHAR = '/';
    public static final String SEPARATOR = "/";
    private static final Pattern hasDriveLetterSpecifier = Pattern.compile("^/?[a-zA-Z]:");
    private URI uri;
    private long modification_time;
    private long access_time;
    private long length;
    private boolean isdir;
    private String permissionString;
    private String owner;
    private String group;
    private PosixFilePermission[] permissions;

    public FsPath(String pathString) throws IllegalArgumentException {
        this.checkPathArg(pathString);
        if (FsPath.hasWindowsDrive(pathString) && pathString.charAt(0) != '/') {
            pathString = SEPARATOR + pathString;
        }
        String scheme = null;
        String authority = null;
        int start = 0;
        int colon = pathString.indexOf(58);
        int slash = pathString.indexOf(47);
        if (colon != -1 && (slash == -1 || colon < slash)) {
            scheme = pathString.substring(0, colon);
            start = colon + 1;
        }
        if (pathString.startsWith("//", start) && pathString.length() - start > 2) {
            int nextSlash = pathString.indexOf(47, start + 2);
            int authEnd = nextSlash > 0 ? nextSlash : pathString.length();
            authority = pathString.substring(start + 2, authEnd);
            start = authEnd;
        }
        String path = pathString.substring(start, pathString.length());
        this.initialize(scheme, authority, path, null);
    }

    public FsPath(String scheme, String authority, String path) {
        this.checkPathArg(path);
        if (FsPath.hasWindowsDrive(path) && path.charAt(0) != '/') {
            path = SEPARATOR + path;
        }
        if (!WINDOWS && path.charAt(0) != '/') {
            path = "./" + path;
        }
        this.initialize(scheme, authority, path, null);
    }

    private void checkPathArg(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("Can not create a Path from a null string");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Can not create a Path from an empty string");
        }
    }

    private void initialize(String scheme, String authority, String path, String fragment) {
        try {
            this.uri = new URI(scheme, authority, FsPath.normalizePath(scheme, path), null, fragment).normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String normalizePath(String scheme, String path) {
        path = StringUtils.replace((String)path, (String)"//", (String)SEPARATOR);
        if (WINDOWS && (FsPath.hasWindowsDrive(path) || scheme == null || scheme.isEmpty() || scheme.equals("file"))) {
            path = StringUtils.replace((String)path, (String)"\\", (String)SEPARATOR);
        }
        int minLength = FsPath.startPositionWithoutWindowsDrive(path) + 1;
        if (path.length() > minLength && path.endsWith(SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static boolean hasWindowsDrive(String path) {
        return WINDOWS && hasDriveLetterSpecifier.matcher(path).find();
    }

    private static int startPositionWithoutWindowsDrive(String path) {
        if (FsPath.hasWindowsDrive(path)) {
            return path.charAt(0) == '/' ? 3 : 2;
        }
        return 0;
    }

    public String getFsType() {
        return this.getFsType("file");
    }

    public String getFsType(String defaultType) {
        String scheme = this.uri.getScheme();
        if (StringUtils.isEmpty((String)scheme)) {
            return defaultType;
        }
        return scheme;
    }

    public File toFile() {
        return new File(this.uri);
    }

    public Path toPath() {
        return FileSystems.getDefault().getPath(this.uri.toString(), new String[0]);
    }

    public boolean isOwner(String user) {
        return this.owner.equals(user);
    }

    public FsPath getParent() throws IOException {
        String path = this.uri.getPath();
        int lastSlash = path.lastIndexOf(47);
        int start = FsPath.startPositionWithoutWindowsDrive(path);
        if (path.length() == start || lastSlash == start && path.length() == start + 1) {
            return null;
        }
        String parent = lastSlash == -1 ? CUR_DIR : path.substring(0, lastSlash == start ? start + 1 : lastSlash);
        return new FsPath(this.uri.getScheme(), this.uri.getAuthority(), parent);
    }

    public long getModification_time() {
        return this.modification_time;
    }

    public void setModification_time(long modification_time) {
        this.modification_time = modification_time;
    }

    public long getAccess_time() {
        return this.access_time;
    }

    public void setAccess_time(long access_time) {
        this.access_time = access_time;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public boolean isdir() {
        return this.isdir;
    }

    public void setIsdir(boolean isdir) {
        this.isdir = isdir;
    }

    public String getPermissionString() {
        return this.permissionString;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setPermissions(Set<PosixFilePermission> permissions) throws IOException {
        this.permissions = permissions.toArray(new PosixFilePermission[0]);
        this.permissionString = PosixFilePermissions.toString(permissions);
    }

    public void setPermissionString(String permissionString) throws IOException {
        this.permissionString = FsPath.permissionFormatted(permissionString);
        this.permissions = PosixFilePermissions.fromString(this.permissionString).toArray(new PosixFilePermission[0]);
    }

    public String getPath() {
        if (WINDOWS && !"hdfs".equals(this.getFsType())) {
            return this.uri.getAuthority() + this.uri.getPath();
        }
        return this.uri.getPath();
    }

    public String getSchemaPath() {
        if (WINDOWS && !"hdfs".equals(this.getFsType())) {
            return this.getFsType() + "://" + this.uri.getAuthority() + this.uri.getPath();
        }
        return this.getFsType() + "://" + this.uri.getPath();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("path=").append(this.uri.getPath());
        sb.append("; isDirectory=").append(this.isdir);
        if (!this.isdir) {
            sb.append("; length=").append(this.length);
        }
        sb.append("; modification_time=").append(this.modification_time);
        sb.append("; access_time=").append(this.access_time);
        sb.append("; owner=").append(this.owner);
        sb.append("; group=").append(this.group);
        sb.append("; permission=").append(this.permissions);
        sb.append("}");
        return sb.toString();
    }

    public static String permissionFormatted(String permission) throws IOException {
        if (!StringUtils.isNumeric((String)permission)) {
            return permission;
        }
        char[] ps = permission.toCharArray();
        return FsPath.permissionFormatted(ps[0]) + FsPath.permissionFormatted(ps[1]) + FsPath.permissionFormatted(ps[2]);
    }

    public static String permissionFormatted(char i) throws IOException {
        int in = Integer.parseInt(String.valueOf(i));
        switch (in) {
            case 0: {
                return "---";
            }
            case 1: {
                return "--x";
            }
            case 2: {
                return "-w-";
            }
            case 3: {
                return "-wx";
            }
            case 4: {
                return "r--";
            }
            case 5: {
                return "r-x";
            }
            case 6: {
                return "rw-";
            }
            case 7: {
                return "rwx";
            }
        }
        throw new IOException("Incorrent permission number " + in);
    }

    public static FsPath getFsPath(String path, String ... more) {
        String realPath = Paths.get(path, more).toFile().getPath();
        return new FsPath(realPath);
    }
}

