/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.linkis.common.exception;

import com.webank.wedatasphere.linkis.common.exception.DWCException;
import com.webank.wedatasphere.linkis.common.exception.DWCRetryException;
import com.webank.wedatasphere.linkis.common.exception.ErrorException;
import com.webank.wedatasphere.linkis.common.exception.ExceptionLevel;
import com.webank.wedatasphere.linkis.common.exception.FatalException;
import com.webank.wedatasphere.linkis.common.exception.WarnException;
import java.util.HashMap;
import java.util.Map;

public final class ExceptionManager {
    private static final String LEVEL = "level";
    private static final String ERRCODE = "errCode";
    private static final String DESC = "desc";
    private static final String IP = "ip";
    private static final String PORT = "port";
    private static final String SERVICEKIND = "serviceKind";

    public static Exception generateException(Map<String, Object> map) {
        Exception retException = null;
        if (null == map || map.get(LEVEL) == null) {
            return new ErrorException(10000, "The map cannot be parsed normally, the map is empty or the LEVEL value is missing:(map\u4e0d\u80fd\u88ab\u6b63\u5e38\u7684\u89e3\u6790\uff0cmap\u4e3a\u7a7a\u6216\u8005\u7f3a\u5c11LEVEL\u503c: )" + map);
        }
        int level = Integer.parseInt(map.get(LEVEL).toString());
        int errCode = Integer.parseInt(map.get(ERRCODE).toString());
        String desc = (String)map.get(DESC);
        String ip = (String)map.get(IP);
        int port = Integer.parseInt(map.get(PORT).toString());
        String serviceKind = (String)map.get(SERVICEKIND);
        if (ExceptionLevel.WARN.getLevel() == level) {
            retException = new WarnException(errCode, desc, ip, port, serviceKind);
        } else if (ExceptionLevel.ERROR.getLevel() == level) {
            retException = new ErrorException(errCode, desc, ip, port, serviceKind);
        } else if (ExceptionLevel.FATAL.getLevel() == level) {
            retException = new FatalException(errCode, desc, ip, port, serviceKind);
        } else if (ExceptionLevel.RETRY.getLevel() == level) {
            retException = new DWCRetryException(errCode, desc, ip, port, serviceKind);
        }
        return retException != null ? retException : new ErrorException(10000, "Exception Map that cannot be parsed:(\u4e0d\u80fd\u89e3\u6790\u7684\u5f02\u5e38Map\uff1a)" + map);
    }

    public static Map<String, Object> unknownException(String errorMsg) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put(LEVEL, ExceptionLevel.ERROR.getLevel());
        retMap.put(ERRCODE, 0);
        retMap.put(DESC, errorMsg);
        retMap.put(IP, DWCException.hostname);
        retMap.put(PORT, DWCException.hostPort);
        retMap.put(SERVICEKIND, DWCException.applicationName);
        return retMap;
    }
}

