/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.linkis.common.exception;

import com.webank.wedatasphere.linkis.common.exception.DWCException;
import com.webank.wedatasphere.linkis.common.exception.ExceptionLevel;
import java.util.HashMap;
import java.util.Map;

public abstract class DWCRuntimeException
extends RuntimeException {
    private int errCode;
    private String desc;
    private String ip;
    private int port;
    private String serviceKind;

    public DWCRuntimeException(int errCode, String desc) {
        this(errCode, desc, DWCException.hostname, DWCException.hostPort, DWCException.applicationName);
    }

    public DWCRuntimeException(int errCode, String desc, String ip, int port, String serviceKind) {
        super("errCode: " + errCode + " ,desc: " + desc + " ,ip: " + ip + " ,port: " + port + " ,serviceKind: " + serviceKind);
        this.errCode = errCode;
        this.desc = desc;
        this.ip = ip;
        this.port = port;
        this.serviceKind = serviceKind;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getServiceKind() {
        return this.serviceKind;
    }

    public void setServiceKind(String serviceKind) {
        this.serviceKind = serviceKind;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("errCode", this.getErrCode());
        retMap.put("desc", this.getDesc());
        retMap.put("ip", this.getIp());
        retMap.put("port", this.getPort());
        retMap.put("level", this.getLevel().getLevel());
        retMap.put("serviceKind", this.getServiceKind());
        return retMap;
    }

    public abstract ExceptionLevel getLevel();

    @Override
    public String toString() {
        return "DWCException{errCode=" + this.errCode + ", desc='" + this.desc + '\'' + ", ip='" + this.ip + '\'' + ", port=" + this.port + ", serviceKind='" + this.serviceKind + '\'' + '}';
    }
}

