/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.integrations.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.wavefront.common.MetricsToTimeseries;
import com.wavefront.common.Pair;
import com.wavefront.integrations.metrics.HttpMetricsProcessor;
import com.wavefront.metrics.MetricTranslator;
import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.SafeVirtualMachineMetrics;
import com.yammer.metrics.core.VirtualMachineMetrics;
import com.yammer.metrics.core.WavefrontHistogram;
import com.yammer.metrics.reporting.AbstractReporter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.http.nio.reactor.IOReactorException;

public class WavefrontYammerHttpMetricsReporter
extends AbstractReporter
implements Runnable {
    protected static final Logger logger = Logger.getLogger(WavefrontYammerHttpMetricsReporter.class.getCanonicalName());
    private static final Clock clock = Clock.defaultClock();
    private static final VirtualMachineMetrics vm = SafeVirtualMachineMetrics.getInstance();
    private final ScheduledExecutorService executor;
    private final boolean includeJvmMetrics;
    private final boolean includeReporterMetrics;
    private final ConcurrentHashMap<String, Double> gaugeMap;
    private final MetricTranslator metricTranslator;
    private final HttpMetricsProcessor httpMetricsProcessor;
    private final AtomicInteger histogramsGenerated = new AtomicInteger();
    private final AtomicInteger metricsGenerated = new AtomicInteger();
    private final AtomicInteger metricsFailedToSend = new AtomicInteger();

    private WavefrontYammerHttpMetricsReporter(Builder builder) throws IOReactorException {
        super(builder.metricsRegistry);
        this.executor = builder.metricsRegistry.newScheduledThreadPool(1, builder.name);
        this.metricTranslator = builder.metricTranslator;
        this.includeJvmMetrics = builder.includeJvmMetrics;
        this.includeReporterMetrics = builder.includeReporterMetrics;
        HttpMetricsProcessor.Builder httpMetricsProcessorBuilder = new HttpMetricsProcessor.Builder().withEndpoint(builder.hostname, builder.port).withPrependedGroupNames(builder.prependGroupName).sendEmptyHistograms(builder.sendEmptyHistograms).clearHistogramsAndTimers(builder.clear).withTimeSupplier(builder.timeSupplier).withDefaultSource(builder.defaultSource).withSdkInternalTags(builder.sdkInternalTags).withFlushInterval(builder.timeUnit, builder.flushInterval).sendZeroCounters(builder.sendZeroCounters);
        if (builder.queueSize > 0 && builder.batchSize > 0) {
            httpMetricsProcessorBuilder.withQueueOptions(builder.batchSize, builder.queueSize);
        }
        if (builder.secondaryHostname != null) {
            httpMetricsProcessorBuilder.withSecondaryEndpoint(builder.secondaryHostname, builder.secondaryPort);
        }
        this.httpMetricsProcessor = httpMetricsProcessorBuilder.build();
        this.gaugeMap = new ConcurrentHashMap();
    }

    private void upsertGauges(final String metricName, Double t) {
        this.gaugeMap.put(metricName, t);
        this.getMetricsRegistry().newGauge(new MetricName("", "", MetricsToTimeseries.sanitize((String)metricName)), (Gauge)new Gauge<Double>(){

            public Double value() {
                return (Double)WavefrontYammerHttpMetricsReporter.this.gaugeMap.get(metricName);
            }
        });
    }

    private void upsertGauges(String base, Map<String, Double> metrics) {
        for (Map.Entry<String, Double> entry : metrics.entrySet()) {
            this.upsertGauges(base + "." + entry.getKey(), entry.getValue());
        }
    }

    private void upsertJavaMetrics() {
        this.upsertGauges("jvm.memory", MetricsToTimeseries.memoryMetrics((VirtualMachineMetrics)vm));
        this.upsertGauges("jvm.buffers.direct", MetricsToTimeseries.buffersMetrics((VirtualMachineMetrics.BufferPoolStats)((VirtualMachineMetrics.BufferPoolStats)vm.getBufferPoolStats().get("direct"))));
        this.upsertGauges("jvm.buffers.mapped", MetricsToTimeseries.buffersMetrics((VirtualMachineMetrics.BufferPoolStats)((VirtualMachineMetrics.BufferPoolStats)vm.getBufferPoolStats().get("mapped"))));
        this.upsertGauges("jvm.thread-states", MetricsToTimeseries.threadStateMetrics((VirtualMachineMetrics)vm));
        this.upsertGauges("jvm", MetricsToTimeseries.vmMetrics((VirtualMachineMetrics)vm));
        this.upsertGauges("current_time", Double.valueOf(clock.time()));
        for (Map.Entry entry : vm.garbageCollectors().entrySet()) {
            this.upsertGauges("jvm.garbage-collectors." + (String)entry.getKey(), MetricsToTimeseries.gcMetrics((VirtualMachineMetrics.GarbageCollectorStats)((VirtualMachineMetrics.GarbageCollectorStats)entry.getValue())));
        }
    }

    private void upsertReporterMetrics() {
        HashMap<String, Double> gauges = new HashMap<String, Double>();
        gauges.put("yammer-metrics.failed", this.metricsFailedToSend.doubleValue());
        gauges.put("yammer-metrics.points.generated", this.metricsGenerated.doubleValue());
        gauges.put("yammer-metrics.histos.generated", this.histogramsGenerated.doubleValue());
        this.upsertGauges("java-lib.metrics.http", gauges);
    }

    @VisibleForTesting
    int getHistogramsGenerated() {
        return this.histogramsGenerated.get();
    }

    @VisibleForTesting
    int getMetricsGenerated() {
        return this.metricsGenerated.get();
    }

    @VisibleForTesting
    int getMetricsFailedToSend() {
        return this.metricsFailedToSend.get();
    }

    public void start(long period, TimeUnit unit) {
        this.executor.scheduleAtFixedRate(this, period, period, unit);
    }

    public void start(long initialDelay, long period, TimeUnit unit) {
        this.executor.scheduleAtFixedRate(this, initialDelay, period, unit);
    }

    public void shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(timeout, unit);
        super.shutdown();
    }

    public void shutdown() {
        this.executor.shutdown();
        super.shutdown();
    }

    @Override
    public void run() {
        try {
            if (this.includeJvmMetrics) {
                this.upsertJavaMetrics();
            }
            if (this.includeReporterMetrics) {
                this.upsertReporterMetrics();
            }
            this.getMetricsRegistry().allMetrics().entrySet().stream().filter(m -> !(m.getValue() instanceof WavefrontHistogram)).forEach(this::processEntry);
            this.getMetricsRegistry().allMetrics().entrySet().stream().filter(m -> m.getValue() instanceof WavefrontHistogram).forEach(this::processEntry);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot report point to Wavefront! Trying again next iteration.", e);
        }
    }

    private void processEntry(Map.Entry<MetricName, Metric> entry) {
        MetricName metricName = entry.getKey();
        Metric metric = entry.getValue();
        if (this.metricTranslator != null) {
            Pair pair = (Pair)this.metricTranslator.apply((Object)Pair.of((Object)metricName, (Object)metric));
            if (pair == null) {
                return;
            }
            metricName = (MetricName)pair._1;
            metric = (Metric)pair._2;
        }
        try {
            metric.processWith((MetricProcessor)this.httpMetricsProcessor, metricName, null);
            if (!(metric instanceof WavefrontHistogram)) {
                this.metricsGenerated.incrementAndGet();
            } else {
                this.histogramsGenerated.incrementAndGet();
            }
        }
        catch (Exception e) {
            this.metricsFailedToSend.incrementAndGet();
            logger.log(Level.WARNING, "Unable to process entry and pass to the metrics processor", e);
        }
    }

    public void flush() {
        this.httpMetricsProcessor.flush();
    }

    public static class Builder {
        private MetricsRegistry metricsRegistry;
        private String name;
        private String defaultSource;
        private String hostname;
        private int port;
        private String secondaryHostname;
        private int secondaryPort;
        private Supplier<Long> timeSupplier = System::currentTimeMillis;
        private boolean prependGroupName = false;
        private MetricTranslator metricTranslator = null;
        private Map<String, String> sdkInternalTags = Maps.newConcurrentMap();
        private boolean includeJvmMetrics = false;
        private boolean includeReporterMetrics = true;
        private boolean sendZeroCounters = false;
        private boolean sendEmptyHistograms = false;
        private boolean clear = false;
        private int queueSize = 0;
        private int batchSize = 0;
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private int flushInterval = 1;

        public Builder withMetricsRegistry(MetricsRegistry metricsRegistry) {
            this.metricsRegistry = metricsRegistry;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDefaultSource(String defaultSource) {
            this.defaultSource = defaultSource;
            return this;
        }

        public Builder withTimeSupplier(Supplier<Long> timeSupplier) {
            this.timeSupplier = timeSupplier;
            return this;
        }

        public Builder withEndpoint(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
            return this;
        }

        public Builder withSecondaryEndpoint(String hostname, int port) {
            this.secondaryHostname = hostname;
            this.secondaryPort = port;
            return this;
        }

        public Builder withQueueOptions(int batchSize, int queueSize) {
            this.batchSize = batchSize;
            this.queueSize = queueSize;
            return this;
        }

        public Builder withPrependedGroupNames(boolean prependGroupName) {
            this.prependGroupName = prependGroupName;
            return this;
        }

        public Builder clearHistogramsAndTimers(boolean clear) {
            this.clear = clear;
            return this;
        }

        public Builder sendZeroCounters(boolean send) {
            this.sendZeroCounters = send;
            return this;
        }

        public Builder sendEmptyHistograms(boolean send) {
            this.sendEmptyHistograms = send;
            return this;
        }

        public Builder includeJvmMetrics(boolean include) {
            this.includeJvmMetrics = include;
            return this;
        }

        public Builder includeReporterMetrics(boolean include) {
            this.includeReporterMetrics = include;
            return this;
        }

        public Builder withMetricTranslator(MetricTranslator metricTranslator) {
            this.metricTranslator = metricTranslator;
            return this;
        }

        public Builder withSdkInternalTags(Map<String, String> tags) {
            this.sdkInternalTags.putAll(tags);
            return this;
        }

        public Builder withFlushInterval(TimeUnit timeUnit, int flushInterval) {
            this.timeUnit = timeUnit;
            this.flushInterval = flushInterval;
            return this;
        }

        public WavefrontYammerHttpMetricsReporter build() throws IOReactorException {
            if (StringUtils.isBlank((String)this.name)) {
                throw new IllegalArgumentException("Reporter must have a human readable name.");
            }
            if (StringUtils.isBlank((String)this.hostname)) {
                throw new IllegalArgumentException("Hostname may not be blank.");
            }
            return new WavefrontYammerHttpMetricsReporter(this);
        }
    }
}

