/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.integrations.metrics;

import com.wavefront.integrations.metrics.WavefrontMetricsProcessor;
import com.wavefront.metrics.ReconnectingSocket;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.WavefrontHistogram;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.net.SocketFactory;

public class SocketMetricsProcessor
extends WavefrontMetricsProcessor {
    private ReconnectingSocket metricsSocket;
    private ReconnectingSocket histogramsSocket;
    private final Supplier<Long> timeSupplier;
    private static final Pattern SIMPLE_NAMES = Pattern.compile("[^a-zA-Z0-9_.\\-~]");

    SocketMetricsProcessor(String hostname, int port, int wavefrontHistogramPort, Supplier<Long> timeSupplier, boolean prependGroupName, boolean clear, boolean sendZeroCounters, boolean sendEmptyHistograms) throws IOException {
        this(hostname, port, wavefrontHistogramPort, timeSupplier, prependGroupName, clear, sendZeroCounters, sendEmptyHistograms, null);
    }

    SocketMetricsProcessor(String hostname, int port, int wavefrontHistogramPort, Supplier<Long> timeSupplier, boolean prependGroupName, boolean clear, boolean sendZeroCounters, boolean sendEmptyHistograms, @Nullable Long connectionTimeToLiveMillis) throws IOException {
        super(prependGroupName, clear, sendZeroCounters, sendEmptyHistograms);
        this.timeSupplier = timeSupplier;
        this.metricsSocket = new ReconnectingSocket(hostname, port, SocketFactory.getDefault(), connectionTimeToLiveMillis, timeSupplier);
        this.histogramsSocket = new ReconnectingSocket(hostname, wavefrontHistogramPort, SocketFactory.getDefault(), connectionTimeToLiveMillis, timeSupplier);
    }

    @Override
    protected void writeMetric(MetricName name, @Nullable String nameSuffix, double value) throws Exception {
        String line = this.toWavefrontMetricLine(name, nameSuffix, this.timeSupplier, value);
        this.metricsSocket.write(line);
    }

    @Override
    protected void writeHistogram(MetricName name, WavefrontHistogram histogram, Void context) throws Exception {
        List<String> histogramLines = this.toWavefrontHistogramLines(name, histogram);
        for (String histogramLine : histogramLines) {
            this.histogramsSocket.write(histogramLine);
        }
    }

    @Override
    protected void flush() throws IOException {
        this.metricsSocket.flush();
        this.histogramsSocket.flush();
    }
}

