/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.integrations.metrics;

import com.tdunning.math.stats.Centroid;
import com.wavefront.common.MetricsToTimeseries;
import com.wavefront.common.SerializerUtils;
import com.wavefront.common.TaggedMetricName;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.DeltaCounter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.Sampling;
import com.yammer.metrics.core.Summarizable;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.WavefrontHistogram;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

abstract class WavefrontMetricsProcessor
implements MetricProcessor<Void> {
    private static final Pattern SIMPLE_NAMES = Pattern.compile("[^a-zA-Z0-9_.\\-~]");
    private final boolean prependGroupName;
    private final boolean sendZeroCounters;
    private final boolean sendEmptyHistograms;
    final boolean clear;

    WavefrontMetricsProcessor(boolean prependGroupName, boolean clear, boolean sendZeroCounters, boolean sendEmptyHistograms) {
        this.prependGroupName = prependGroupName;
        this.clear = clear;
        this.sendZeroCounters = sendZeroCounters;
        this.sendEmptyHistograms = sendEmptyHistograms;
    }

    abstract void writeMetric(MetricName var1, @Nullable String var2, double var3) throws Exception;

    abstract void writeHistogram(MetricName var1, WavefrontHistogram var2, Void var3) throws Exception;

    abstract void flush() throws Exception;

    String toWavefrontMetricLine(MetricName name, String nameSuffix, Supplier<Long> timeSupplier, double value) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(this.getName(name));
        if (nameSuffix != null && !nameSuffix.equals("")) {
            sb.append(".").append(nameSuffix);
        }
        sb.append("\" ").append(value).append(" ").append(timeSupplier.get() / 1000L);
        if (name instanceof TaggedMetricName) {
            SerializerUtils.appendTagMap((StringBuilder)sb, (Map)((TaggedMetricName)name).getTags());
        }
        return sb.append("\n").toString();
    }

    List<String> toWavefrontHistogramLines(MetricName name, WavefrontHistogram histogram) {
        List bins = histogram.bins(this.clear);
        if (bins.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> histogramLines = new ArrayList<String>();
        for (WavefrontHistogram.MinuteBin minuteBin : bins) {
            StringBuilder sb = new StringBuilder();
            sb.append("!M ").append(minuteBin.getMinMillis() / 1000L);
            WavefrontMetricsProcessor.appendCompactedCentroids(sb, minuteBin.getDist().centroids());
            sb.append(" \"").append(this.getName(name)).append("\"");
            if (name instanceof TaggedMetricName) {
                SerializerUtils.appendTagMap((StringBuilder)sb, (Map)((TaggedMetricName)name).getTags());
            }
            sb.append("\n");
            histogramLines.add(sb.toString());
        }
        return histogramLines;
    }

    String toBatchedWavefrontHistogramLines(MetricName name, WavefrontHistogram histogram) {
        return String.join((CharSequence)"\n", this.toWavefrontHistogramLines(name, histogram));
    }

    private static void appendCompactedCentroids(StringBuilder sb, Collection<Centroid> centroids) {
        Centroid accumulator = null;
        for (Centroid c : centroids) {
            if (accumulator != null && c.mean() != accumulator.mean()) {
                sb.append(" #").append(accumulator.count()).append(" ").append(accumulator.mean());
                accumulator = new Centroid(c.mean(), c.count());
                continue;
            }
            if (accumulator == null) {
                accumulator = new Centroid(c.mean(), c.count());
                continue;
            }
            accumulator.add(c.mean(), c.count());
        }
        if (accumulator != null) {
            sb.append(" #").append(accumulator.count()).append(" ").append(accumulator.mean());
        }
    }

    private void writeMetered(MetricName name, Metered metered) throws Exception {
        for (Map.Entry entry : MetricsToTimeseries.explodeMetered((Metered)metered).entrySet()) {
            this.writeMetric(name, (String)entry.getKey(), (Double)entry.getValue());
        }
    }

    private void writeSummarizable(MetricName name, Summarizable summarizable) throws Exception {
        for (Map.Entry entry : MetricsToTimeseries.explodeSummarizable((Summarizable)summarizable).entrySet()) {
            this.writeMetric(name, (String)entry.getKey(), (Double)entry.getValue());
        }
    }

    private void writeSampling(MetricName name, Sampling sampling) throws Exception {
        for (Map.Entry entry : MetricsToTimeseries.explodeSampling((Sampling)sampling).entrySet()) {
            this.writeMetric(name, (String)entry.getKey(), (Double)entry.getValue());
        }
    }

    String getName(MetricName name) {
        if (this.prependGroupName && name.getGroup() != null && !name.getGroup().equals("")) {
            return this.sanitize(name.getGroup() + "." + name.getName());
        }
        return this.sanitize(name.getName());
    }

    private String sanitize(String name) {
        return SIMPLE_NAMES.matcher(name).replaceAll("_");
    }

    private void clear(@Nullable Histogram histogram, @Nullable Timer timer) {
        if (!this.clear) {
            return;
        }
        if (histogram != null) {
            histogram.clear();
        }
        if (timer != null) {
            timer.clear();
        }
    }

    public void processMeter(MetricName name, Metered meter, Void context) throws Exception {
        this.writeMetered(name, meter);
    }

    public void processCounter(MetricName name, Counter counter, Void context) throws Exception {
        if (!this.sendZeroCounters && counter.count() == 0L) {
            return;
        }
        if (counter instanceof DeltaCounter) {
            long count = DeltaCounter.processDeltaCounter((DeltaCounter)((DeltaCounter)counter));
            this.writeMetric(name, null, count);
        } else {
            this.writeMetric(name, null, counter.count());
        }
    }

    public void processHistogram(MetricName name, Histogram histogram, Void context) throws Exception {
        if (histogram instanceof WavefrontHistogram) {
            this.writeHistogram(name, (WavefrontHistogram)histogram, context);
        } else if (!this.sendEmptyHistograms && histogram.count() == 0L) {
            this.writeMetric(name, "count", 0.0);
        } else {
            this.writeMetric(name, "count", histogram.count());
            this.writeSampling(name, (Sampling)histogram);
            this.writeSummarizable(name, (Summarizable)histogram);
            this.clear(histogram, null);
        }
    }

    public void processTimer(MetricName name, Timer timer, Void context) throws Exception {
        MetricName rateName;
        MetricName samplingName;
        if (name instanceof TaggedMetricName) {
            TaggedMetricName taggedMetricName = (TaggedMetricName)name;
            samplingName = new TaggedMetricName(taggedMetricName.getGroup(), taggedMetricName.getName() + ".duration", taggedMetricName.getTags());
            rateName = new TaggedMetricName(taggedMetricName.getGroup(), taggedMetricName.getName() + ".rate", taggedMetricName.getTags());
        } else {
            samplingName = new MetricName(name.getGroup(), name.getType(), name.getName() + ".duration");
            rateName = new MetricName(name.getGroup(), name.getType(), name.getName() + ".rate");
        }
        this.writeSummarizable(samplingName, (Summarizable)timer);
        this.writeSampling(samplingName, (Sampling)timer);
        this.writeMetered(rateName, (Metered)timer);
        this.clear(null, timer);
    }

    public void processGauge(MetricName name, Gauge<?> gauge, Void context) throws Exception {
        if (gauge == null) {
            return;
        }
        Object value = gauge.value();
        if (value != null) {
            this.writeMetric(name, null, Double.parseDouble(value.toString()));
        }
    }
}

