/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.predicates;

import com.google.common.base.MoreObjects;
import com.mdimension.jchronic.Chronic;
import com.mdimension.jchronic.Options;
import com.wavefront.ingester.AbstractIngesterFormatter;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wavefront.report.Annotation;
import wavefront.report.ReportHistogram;
import wavefront.report.ReportLog;
import wavefront.report.ReportMetric;
import wavefront.report.ReportPoint;
import wavefront.report.Span;

public abstract class Util {
    private static final Pattern PLACEHOLDERS = Pattern.compile("\\{\\{(.*?)}}");

    private Util() {
    }

    public static long parseTextualTimeExact(String interval, long anchorTime, TimeZone timeZone) {
        Calendar instance = Calendar.getInstance();
        instance.setTimeZone(timeZone);
        instance.setTimeInMillis(anchorTime);
        com.mdimension.jchronic.utils.Span parse = Chronic.parse((String)AbstractIngesterFormatter.unquote(interval), (Options)new Options(instance));
        if (parse == null) {
            throw new IllegalArgumentException("Failed to parse " + interval + " as a time-expression");
        }
        return parse.getBeginCalendar().getTimeInMillis();
    }

    @Deprecated
    public static String expandPlaceholders(String input, ReportPoint reportPoint) {
        if (reportPoint != null && input.contains("{{")) {
            StringBuffer result = new StringBuffer();
            Matcher placeholders = PLACEHOLDERS.matcher(input);
            while (placeholders.find()) {
                String substitution;
                if (placeholders.group(1).isEmpty()) {
                    placeholders.appendReplacement(result, placeholders.group(0));
                    continue;
                }
                switch (placeholders.group(1)) {
                    case "metricName": {
                        substitution = reportPoint.getMetric();
                        break;
                    }
                    case "sourceName": {
                        substitution = reportPoint.getHost();
                        break;
                    }
                    default: {
                        substitution = reportPoint.getAnnotations().get(placeholders.group(1));
                    }
                }
                placeholders.appendReplacement(result, (String)MoreObjects.firstNonNull((Object)substitution, (Object)""));
            }
            placeholders.appendTail(result);
            return result.toString();
        }
        return input;
    }

    public static String expandPlaceholders(String input, ReportMetric reportMetric) {
        if (reportMetric != null && input.contains("{{")) {
            StringBuffer result = new StringBuffer();
            Matcher placeholders = PLACEHOLDERS.matcher(input);
            while (placeholders.find()) {
                String substitution;
                if (placeholders.group(1).isEmpty()) {
                    placeholders.appendReplacement(result, placeholders.group(0));
                    continue;
                }
                switch (placeholders.group(1)) {
                    case "metricName": {
                        substitution = reportMetric.getMetric();
                        break;
                    }
                    case "sourceName": {
                        substitution = reportMetric.getHost();
                        break;
                    }
                    default: {
                        substitution = reportMetric.getAnnotations().stream().filter(a -> a.getKey().equals(placeholders.group(1))).map(Annotation::getValue).findFirst().orElse(null);
                    }
                }
                placeholders.appendReplacement(result, (String)MoreObjects.firstNonNull((Object)substitution, (Object)""));
            }
            placeholders.appendTail(result);
            return result.toString();
        }
        return input;
    }

    public static String expandPlaceholders(String input, ReportHistogram reportHistogram) {
        if (reportHistogram != null && input.contains("{{")) {
            StringBuffer result = new StringBuffer();
            Matcher placeholders = PLACEHOLDERS.matcher(input);
            while (placeholders.find()) {
                String substitution;
                if (placeholders.group(1).isEmpty()) {
                    placeholders.appendReplacement(result, placeholders.group(0));
                    continue;
                }
                switch (placeholders.group(1)) {
                    case "metricName": {
                        substitution = reportHistogram.getMetric();
                        break;
                    }
                    case "sourceName": {
                        substitution = reportHistogram.getHost();
                        break;
                    }
                    default: {
                        substitution = reportHistogram.getAnnotations().stream().filter(a -> a.getKey().equals(placeholders.group(1))).map(Annotation::getValue).findFirst().orElse(null);
                    }
                }
                placeholders.appendReplacement(result, (String)MoreObjects.firstNonNull((Object)substitution, (Object)""));
            }
            placeholders.appendTail(result);
            return result.toString();
        }
        return input;
    }

    public static String expandPlaceholders(String input, Span span) {
        if (span != null && input.contains("{{")) {
            StringBuffer result = new StringBuffer();
            Matcher placeholders = PLACEHOLDERS.matcher(input);
            while (placeholders.find()) {
                String substitution;
                if (placeholders.group(1).isEmpty()) {
                    placeholders.appendReplacement(result, placeholders.group(0));
                    continue;
                }
                switch (placeholders.group(1)) {
                    case "spanName": {
                        substitution = span.getName();
                        break;
                    }
                    case "sourceName": {
                        substitution = span.getSource();
                        break;
                    }
                    default: {
                        substitution = span.getAnnotations().stream().filter(a -> a.getKey().equals(placeholders.group(1))).map(Annotation::getValue).findFirst().orElse(null);
                    }
                }
                placeholders.appendReplacement(result, (String)MoreObjects.firstNonNull((Object)substitution, (Object)""));
            }
            placeholders.appendTail(result);
            return result.toString();
        }
        return input;
    }

    public static String expandPlaceholders(String input, ReportLog reportLog) {
        if (reportLog != null && input.contains("{{")) {
            StringBuffer result = new StringBuffer();
            Matcher placeholders = PLACEHOLDERS.matcher(input);
            while (placeholders.find()) {
                String substitution;
                if (placeholders.group(1).isEmpty()) {
                    placeholders.appendReplacement(result, placeholders.group(0));
                    continue;
                }
                switch (placeholders.group(1)) {
                    case "message": {
                        substitution = reportLog.getMessage();
                        break;
                    }
                    case "sourceName": {
                        substitution = reportLog.getHost();
                        break;
                    }
                    default: {
                        substitution = reportLog.getAnnotations().stream().filter(a -> a.getKey().equals(placeholders.group(1))).map(Annotation::getValue).findFirst().orElse(null);
                    }
                }
                placeholders.appendReplacement(result, (String)MoreObjects.firstNonNull((Object)substitution, (Object)""));
            }
            placeholders.appendTail(result);
            return result.toString();
        }
        return input;
    }
}

