/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.predicates;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.common.TimeProvider;
import com.wavefront.predicates.ErrorListener;
import com.wavefront.predicates.ExpressionPredicate;
import com.wavefront.predicates.ExpressionSyntaxException;
import com.wavefront.predicates.PredicateEvalExpression;
import com.wavefront.predicates.PredicateExpressionVisitorImpl;
import condition.parser.PredicateExpressionLexer;
import condition.parser.PredicateExpressionParser;
import java.util.function.Predicate;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public abstract class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> fromPredicateEvalExpression(String predicateString) {
        return new ExpressionPredicate(Predicates.parsePredicateEvalExpression(predicateString));
    }

    @VisibleForTesting
    static PredicateEvalExpression parsePredicateEvalExpression(String predicateString) {
        return Predicates.parsePredicateEvalExpression(predicateString, System::currentTimeMillis);
    }

    @VisibleForTesting
    static PredicateEvalExpression parsePredicateEvalExpression(String predicateString, TimeProvider timeProvider) {
        PredicateExpressionLexer lexer = new PredicateExpressionLexer((CharStream)CharStreams.fromString((String)predicateString));
        lexer.removeErrorListeners();
        ErrorListener errorListener = new ErrorListener();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PredicateExpressionParser parser = new PredicateExpressionParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        PredicateExpressionVisitorImpl visitor = new PredicateExpressionVisitorImpl(timeProvider);
        PredicateExpressionParser.ProgramContext context = parser.program();
        PredicateEvalExpression result = (PredicateEvalExpression)context.evalExpression().accept(visitor);
        if (errorListener.getErrors().length() == 0) {
            return result;
        }
        throw new ExpressionSyntaxException(errorListener.getErrors().toString());
    }
}

