/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Annotation;
import wavefront.report.ReportLog;

public class ReportLogIngesterFormatter
extends AbstractIngesterFormatter<ReportLog> {
    private final String NONE = "none";
    private final String APPLICATION = "application";
    private final String SERVICE = "service";
    private final String LOG_LEVEL = "log_level";
    private final String ERROR_NAME = "error_name";

    private ReportLogIngesterFormatter(List<AbstractIngesterFormatter.FormatterElement<ReportLog>> elements) {
        super(elements);
    }

    public static AbstractIngesterFormatter.IngesterFormatBuilder<ReportLog> newBuilder() {
        return new ReportLogIngesterFormatBuilder();
    }

    @Override
    public ReportLog drive(String logJson, @Nullable Supplier<String> defaultHostNameSupplier, String customerId, @Nullable List<String> customSourceTags, @Nullable List<String> customLogTimestampTags, @Nullable List<String> customLogMessageTags, List<String> customLogApplicationTags, List<String> customLogServiceTags, @Nullable List<String> customLogLevelTags, @Nullable List<String> customLogExceptionTags, @Nullable IngesterContext ingesterContext) {
        ReportLog log = new ReportLog();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        try {
            String exception;
            String level;
            String service;
            Map tagMap = (Map)new ObjectMapper().readValue(logJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
            List<String> logMessageTags = customLogMessageTags == null ? AbstractIngesterFormatter.getDefaultLogMessageKeys() : Stream.concat(AbstractIngesterFormatter.getDefaultLogMessageKeys().stream(), customLogMessageTags.stream()).collect(Collectors.toList());
            JsonParser parser = new JsonParser(tagMap, logMessageTags);
            parser.flattenJson(annotations);
            log.setAnnotations(annotations);
            String host = AbstractIngesterFormatter.getHostAndNormalizeTags(log.getAnnotations(), customSourceTags, false);
            if (host == null) {
                host = defaultHostNameSupplier == null ? "unknown" : defaultHostNameSupplier.get();
            }
            log.setHost(host);
            Long timestamp = AbstractIngesterFormatter.getLogTimestamp(log.getAnnotations(), customLogTimestampTags);
            log.setTimestamp(timestamp);
            String message = AbstractIngesterFormatter.getLogMessage(log.getAnnotations(), customLogMessageTags);
            log.setMessage(message);
            String application = AbstractIngesterFormatter.getLogApplication(log.getAnnotations(), customLogApplicationTags);
            if (!StringUtils.equalsIgnoreCase((String)application, (String)"none")) {
                log.getAnnotations().add(Annotation.newBuilder().setKey("application").setValue(application).build());
            }
            if (!StringUtils.equalsIgnoreCase((String)(service = AbstractIngesterFormatter.getLogService(log.getAnnotations(), customLogServiceTags)), (String)"none")) {
                log.getAnnotations().add(Annotation.newBuilder().setKey("service").setValue(service).build());
            }
            if (!StringUtils.equalsIgnoreCase((String)(level = AbstractIngesterFormatter.getLogLevel(log.getAnnotations(), customLogLevelTags)), (String)"")) {
                log.getAnnotations().add(Annotation.newBuilder().setKey("log_level").setValue(level).build());
            }
            if (!StringUtils.equalsIgnoreCase((String)(exception = AbstractIngesterFormatter.getLogException(log.getAnnotations(), customLogExceptionTags)), (String)"")) {
                log.getAnnotations().add(Annotation.newBuilder().setKey("error_name").setValue(exception).build());
            }
            return log;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class ReportLogIngesterFormatBuilder
    extends AbstractIngesterFormatter.IngesterFormatBuilder<ReportLog> {
        public ReportLogIngesterFormatter build() {
            return new ReportLogIngesterFormatter(this.elements);
        }
    }
}

