/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.ReportLogIngesterFormatter;
import com.wavefront.ingester.ReportableEntityDecoder;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import wavefront.report.ReportLog;

public class ReportLogDecoder
implements ReportableEntityDecoder<String, ReportLog> {
    private static final AbstractIngesterFormatter<ReportLog> FORMAT = ReportLogIngesterFormatter.newBuilder().build();
    private final Supplier<String> hostNameSupplier;
    private List<String> customSourceTags;
    private List<String> customLogTimestampTags;
    private List<String> customLogMessageTags;
    private List<String> customApplicationTags;
    private List<String> customServiceTags;
    private List<String> customLevelTags;
    private List<String> customExceptionTags;

    public ReportLogDecoder(@Nullable Supplier<String> hostNameSupplier, List<String> customSourceTags, List<String> customLogTimestampTags, List<String> customLogMessageTags, List<String> customApplicationTags, List<String> customServiceTags) {
        this.hostNameSupplier = hostNameSupplier;
        this.customSourceTags = customSourceTags;
        this.customLogTimestampTags = customLogTimestampTags;
        this.customLogMessageTags = customLogMessageTags;
        this.customApplicationTags = customApplicationTags;
        this.customServiceTags = customServiceTags;
    }

    public ReportLogDecoder(@Nullable Supplier<String> hostNameSupplier, List<String> customSourceTags, List<String> customLogTimestampTags, List<String> customLogMessageTags, List<String> customApplicationTags, List<String> customServiceTags, List<String> customLevelTags, List<String> customExceptionTags) {
        this.hostNameSupplier = hostNameSupplier;
        this.customSourceTags = customSourceTags;
        this.customLogTimestampTags = customLogTimestampTags;
        this.customLogMessageTags = customLogMessageTags;
        this.customApplicationTags = customApplicationTags;
        this.customServiceTags = customServiceTags;
        this.customLevelTags = customLevelTags;
        this.customExceptionTags = customExceptionTags;
    }

    @Override
    public void decode(String msg, List<ReportLog> out, String customerId, @Nullable IngesterContext ctx) {
        ReportLog log = FORMAT.drive(msg, this.hostNameSupplier, "default", this.customSourceTags, this.customLogTimestampTags, this.customLogMessageTags, this.customApplicationTags, this.customServiceTags, this.customLevelTags, this.customExceptionTags, ctx);
        if (out != null) {
            out.add(log);
        }
    }
}

