/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import wavefront.report.Annotation;

public class JsonParser {
    private final Map<String, Object> input;
    private final String UNDERSCORE = "_";
    private final List<String> ignoreFlatten;
    char[] labelsToReplace = new char[]{'-', '.', '/'};

    public JsonParser(@Nonnull Map<String, Object> input, List<String> ignoreFlatten) {
        this.input = input;
        this.ignoreFlatten = ignoreFlatten;
    }

    public void flattenJson(List<Annotation> annotations) {
        for (Map.Entry<String, Object> tagKV : this.input.entrySet()) {
            this.flattenJsonInternal(tagKV.getKey(), tagKV.getValue(), annotations);
        }
    }

    private void flattenJsonInternal(String key, Object value, List<Annotation> annotations) {
        if (value == null) {
            annotations.add(Annotation.newBuilder().setKey(this.labelReplace(key)).setValue("null").build());
        } else if (this.ignoreFlatten.contains(key) || value instanceof String) {
            annotations.add(Annotation.newBuilder().setKey(this.labelReplace(key)).setValue(value.toString()).build());
        } else if (value instanceof Map) {
            for (Map.Entry tagKV : ((Map)value).entrySet()) {
                this.flattenJsonInternal(this.concatonate(key, tagKV.getKey().toString()), tagKV.getValue(), annotations);
            }
        } else if (value instanceof List) {
            for (int i = 0; i < ((List)value).size(); ++i) {
                this.flattenJsonInternal(this.concatonate(key, String.valueOf(i)), ((List)value).get(i), annotations);
            }
        } else {
            annotations.add(Annotation.newBuilder().setKey(this.labelReplace(key)).setValue(value.toString()).build());
        }
    }

    private String concatonate(String s1, String s2) {
        return s1 + "_" + s2;
    }

    private String labelReplace(String label) {
        String finalLabel = label;
        for (char charToReplace : this.labelsToReplace) {
            finalLabel = finalLabel.replace(charToReplace, '_');
        }
        return finalLabel;
    }
}

