/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wavefront.common.SerializerUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import wavefront.report.ReportEvent;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Event
implements Serializable {
    @JsonProperty
    private String name;
    @JsonProperty
    private long startTime;
    @JsonProperty
    private Long endTime;
    @JsonProperty
    private Map<String, String> annotations;
    @JsonProperty
    private Map<String, List<String>> dimensions;
    @JsonProperty
    private List<String> hosts;
    @JsonProperty
    private List<String> tags;

    private Event() {
    }

    public Event(ReportEvent event) {
        this.name = event.getName();
        this.startTime = event.getStartTime();
        this.endTime = event.getEndTime();
        this.annotations = new HashMap<String, String>(event.getAnnotations());
        this.dimensions = event.getDimensions() == null ? null : event.getDimensions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> new ArrayList((Collection)v.getValue())));
        this.hosts = new ArrayList<String>(event.getHosts());
        this.tags = event.getTags() == null ? null : new ArrayList<String>(event.getTags());
    }

    public String getName() {
        return this.name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    @JsonProperty
    public Long getEndTime() {
        return this.endTime;
    }

    @JsonProperty
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @JsonProperty
    public Map<String, List<String>> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public List<String> getHosts() {
        return this.hosts;
    }

    @JsonProperty
    public List<String> getTags() {
        return this.tags;
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (int)(this.startTime ^ this.startTime >>> 32);
        result = result * 31 + (this.endTime == null ? 0 : (int)(this.endTime ^ this.endTime >>> 32));
        result = result * 31 + this.annotations.hashCode();
        result = result * 31 + (this.dimensions == null ? 0 : this.dimensions.hashCode());
        result = result * 31 + this.hosts.hashCode();
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (this.startTime != other.startTime) {
            return false;
        }
        if (!Objects.equals(this.endTime, other.endTime)) {
            return false;
        }
        if (!this.annotations.equals(other.annotations)) {
            return false;
        }
        if (!Objects.equals(this.dimensions, other.dimensions)) {
            return false;
        }
        if (!this.hosts.equals(other.hosts)) {
            return false;
        }
        return Objects.equals(this.tags, other.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("@Event").append(' ');
        sb.append(this.getStartTime()).append(' ');
        if (this.getEndTime() != null) {
            sb.append(this.getEndTime());
        }
        sb.append(' ');
        SerializerUtils.appendQuoted(sb, this.getName());
        SerializerUtils.appendTags(sb, "host", this.getHosts());
        if (this.getAnnotations() != null) {
            SerializerUtils.appendTagMap(sb, this.getAnnotations());
        }
        if (this.getDimensions() != null) {
            for (Map.Entry<String, List<String>> entry : this.getDimensions().entrySet()) {
                SerializerUtils.appendTags(sb, entry.getKey(), entry.getValue());
            }
        }
        if (this.getTags() != null) {
            SerializerUtils.appendTags(sb, "tag", this.getTags());
        }
        return sb.toString();
    }
}

