/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common.logger;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.util.concurrent.RateLimiter;
import com.wavefront.common.Pair;
import com.wavefront.common.logger.DelegatingLogger;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MessageCountingLogger
extends DelegatingLogger {
    private final LoadingCache<String, Pair<RateLimiter, AtomicLong>> rateLimiterCache;

    public MessageCountingLogger(Logger delegate, long maximumSize, double rateLimit) {
        super(delegate);
        this.rateLimiterCache = Caffeine.newBuilder().expireAfterAccess((long)(2.0 / rateLimit), TimeUnit.SECONDS).maximumSize(maximumSize).build(x -> Pair.of(RateLimiter.create((double)rateLimit), new AtomicLong()));
    }

    @Override
    public void log(Level level, String message) {
        Pair limiter = Objects.requireNonNull((Pair)this.rateLimiterCache.get((Object)message));
        if (((RateLimiter)limiter._1).tryAcquire()) {
            long skipped = ((AtomicLong)limiter._2).getAndSet(0L);
            if (skipped > 0L) {
                this.log(new LogRecord(level, message + " [" + skipped + " duplicate messages skipped]"));
            } else {
                this.log(new LogRecord(level, message));
            }
        } else {
            ((AtomicLong)limiter._2).incrementAndGet();
        }
    }
}

