/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.maas.v2.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.volcengine.error.SdkError;
import com.volcengine.model.ApiInfo;
import com.volcengine.model.maas.api.v2.BaseResponse;
import com.volcengine.model.maas.api.v2.ChatReq;
import com.volcengine.model.maas.api.v2.ChatResp;
import com.volcengine.model.maas.api.v2.ClassificationReq;
import com.volcengine.model.maas.api.v2.ClassificationResp;
import com.volcengine.model.maas.api.v2.EmbeddingsReq;
import com.volcengine.model.maas.api.v2.EmbeddingsResp;
import com.volcengine.model.maas.api.v2.ErrorResp;
import com.volcengine.model.maas.api.v2.TokenizeReq;
import com.volcengine.model.maas.api.v2.TokenizeResp;
import com.volcengine.model.response.RawResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.SignableRequest;
import com.volcengine.service.maas.MaasException;
import com.volcengine.service.maas.impl.SseEvent;
import com.volcengine.service.maas.v2.MaasConfig;
import com.volcengine.service.maas.v2.MaasService;
import com.volcengine.service.maas.v2.impl.audio.Audio;
import com.volcengine.service.maas.v2.impl.images.Images;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class MaasServiceImpl
extends BaseServiceImpl
implements MaasService {
    private static final String CHAT_TERMINATOR = "[DONE]";
    private static final ObjectMapper mapper = new ObjectMapper();
    private String settedApikey = "";

    public MaasServiceImpl(String host, String region) {
        this(host, region, 60000, 60000);
    }

    public MaasServiceImpl(String host, String region, int connectionTimeout, int socketTimeout) {
        super(MaasConfig.getServiceInfo(host, region, connectionTimeout, socketTimeout), MaasConfig.getApiInfoList());
    }

    @Override
    public Audio audio() {
        return new Audio(this);
    }

    @Override
    public Images images() {
        return new Images(this);
    }

    @Override
    public ChatResp chat(String endpointId, ChatReq req) throws MaasException {
        return this.request(endpointId, "chat", req.withStream(false), ChatResp.class);
    }

    @Override
    public TokenizeResp tokenization(String endpointId, TokenizeReq req) throws MaasException {
        return this.request(endpointId, "tokenization", req, TokenizeResp.class);
    }

    @Override
    public ClassificationResp classification(String endpointId, ClassificationReq req) throws MaasException {
        return this.request(endpointId, "classification", req, ClassificationResp.class);
    }

    @Override
    public EmbeddingsResp embeddings(String endpointId, EmbeddingsReq req) throws MaasException {
        return this.request(endpointId, "embeddings", req, EmbeddingsResp.class);
    }

    @Override
    public void setApikey(String apikey) {
        this.settedApikey = apikey;
    }

    @Override
    public String getApikey() {
        return this.settedApikey;
    }

    @Override
    public Stream<ChatResp> streamChat(String endpointId, ChatReq req) throws MaasException {
        InputStream is;
        HttpResponse response;
        req.setStream(true);
        String reqId = this.genReqId();
        String apikey = this.settedApikey;
        SignableRequest request = this.prepareRequest("chat", null);
        try {
            request.setEntity((HttpEntity)new StringEntity(mapper.writeValueAsString((Object)req), "utf-8"));
            request.setHeader("x-tt-logid", reqId);
            request.setHeader("Content-Type", "application/json");
        }
        catch (JsonProcessingException e) {
            throw new MaasException((Exception)((Object)e), reqId);
        }
        try {
            URIBuilder builder = request.getUriBuilder();
            builder.setPath(String.format(builder.getPath(), endpointId));
            request.setURI(builder.build());
            if (Objects.equals(apikey, "")) {
                this.ISigner.sign(request, this.credentials);
            } else {
                request.setHeader("Authorization", "Bearer " + apikey);
            }
        }
        catch (Exception e) {
            throw new MaasException(e, reqId);
        }
        try {
            response = this.getHttpClient().execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new MaasException(e, reqId);
        }
        try {
            is = response.getEntity().getContent();
        }
        catch (IOException e) {
            throw new MaasException(e, reqId);
        }
        return SseEvent.fromInputStream(is, StandardCharsets.UTF_8).map(event -> {
            ChatResp resp;
            if (event.getData().trim().equals(CHAT_TERMINATOR)) {
                return null;
            }
            try {
                resp = MaasServiceImpl.json_parse(event.getData().getBytes(StandardCharsets.UTF_8), ChatResp.class);
            }
            catch (JsonProcessingException e) {
                this.closeInputStream(is);
                throw new RuntimeException(new MaasException((Exception)((Object)e), reqId));
            }
            if (resp.getError() != null && resp.getError().getCodeN() != 0) {
                this.closeInputStream(is);
                throw new RuntimeException(new MaasException(resp.getError(), reqId));
            }
            resp.setRequestId(reqId);
            return resp;
        }).filter(Objects::nonNull);
    }

    private void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static <T extends BaseResponse> T json_parse(byte[] data, Class<T> valueType) throws JsonProcessingException {
        return (T)((BaseResponse)mapper.readValue(new String(data, StandardCharsets.UTF_8), valueType));
    }

    private <T extends BaseResponse> T request(String endpointId, String api, Object req, Class<T> responseType) throws MaasException {
        String reqId = this.genReqId();
        String apikey = this.settedApikey;
        try {
            RawResponse response = this.json(endpointId, api, reqId, mapper.writeValueAsString(req), apikey);
            if (response.getCode() != SdkError.SUCCESS.getNumber()) {
                try {
                    ErrorResp resp = MaasServiceImpl.json_parse(response.getException().getMessage().getBytes(StandardCharsets.UTF_8), ErrorResp.class);
                    throw new MaasException(resp.getError(), reqId);
                }
                catch (JsonProcessingException ignored) {
                    throw new MaasException(response.getException(), reqId);
                }
            }
            T resp = MaasServiceImpl.json_parse(response.getData(), responseType);
            ((BaseResponse)resp).setRequestId(reqId);
            return resp;
        }
        catch (JsonProcessingException e) {
            throw new MaasException((Exception)((Object)e), reqId);
        }
    }

    protected RawResponse makeReq(String api, SignableRequest request, String apikey) {
        if (apikey != null && !apikey.isEmpty()) {
            request.setHeader("Authorization", "Bearer " + apikey);
        } else {
            try {
                this.ISigner.sign(request, this.credentials);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new RawResponse(null, SdkError.ESIGN.getNumber(), e);
            }
        }
        HttpResponse response = null;
        try {
            Object client = this.getHttpClient() != null ? this.getHttpClient() : HttpClients.createDefault();
            response = client.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            Header[] responseHeaders = response.getAllHeaders();
            if (statusCode >= 300) {
                String msg = SdkError.getErrorDesc(SdkError.EHTTP);
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                if (bytes != null && bytes.length > 0) {
                    msg = new String(bytes, StandardCharsets.UTF_8);
                }
                return new RawResponse(null, SdkError.EHTTP.getNumber(), new Exception(msg), responseHeaders, statusCode);
            }
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            return new RawResponse(bytes, SdkError.SUCCESS.getNumber(), null, responseHeaders);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
            return new RawResponse(null, SdkError.EHTTP.getNumber(), new Exception(SdkError.getErrorDesc(SdkError.EHTTP), e));
        }
    }

    public RawResponse json(String endpointId, String api, String reqId, String body, String apikey) throws MaasException {
        ApiInfo apiInfo = (ApiInfo)this.apiInfoList.get(api);
        if (apiInfo == null) {
            throw new MaasException(SdkError.getErrorDesc(SdkError.ENOAPI), reqId);
        }
        SignableRequest request = this.prepareRequest(api, null);
        request.setHeader("x-tt-logid", reqId);
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)new StringEntity(body, "utf-8"));
        try {
            URIBuilder builder = request.getUriBuilder();
            builder.setPath(String.format(builder.getPath(), endpointId));
            request.setURI(builder.build());
        }
        catch (URISyntaxException e) {
            throw new MaasException(e, reqId);
        }
        return this.makeReq(api, request, apikey);
    }

    public String genReqId() {
        int length = 34;
        StringBuilder sb = new StringBuilder();
        sb.ensureCapacity(34);
        sb.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        sb.append(String.format("%020X", new SecureRandom().nextLong()));
        return sb.toString();
    }

    public HttpResponse jsonWithHttpResponse(String endpointId, String api, String body, String apikey) throws MaasException {
        HttpResponse response;
        ApiInfo apiInfo = (ApiInfo)this.apiInfoList.get(api);
        if (apiInfo == null) {
            throw new MaasException(new Exception("sdk unknown api"), "");
        }
        SignableRequest request = this.prepareRequest(api, null);
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)new StringEntity(body, "utf-8"));
        try {
            URIBuilder builder = request.getUriBuilder();
            builder.setPath(String.format(builder.getPath(), endpointId));
            request.setURI(builder.build());
            if (apikey != null && !apikey.isEmpty()) {
                request.setHeader("Authorization", "Bearer " + apikey);
            } else {
                this.ISigner.sign(request, this.credentials);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MaasException(e, null);
        }
        try {
            response = this.getHttpClient().execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new MaasException(e, "");
        }
        return response;
    }
}

