/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.anchorlink.internal;

import com.vladsch.flexmark.ast.DoNotDecorate;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeVisitor;
import com.vladsch.flexmark.ast.VisitHandler;
import com.vladsch.flexmark.ast.Visitor;
import com.vladsch.flexmark.ext.anchorlink.AnchorLink;
import com.vladsch.flexmark.ext.anchorlink.internal.AnchorLinkOptions;
import com.vladsch.flexmark.parser.block.DocumentPostProcessor;
import com.vladsch.flexmark.parser.block.DocumentPostProcessorFactory;
import com.vladsch.flexmark.util.options.DataHolder;

public class AnchorLinkPostProcessor
extends DocumentPostProcessor {
    private final AnchorLinkOptions options;
    private final NodeVisitor myVisitor;

    public AnchorLinkPostProcessor(Document document) {
        this.options = new AnchorLinkOptions((DataHolder)document);
        this.myVisitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(Heading.class, (Visitor)new Visitor<Heading>(){

            public void visit(Heading node) {
                AnchorLinkPostProcessor.this.visit(node);
            }
        })});
    }

    public Document processDocument(Document document) {
        this.myVisitor.visit((Node)document);
        return document;
    }

    private void visit(Heading node) {
        if (!node.isOrDescendantOfType(new Class[]{DoNotDecorate.class})) {
            this.processNode(node);
        }
    }

    private void processNode(Heading node) {
        if (node.getText().isNotNull()) {
            AnchorLink anchor = new AnchorLink();
            if (!this.options.wrapText) {
                if (node.getFirstChild() == null) {
                    node.appendChild((Node)anchor);
                } else {
                    node.getFirstChild().insertBefore((Node)anchor);
                }
            } else {
                anchor.takeChildren((Node)node);
                node.appendChild((Node)anchor);
            }
        }
    }

    public static class Factory
    extends DocumentPostProcessorFactory {
        public DocumentPostProcessor create(Document document) {
            return new AnchorLinkPostProcessor(document);
        }
    }
}

