/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.kv;

import com.vertica.jdbc.kv.KVErrors;
import com.vertica.jdbc.kv.RoutableConnectionInternal;
import com.vertica.jdbc.kv.RoutableQuery;
import com.vertica.jdbc.kv.SQLWarningChainer;
import com.vertica.jdbc.kv.VerticaRoutableExecutor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Map;

public class VerticaRoutableExecutorImpl
implements VerticaRoutableExecutor {
    private RoutableQuery query;
    private boolean closed;
    SQLWarningChainer warnings = new SQLWarningChainer();

    public VerticaRoutableExecutorImpl(RoutableConnectionInternal routableConnectionInternal, String string, String string2) throws SQLException {
        this.query = new RoutableQuery(routableConnectionInternal, string, string2, this.warnings);
    }

    @Override
    public synchronized ResultSet execute(String string, Map<String, Object> map) throws SQLException {
        this.checkInvalidSQL(string);
        if (map == null || map.isEmpty()) {
            throw KVErrors.MissingSegmentationInformation.makeException(new Object[0]);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string2 : map.keySet()) {
            hashMap.put(string2.toLowerCase(), map.get(string2));
        }
        return this.execute_internal(string, hashMap);
    }

    @Override
    public synchronized ResultSet execute(String string, String string2, Object object) throws SQLException {
        this.checkInvalidSQL(string);
        if (string2 == null) {
            throw KVErrors.MissingSegmentationColumnName.makeException(new Object[0]);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(string2.toLowerCase(), object);
        return this.execute_internal(string, hashMap);
    }

    @Override
    public synchronized void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            this.query.close();
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.warnings.get();
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw KVErrors.RoutableExecutorClosed.makeException(new Object[0]);
        }
    }

    private void checkInvalidSQL(String string) throws SQLException {
        if (string == null) {
            throw KVErrors.ImproperSqlStatement.makeException(new Object[0]);
        }
    }

    private synchronized ResultSet execute_internal(String string, Map<String, Object> map) throws SQLException {
        this.checkClosed();
        return this.query.executeSQLQuery(string, map);
    }
}

