/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc41;

import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.common.SUpdatableForwardResultSet;
import com.vertica.jdbc.jdbc41.S41ResultSetMetaData;
import com.vertica.jdbc.jdbc41.utilities.ResultSetUtilities;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.utilities.JDBCVersion;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class S41UpdatableForwardResultSet
extends SUpdatableForwardResultSet {
    public S41UpdatableForwardResultSet(SStatement statement, IResultSet resultSet, ILogger logger) throws SQLException {
        super(statement, resultSet, logger);
        this.m_jdbcVersion = JDBCVersion.JDBC41;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                this.initializeResultSetColumns();
                this.setResultSetMetadata(new S41ResultSetMetaData(this.getResultSetColumns(), this.getLogger(), this.getWarningListener()));
            }
            return this.getResultSetMetaData();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, type);
            this.checkIfOpen();
            return ResultSetUtilities.getObjectByType(this, columnIndex, type);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnLabel, type);
        return this.getObject(this.findColumn(columnLabel), type);
    }
}

