/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.ColumnMetadata;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SDatabaseMetaData;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.JDBCVersion;
import com.vertica.utilities.MetaDataFactory;
import com.vertica.utilities.TypeNames;
import com.vertica.utilities.conversion.TypeConverter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public abstract class SMetaDataProxy
extends SForwardResultSet {
    private MetadataSourceID m_metadataType = null;
    private int[] m_columnMap = null;
    private int m_dataTypeColIndex = -1;
    private DatabaseMetaData m_parentMetaData = null;
    protected IWarningListener m_warningListener = null;

    protected SMetaDataProxy(DatabaseMetaData dbMeta, IResultSet resultSet, MetadataSourceID metadataType, ILogger logger, JDBCVersion jdbcVersion) throws SQLException {
        super(null, resultSet, logger);
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{dbMeta, resultSet, metadataType, logger});
            this.m_parentMetaData = dbMeta;
            this.m_metadataType = metadataType;
            this.m_warningListener = super.getWarningListener();
            this.m_warningListener.setLocale(this.getParentConnection().getLocale());
            this.m_jdbcVersion = jdbcVersion;
            this.m_streamBufferSize = this.getStreamBufferSize();
            this.initializeColumnMap(metadataType);
            this.initializeDataTypeColIndex(metadataType);
            this.initializeColumnNameMap();
            if (MetadataSourceID.CATALOG_ONLY == this.m_metadataType || MetadataSourceID.CATALOG_SCHEMA_ONLY == this.m_metadataType || MetadataSourceID.SCHEMA_ONLY == this.m_metadataType || MetadataSourceID.TABLETYPE_ONLY == this.m_metadataType) {
                while (this.m_cachedDataWrappers.size() < 4) {
                    this.m_cachedDataWrappers.add(new DataWrapper());
                }
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_parentMetaData) {
            ((SDatabaseMetaData)this.m_parentMetaData).removeResultSet(this);
            this.m_parentMetaData = null;
        }
        super.close();
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getArray(this.getMappedColumnIndex(columnIndex));
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getAsciiStream(this.getMappedColumnIndex(columnIndex));
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            int col = this.getMappedColumnIndex(columnIndex);
            if (col == this.m_dataTypeColIndex) {
                return BigDecimal.valueOf(TypeUtilities.mapDataTypes(super.getInt(col)));
            }
            return super.getBigDecimal(col);
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, scale);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            int col = this.getMappedColumnIndex(columnIndex);
            if (col == this.m_dataTypeColIndex) {
                return BigDecimal.valueOf(TypeUtilities.mapDataTypes(super.getInt(col)), scale);
            }
            return super.getBigDecimal(col, scale);
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getBinaryStream(this.getMappedColumnIndex(columnIndex));
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getBlob(this.getMappedColumnIndex(columnIndex));
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return false;
            }
            return super.getBoolean(this.getMappedColumnIndex(columnIndex));
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return 0;
            }
            int col = this.getMappedColumnIndex(columnIndex);
            if (col == this.m_dataTypeColIndex) {
                return (byte)TypeUtilities.mapDataTypes(super.getInt(col));
            }
            return super.getByte(col);
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getBytes(this.getMappedColumnIndex(columnIndex));
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getCharacterStream(this.getMappedColumnIndex(columnIndex));
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getClob(this.getMappedColumnIndex(columnIndex));
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getDate(this.getMappedColumnIndex(columnIndex));
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, cal);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getDate(this.getMappedColumnIndex(columnIndex), cal);
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return 0.0;
            }
            int col = this.getMappedColumnIndex(columnIndex);
            if (col == this.m_dataTypeColIndex) {
                return TypeUtilities.mapDataTypes(super.getInt(col));
            }
            return super.getDouble(col);
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return 0.0f;
            }
            int col = this.getMappedColumnIndex(columnIndex);
            if (col == this.m_dataTypeColIndex) {
                return TypeUtilities.mapDataTypes(super.getInt(col));
            }
            return super.getFloat(col);
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_parentMetaData.getConnection().getHoldability();
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return 0;
            }
            int col = this.getMappedColumnIndex(columnIndex);
            if (col == this.m_dataTypeColIndex) {
                return TypeUtilities.mapDataTypes(super.getInt(col));
            }
            return super.getInt(col);
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return 0L;
            }
            int col = this.getMappedColumnIndex(columnIndex);
            if (col == this.m_dataTypeColIndex) {
                return TypeUtilities.mapDataTypes(super.getInt(col));
            }
            return super.getLong(col);
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    protected void generateMetadataList() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            List<ColumnMetadata> metadataList = null;
            switch (this.m_metadataType) {
                case ATTRIBUTES: {
                    metadataList = MetaDataFactory.createAttributeMetaData();
                    break;
                }
                case CATALOG_ONLY: {
                    metadataList = MetaDataFactory.createCatalogOnlyMetaData();
                    break;
                }
                case COLUMN_PRIVILEGES: {
                    metadataList = MetaDataFactory.createColumnPrivilegesMetaData();
                    break;
                }
                case COLUMNS: {
                    metadataList = MetaDataFactory.createColumnsMetaData(this.m_jdbcVersion);
                    break;
                }
                case FOREIGN_KEYS: {
                    metadataList = MetaDataFactory.createForeignKeysMetaData();
                    break;
                }
                case FUNCTION_COLUMNS_JDBC4: {
                    metadataList = MetaDataFactory.createFunctionColumnsMetaData();
                    break;
                }
                case FUNCTIONS_JDBC4: {
                    metadataList = MetaDataFactory.createFunctionsMetaData();
                    break;
                }
                case STATISTICS: {
                    metadataList = MetaDataFactory.createIndexInfoMetaData();
                    break;
                }
                case PRIMARY_KEYS: {
                    metadataList = MetaDataFactory.createPrimaryKeysMetaData();
                    break;
                }
                case PROCEDURE_COLUMNS: {
                    metadataList = MetaDataFactory.createProcedureColumnsMetaData(this.m_jdbcVersion);
                    break;
                }
                case PROCEDURES: {
                    metadataList = MetaDataFactory.createProceduresMetaData(this.m_jdbcVersion);
                    break;
                }
                case PSEUDO_COLUMNS_JDBC41: {
                    if (JDBCVersion.JDBC4 == this.m_jdbcVersion) {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_METADATA_TYPE, this.m_warningListener, ExceptionType.DATA, String.valueOf((Object)this.m_metadataType));
                    }
                    metadataList = MetaDataFactory.createPseudoColumnsMetaData();
                    break;
                }
                case SCHEMA_ONLY: 
                case CATALOG_SCHEMA_ONLY: {
                    metadataList = MetaDataFactory.createSchemasOnlyMetaData();
                    break;
                }
                case SPECIAL_COLUMNS: {
                    metadataList = MetaDataFactory.createSpecialColumnsMetaData();
                    break;
                }
                case SUPERTABLES: {
                    metadataList = MetaDataFactory.createSuperTablesMetaData();
                    break;
                }
                case SUPERTYPES: {
                    metadataList = MetaDataFactory.createSuperTypesMetaData();
                    break;
                }
                case TABLE_PRIVILEGES: {
                    metadataList = MetaDataFactory.createTablePrivilegesMetaData();
                    break;
                }
                case TABLETYPE_ONLY: {
                    metadataList = MetaDataFactory.createTableTypesMetaData();
                    break;
                }
                case TABLES: {
                    metadataList = MetaDataFactory.createTablesMetaData();
                    break;
                }
                case TYPE_INFO: {
                    metadataList = MetaDataFactory.createTypeInfoMetaData();
                    break;
                }
                case UDT: {
                    metadataList = MetaDataFactory.createUDTMetaData();
                    break;
                }
                default: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_METADATA_TYPE, this.m_warningListener, ExceptionType.DATA, String.valueOf((Object)this.m_metadataType));
                }
            }
            this.m_resultSetColumns = metadataList;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            int mappedIndex = this.getMappedColumnIndex(columnIndex);
            if (mappedIndex == this.m_dataTypeColIndex) {
                return TypeUtilities.mapDataTypes(super.getInt(mappedIndex));
            }
            DataWrapper data = this.getData(mappedIndex, -1L);
            try {
                IColumn col = (IColumn)this.m_resultSetColumns.get(columnIndex - 1);
                Object value = TypeConverter.toObject(data, col.getTypeMetadata(), this.m_warningListener);
                this.m_wasLastValueNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(2000));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, map);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getObject(this.getMappedColumnIndex(columnIndex), map);
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getRef(this.getMappedColumnIndex(columnIndex));
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return 0;
            }
            int col = this.getMappedColumnIndex(columnIndex);
            if (col == this.m_dataTypeColIndex) {
                return (short)TypeUtilities.mapDataTypes(super.getInt(col));
            }
            return super.getShort(col);
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            int mappedIndex = this.getMappedColumnIndex(columnIndex);
            if (mappedIndex == this.m_dataTypeColIndex) {
                return String.valueOf(TypeUtilities.mapDataTypes(super.getInt(mappedIndex)));
            }
            DataWrapper data = this.getData(mappedIndex, -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                IColumn col = (IColumn)this.m_resultSetColumns.get(columnIndex - 1);
                return TypeConverter.toString(data, col.getTypeMetadata());
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(2000));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            DataWrapper data = this.getData(this.getMappedColumnIndex(columnIndex), -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                IColumn col = (IColumn)this.m_resultSetColumns.get(columnIndex - 1);
                return TypeConverter.toTime(data, col.getTypeMetadata(), this.m_warningListener);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(92));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            DataWrapper data = this.getData(this.getMappedColumnIndex(columnIndex), -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                IColumn col = (IColumn)this.m_resultSetColumns.get(columnIndex - 1);
                return TypeConverter.toTimestamp(data, col.getTypeMetadata(), this.m_warningListener);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(93));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getUnicodeStream(this.getMappedColumnIndex(columnIndex));
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
        try {
            if (this.shouldReturnNull(columnIndex)) {
                this.m_wasLastValueNull = true;
                return null;
            }
            return super.getURL(this.getMappedColumnIndex(columnIndex));
        }
        catch (SQLException e) {
            LogUtilities.logError(e, this.m_logger);
            throw e;
        }
    }

    @Override
    public synchronized void checkIfOpen() throws SQLException {
        if (!this.m_isOpen) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.RESULTSET_CLOSED, this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        if (null == this.m_parentMetaData) {
            this.close();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARENT_CLOSED, this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
    }

    @Override
    public void checkIfValidColumnNumber(int columnIndex) throws SQLException {
        for (int i = 0; i < this.m_columnMap.length; ++i) {
            if (this.m_columnMap[i] != columnIndex) continue;
            return;
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_INDEX, this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(columnIndex));
    }

    @Override
    public boolean isClosed() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return !this.m_isOpen;
    }

    private int getMappedColumnIndex(int columnIndex) throws SQLException {
        if (null == this.m_columnMap) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NULL_METADATA_COLUMNMAP, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        try {
            return this.m_columnMap[columnIndex - 1];
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_INDEX, this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(columnIndex));
        }
    }

    private void initializeColumnMap(MetadataSourceID metadataType) {
        int i;
        switch (metadataType) {
            case CATALOG_ONLY: {
                this.m_columnMap = new int[1];
                this.m_columnMap[0] = 1;
                break;
            }
            case SCHEMA_ONLY: 
            case CATALOG_SCHEMA_ONLY: {
                this.m_columnMap = new int[2];
                this.m_columnMap[0] = 2;
                this.m_columnMap[1] = 1;
                break;
            }
            case TABLETYPE_ONLY: {
                this.m_columnMap = new int[1];
                this.m_columnMap[0] = 4;
                break;
            }
            case COLUMN_PRIVILEGES: {
                this.m_columnMap = new int[8];
                break;
            }
            case COLUMNS: {
                if (JDBCVersion.JDBC4 == this.m_jdbcVersion) {
                    this.m_columnMap = new int[23];
                    break;
                }
                this.m_columnMap = new int[24];
                break;
            }
            case FOREIGN_KEYS: {
                this.m_columnMap = new int[14];
                break;
            }
            case FUNCTION_COLUMNS_JDBC4: {
                this.m_columnMap = new int[17];
                break;
            }
            case PSEUDO_COLUMNS_JDBC41: {
                if (JDBCVersion.JDBC41 == this.m_jdbcVersion || JDBCVersion.JDBC42 == this.m_jdbcVersion) {
                    this.m_columnMap = new int[12];
                    break;
                }
                return;
            }
            case FUNCTIONS_JDBC4: {
                this.m_columnMap = new int[6];
                break;
            }
            case STATISTICS: {
                this.m_columnMap = new int[13];
                break;
            }
            case PRIMARY_KEYS: {
                this.m_columnMap = new int[6];
                break;
            }
            case PROCEDURE_COLUMNS: {
                this.m_columnMap = new int[20];
                break;
            }
            case PROCEDURES: {
                this.m_columnMap = new int[9];
                break;
            }
            case SPECIAL_COLUMNS: {
                this.m_columnMap = new int[8];
                break;
            }
            case SUPERTABLES: {
                this.m_columnMap = new int[4];
                break;
            }
            case SUPERTYPES: {
                this.m_columnMap = new int[6];
                break;
            }
            case TABLE_PRIVILEGES: {
                this.m_columnMap = new int[7];
                break;
            }
            case TABLES: {
                this.m_columnMap = new int[10];
                break;
            }
            case TYPE_INFO: {
                this.m_columnMap = new int[18];
                break;
            }
            case UDT: {
                this.m_columnMap = new int[7];
                break;
            }
            case ATTRIBUTES: {
                this.m_columnMap = new int[21];
                break;
            }
            default: {
                return;
            }
        }
        if (MetadataSourceID.CATALOG_ONLY != this.m_metadataType && MetadataSourceID.CATALOG_SCHEMA_ONLY != this.m_metadataType && MetadataSourceID.SCHEMA_ONLY != this.m_metadataType && MetadataSourceID.TABLETYPE_ONLY != this.m_metadataType) {
            for (i = 0; i < this.m_columnMap.length; ++i) {
                this.m_columnMap[i] = i + 1;
            }
        }
        if (MetadataSourceID.COLUMNS == this.m_metadataType) {
            for (i = 18; i < 22; ++i) {
                this.m_columnMap[i] = i + 2;
            }
            this.m_columnMap[22] = 19;
            if (JDBCVersion.JDBC41 == this.m_jdbcVersion || JDBCVersion.JDBC42 == this.m_jdbcVersion) {
                this.m_columnMap[23] = 21;
            }
        }
    }

    private void initializeDataTypeColIndex(MetadataSourceID metadataType) {
        switch (metadataType) {
            case ATTRIBUTES: 
            case COLUMNS: 
            case UDT: {
                this.m_dataTypeColIndex = 5;
                break;
            }
            case SPECIAL_COLUMNS: {
                this.m_dataTypeColIndex = 3;
                break;
            }
            case PROCEDURE_COLUMNS: {
                this.m_dataTypeColIndex = 6;
                break;
            }
            case TYPE_INFO: {
                this.m_dataTypeColIndex = 2;
                break;
            }
        }
    }

    private boolean shouldReturnNull(int columnIndex) {
        boolean shouldReturnNull = false;
        if (MetadataSourceID.COLUMNS.equals((Object)this.m_metadataType)) {
            shouldReturnNull = 18 < columnIndex && 23 > columnIndex;
        } else if (MetadataSourceID.TABLES.equals((Object)this.m_metadataType)) {
            shouldReturnNull = 5 < columnIndex && 11 > columnIndex;
        } else if (MetadataSourceID.ATTRIBUTES.equals((Object)this.m_metadataType) || MetadataSourceID.SUPERTABLES.equals((Object)this.m_metadataType) || MetadataSourceID.SUPERTYPES.equals((Object)this.m_metadataType) || MetadataSourceID.UDT.equals((Object)this.m_metadataType)) {
            shouldReturnNull = true;
        }
        return shouldReturnNull;
    }

    @Override
    protected final IConnection getParentConnection() throws SQLException {
        return ((SConnection)this.m_parentMetaData.getConnection()).getConnection();
    }
}

