/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VConnection;
import com.vertica.core.VDriver;
import com.vertica.core.VStatement;
import com.vertica.dataengine.VQueryExecutor;
import com.vertica.dsi.dataengine.interfaces.IQueryExecutor;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SStatement;
import com.vertica.localization.VMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.FeatureNotSupportedException;
import java.sql.SQLException;

final class VerticaStatementSharedImpl {
    private static final VerticaStatementSharedImpl m_instance = new VerticaStatementSharedImpl();

    VerticaStatementSharedImpl() {
    }

    static VerticaStatementSharedImpl getInstance() {
        return m_instance;
    }

    public FeatureNotSupportedException validateClearBatch(VConnection vConnection, IQueryExecutor iQueryExecutor) {
        FeatureNotSupportedException featureNotSupportedException = null;
        if (vConnection.getStreamingBatchInsert() && !((VQueryExecutor)iQueryExecutor).getIsPreparedExecuteBatch()) {
            String[] stringArray = new String[]{};
            featureNotSupportedException = new FeatureNotSupportedException(DiagState.DIAG_FUNC_SQNCE_ERR, 101, VMessageKey.ERROR_CLEAR_BATCH_NOT_SUPPORTED.toString(), stringArray);
        }
        return featureNotSupportedException;
    }

    public FeatureNotSupportedException noAutoGenSupport() {
        FeatureNotSupportedException featureNotSupportedException = null;
        String[] stringArray = new String[]{};
        featureNotSupportedException = new FeatureNotSupportedException(DiagState.DIAG_OPTL_FEAT_NOT_IMPLD, 101, VMessageKey.ERROR_FEATURE_NOT_SUPPORTED.toString(), stringArray);
        return featureNotSupportedException;
    }

    public void cancel(SStatement sStatement, IWarningListener iWarningListener, ILogger iLogger) throws SQLException {
        try {
            SConnection sConnection = sStatement.getParentConnection();
            if (sConnection != null) {
                VConnection vConnection = (VConnection)sConnection.getDSIConnection();
                vConnection.cancelCurrentStatement((VStatement)sStatement.getStatement());
            }
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, iWarningListener, iLogger);
        }
    }

    public void setNull(ParameterMetadata parameterMetadata, int n, IWarningListener iWarningListener) throws SQLException {
        if (Nullable.NULLABLE != parameterMetadata.getNullable()) {
            throw ExceptionConverter.getInstance().toSQLException(VDriver.s_vExceptionBuilder.createCustomException("HY099", VMessageKey.ERROR_PARAM_NOT_NULLABLE.toString(), String.valueOf(n)), iWarningListener);
        }
    }
}

