/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.core.AddressList;
import com.vertica.core.VConnection;
import com.vertica.core.VDriver;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.BadAuthException;
import com.vertica.dsi.exceptions.UtilsException;
import com.vertica.io.AuthCryptResponseMessage;
import com.vertica.io.AuthGSSContinueResponseMessage;
import com.vertica.io.AuthGSSResponseMessage;
import com.vertica.io.AuthHashResponseMessage;
import com.vertica.io.AuthK5ResponseMessage;
import com.vertica.io.AuthOkResponseMessage;
import com.vertica.io.AuthPasswordChangedResponseMessage;
import com.vertica.io.AuthPasswordExpiredResponseMessage;
import com.vertica.io.AuthPasswordGraceResponseMessage;
import com.vertica.io.AuthPasswordResponseMessage;
import com.vertica.io.AuthSCMResponseMessage;
import com.vertica.io.BindCompleteResponseMessage;
import com.vertica.io.CancelRequestMessage;
import com.vertica.io.CloseCompleteResponseMessage;
import com.vertica.io.CommandCompleteResponseMessage;
import com.vertica.io.CommandDescriptionResponseMessage;
import com.vertica.io.CopyDataResponseMessage;
import com.vertica.io.CopyDoneResponseMessage;
import com.vertica.io.CopyInResponseMessage;
import com.vertica.io.DataRowResponseMessage;
import com.vertica.io.EmptyQueryResponseMessage;
import com.vertica.io.EndOfBatchResponseMessage;
import com.vertica.io.ErrorResponseMessage;
import com.vertica.io.KeyDataResponseMessage;
import com.vertica.io.LoadBalanceRequestMessage;
import com.vertica.io.LoadBalanceResponseMessage;
import com.vertica.io.LoadFileResponseMessage;
import com.vertica.io.MarsResponseMessage;
import com.vertica.io.MessageType;
import com.vertica.io.NoDataResponseMessage;
import com.vertica.io.NoticeResponseMessage;
import com.vertica.io.NotificationResponseMessage;
import com.vertica.io.ParameterDescriptionResponseMessage;
import com.vertica.io.ParameterStatusResponseMessage;
import com.vertica.io.ParseCompleteResponseMessage;
import com.vertica.io.PasswordRequestMessage;
import com.vertica.io.PortalSuspendedResponseMessage;
import com.vertica.io.ReadyForQueryResponseMessage;
import com.vertica.io.RequestMessage;
import com.vertica.io.ResponseMessage;
import com.vertica.io.RowDescriptionResponseMessage;
import com.vertica.io.SSLRequestMessage;
import com.vertica.io.StartupRequestMessage;
import com.vertica.io.SyncRequestMessage;
import com.vertica.io.VStream;
import com.vertica.io.VerifyFilesResponseMessage;
import com.vertica.io.WriteFileResponseMessage;
import com.vertica.localization.VMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Warning;
import com.vertica.support.WarningCode;
import com.vertica.support.exceptions.ClientInfoException;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.InvalidAuthorizationException;
import com.vertica.support.exceptions.NonTransientConnectionException;
import com.vertica.support.exceptions.RecoverableException;
import com.vertica.util.ClientErrorException;
import com.vertica.util.ProtocolUtils;
import com.vertica.util.ServerErrorData;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.LinkedList;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class ProtocolStream {
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    private static final int AUTH_REQ_GSS = 7;
    private static final int AUTH_REQ_GSS_CONT = 8;
    private static final int AUTH_REQ_CHANGE_PASSWORD = 9;
    private static final int AUTH_REQ_PASSWORD_CHANGED = 10;
    private static final int AUTH_REQ_PASSWORD_GRACE = 11;
    private static final int AUTH_REQ_HASH = 65536;
    private static final int AUTH_REQ_HASH_MD5 = 65541;
    private static final int AUTH_REQ_HASH_SHA512 = 66048;
    private VConnection m_connection;
    private VStream m_vStream;
    private DSILogger m_log;
    private LinkedList<ResponseMessage> m_incomingQueue;
    private boolean m_isClosed = true;
    private boolean m_hasOutgoingMessage;
    private boolean m_initComplete;
    private int m_cancelKey;
    private int m_serverProcId;
    private String m_password;
    private IWarningListener m_currentWarningListener;
    private ResponseMessage m_curResponse = null;

    public ProtocolStream(VConnection vConnection) throws ErrorException {
        this.m_connection = vConnection;
        this.m_log = vConnection.getConnectionLog();
        this.m_incomingQueue = new LinkedList();
        int n = vConnection.getFixedProtocolVersion();
        try {
            this.m_vStream = new VStream(this.m_connection);
            this.m_isClosed = false;
        }
        catch (IOException iOException) {
            LogUtilities.logError(iOException, (ILogger)this.m_log);
            throw new NonTransientConnectionException(DiagState.DIAG_CONN_DOES_NOT_EXIST, 101, VMessageKey.ERROR_CONNECTION_FAILED.toString(), new String[]{vConnection.getServer(), vConnection.getPort() + "", iOException.getLocalizedMessage()}, (Throwable)iOException);
        }
    }

    public void initSession(String string) throws BadAuthException, ErrorException, IOException {
        this.m_password = string;
        boolean bl = false;
        while (!bl) {
            try {
                if (this.m_connection.getConnectionLoadBalance()) {
                    this.loadBalance();
                }
                if (this.m_connection.getTLSMode().requireEncryption()) {
                    this.enableTLS();
                }
                this.m_vStream.setupSocketBuffers();
                this.startup();
                this.authenticate();
                this.readStartupMessages();
                bl = true;
            }
            catch (InvalidAuthorizationException invalidAuthorizationException) {
                throw invalidAuthorizationException;
            }
            catch (BadAuthException badAuthException) {
                throw badAuthException;
            }
            catch (ErrorException errorException) {
                AddressList addressList = this.m_connection.getAddressList();
                addressList.reportSessionFailure();
                try {
                    this.m_vStream.establishConnection(addressList);
                }
                catch (IOException iOException) {
                    throw errorException;
                }
            }
        }
    }

    public void enableTLS() throws BadAuthException, ErrorException {
        try {
            this.sendMessage(new SSLRequestMessage());
            this.m_vStream.flush();
            int n = this.m_vStream.ReceiveChar();
            switch (n) {
                case 83: {
                    this.m_vStream.switchToTLS();
                    break;
                }
                default: {
                    throw new BadAuthException(101, VMessageKey.ERROR_SSL_STARTUP_FAILED.toString(), "");
                }
            }
        }
        catch (IOException iOException) {
            throw this.logAndConvertToNetworkException(iOException);
        }
    }

    private void loadBalance() throws IOException, ErrorException {
        LoadBalanceRequestMessage loadBalanceRequestMessage = new LoadBalanceRequestMessage();
        loadBalanceRequestMessage.send(this.m_vStream);
        this.m_vStream.flush();
        int n = this.m_vStream.ReceiveChar();
        if (n == 89) {
            int n2 = this.m_vStream.ReceiveIntegerR(4);
            LoadBalanceResponseMessage loadBalanceResponseMessage = new LoadBalanceResponseMessage(this.m_vStream);
            loadBalanceResponseMessage.buildMessage(n2 - 4);
            LogUtilities.logInfo("Load balancing to " + loadBalanceResponseMessage.getHost() + ":" + loadBalanceResponseMessage.getPort() + ".", (ILogger)this.m_connection.getConnectionLog());
            try {
                this.m_vStream.close();
                this.m_vStream = null;
            }
            catch (IOException iOException) {
                LogUtilities.logWarning("Error closing connection to " + this.m_connection.getHost() + ":" + this.m_connection.getPort() + " during load balance operation: " + iOException.getLocalizedMessage(), (ILogger)this.m_connection.getConnectionLog());
            }
            this.m_connection.setHost(loadBalanceResponseMessage.getHost());
            this.m_connection.setPort(loadBalanceResponseMessage.getPort());
            this.m_connection.getAddressList().add(this.m_connection.getHost(), null, this.m_connection.getPort());
            this.m_vStream = new VStream(this.m_connection);
        }
    }

    private void startup() throws ErrorException {
        int n = this.m_connection.getFixedProtocolVersion();
        String string = System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
        String string2 = System.getProperty("user.name");
        this.sendMessage(new StartupRequestMessage(n >= ProtocolUtils.protocolStrToInt("3.5") ? this.backwardCompatibilityParams(string, string2) : this.preBackwardCompatibilityParams(string, string2)));
    }

    private String[][] backwardCompatibilityParams(String string, String string2) {
        String[][] stringArray = new String[][]{{"user", this.m_connection.getUser()}, {"database", this.m_connection.getDatabaseName()}, {"client_encoding", "UNICODE"}, {"DateStyle", "ISO"}, {"client_pid", this.getProcessId().toString()}, {"client_label", this.m_connection.getSessionLabel()}, {"client_type", "JDBC Driver"}, {"client_version", VDriver.DRIVER_VERSION}, {"client_os", string}, {"client_os_user_name", string2}, {"mars", this.m_connection.getMarsEnabled() ? "on" : "off"}, {"protocol_version", "3.9"}};
        return stringArray;
    }

    private String[][] preBackwardCompatibilityParams(String string, String string2) {
        String[][] stringArray = new String[][]{{"user", this.m_connection.getUser()}, {"database", this.m_connection.getDatabaseName()}, {"client_encoding", "UNICODE"}, {"DateStyle", "ISO"}, {"client_pid", this.getProcessId().toString()}, {"client_label", this.m_connection.getSessionLabel()}, {"client_type", "JDBC Driver"}, {"client_version", VDriver.DRIVER_VERSION}, {"client_os", string}, {"client_os_user_name", string2}, {"mars", this.m_connection.getMarsEnabled() ? "on" : "off"}};
        return stringArray;
    }

    private void authenticate() throws ErrorException {
        boolean bl = false;
        while (!bl) {
            ResponseMessage responseMessage = this.readMessage();
            switch (responseMessage.getType()) {
                case AuthCrypt: 
                case AuthSCM: {
                    String string = responseMessage.getType().toString();
                    LogUtilities.logError("Server has requested an unsupported authentication mechanism: " + string, (ILogger)this.m_log);
                    throw new NonTransientConnectionException(101, VMessageKey.ERROR_AUTH_FAILED_BAD_ALGO.toString(), new String[]{string});
                }
                case AuthK5: {
                    String string = responseMessage.getType().toString();
                    LogUtilities.logError("Server has requested non-GSSAPI kerberos authentication; : " + string, (ILogger)this.m_log);
                    throw new NonTransientConnectionException(101, VMessageKey.ERROR_AUTH_FAILED_KRB5.toString());
                }
                case AuthHash: {
                    boolean bl2 = ((AuthHashResponseMessage)responseMessage).useMD5();
                    Object object = ((AuthHashResponseMessage)responseMessage).getSalt();
                    Object object2 = ((AuthHashResponseMessage)responseMessage).getUserSalt();
                    LogUtilities.logInfo("Server has requested Hash authentication.", (ILogger)this.m_log);
                    if (bl2) {
                        this.sendMessage(new PasswordRequestMessage(this.m_connection.getUser(), this.m_password, (byte[])object));
                        break;
                    }
                    this.sendMessage(new PasswordRequestMessage((byte[])object2, this.m_password, (byte[])object));
                    break;
                }
                case AuthPassword: {
                    LogUtilities.logInfo("Server has requested password authentication.", (ILogger)this.m_log);
                    this.sendMessage(new PasswordRequestMessage(this.m_password));
                    break;
                }
                case AuthPasswordExpired: {
                    LogUtilities.logError("The password for " + this.m_connection.getUser() + " has expired.", (ILogger)this.m_log);
                    this.close();
                    throw new BadAuthException(101, VMessageKey.ERROR_AUTH_FAILED_PW_EXPIRED.toString(), "");
                }
                case AuthGSS: {
                    LogUtilities.logInfo("Server has requested GSS authentication.", (ILogger)this.m_log);
                    this.doGSSAuthentication();
                    break;
                }
                case AuthGSSContinue: {
                    LogUtilities.logError("Server has requested GSS continuation before GSS initialization.", (ILogger)this.m_log);
                    throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.PROTOCOL_ERROR_UNEXPECTED_TYPE.toString(), responseMessage.getType().toString());
                }
                case AuthPasswordGrace: {
                    String string = this.m_connection.getMessageSource().loadMessage(this.m_connection.getLocale(), 101, VMessageKey.WARNING_PW_EXPIRING.toString(), this.m_connection.getUser(), false);
                    LogUtilities.logWarning(string, (ILogger)this.m_log);
                    Object object = new Warning(WarningCode.GENERAL_WARNING, string);
                    Object object2 = this.m_connection.getWarningListener();
                    object2.postWarning((Warning)object);
                    break;
                }
                case AuthOk: {
                    LogUtilities.logInfo("User " + this.m_connection.getUser() + " successfully authenticated.", (ILogger)this.m_log);
                    bl = true;
                    break;
                }
                case Error: {
                    throw ((ErrorResponseMessage)responseMessage).getErrorData().buildException();
                }
            }
        }
    }

    private void doGSSAuthentication() throws ErrorException {
        try {
            CallbackHandler callbackHandler = this.makeJAASLoginHandler();
            LoginContext loginContext = new LoginContext(this.m_connection.getJAASConfigName(), callbackHandler);
            loginContext.login();
            try {
                Subject subject = loginContext.getSubject();
                PrivilegedExceptionAction<Object> privilegedExceptionAction = this.makeGSSAuthentication();
                Subject.doAs(subject, privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ErrorException) {
                    throw (ErrorException)exception;
                }
                LogUtilities.logError(exception, (ILogger)this.m_log);
                InvalidAuthorizationException invalidAuthorizationException = new InvalidAuthorizationException(DiagState.DIAG_INVALID_AUTH_SPEC, 101, VMessageKey.ERROR_AUTH_FAILED_GSS.toString(), new String[]{exception.getLocalizedMessage()}, (Throwable)exception);
                throw invalidAuthorizationException;
            }
            finally {
                loginContext.logout();
            }
        }
        catch (SecurityException securityException) {
            LogUtilities.logError(securityException, (ILogger)this.m_log);
            InvalidAuthorizationException invalidAuthorizationException = new InvalidAuthorizationException(DiagState.DIAG_INVALID_AUTH_SPEC, 101, VMessageKey.ERROR_AUTH_FAILED_TO_READ_JAAS_CONFIG.toString(), new String[]{this.m_connection.getJAASConfigName(), securityException.getLocalizedMessage()}, (Throwable)securityException);
            throw invalidAuthorizationException;
        }
        catch (LoginException loginException) {
            LogUtilities.logError(loginException, (ILogger)this.m_log);
            InvalidAuthorizationException invalidAuthorizationException = new InvalidAuthorizationException(DiagState.DIAG_INVALID_AUTH_SPEC, 101, VMessageKey.ERROR_AUTH_FAILED_JAAS.toString(), new String[]{this.m_connection.getJAASConfigName(), loginException.getLocalizedMessage()}, (Throwable)loginException);
            throw invalidAuthorizationException;
        }
    }

    private CallbackHandler makeJAASLoginHandler() {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbackArray) {
                    Callback callback2;
                    boolean bl = false;
                    if (callback instanceof NameCallback) {
                        bl = true;
                        LogUtilities.logInfo("Providing username for JAAS NameCallback", (ILogger)ProtocolStream.this.m_log);
                        callback2 = (NameCallback)callback;
                        LogUtilities.logDebug("NameCallback Prompt: " + ((NameCallback)callback2).getPrompt(), (ILogger)ProtocolStream.this.m_log);
                        ((NameCallback)callback2).setName(ProtocolStream.this.m_connection.getUser());
                    }
                    if (callback instanceof PasswordCallback) {
                        bl = true;
                        LogUtilities.logInfo("Providing password for JAAS PasswordCallback", (ILogger)ProtocolStream.this.m_log);
                        callback2 = (PasswordCallback)callback;
                        LogUtilities.logDebug("PasswordCallback Prompt: " + ((PasswordCallback)callback2).getPrompt(), (ILogger)ProtocolStream.this.m_log);
                        ((PasswordCallback)callback2).setPassword(ProtocolStream.this.m_password.toCharArray());
                    }
                    if (callback instanceof TextOutputCallback) {
                        bl = true;
                        callback2 = (TextOutputCallback)callback;
                        switch (((TextOutputCallback)callback2).getMessageType()) {
                            case 2: {
                                LogUtilities.logError("JAAS TextOutputCallback Error message: " + ((TextOutputCallback)callback2).getMessage(), (ILogger)ProtocolStream.this.m_log);
                                break;
                            }
                            case 1: {
                                LogUtilities.logWarning("JAAS TextOutputCallback Warning message: " + ((TextOutputCallback)callback2).getMessage(), (ILogger)ProtocolStream.this.m_log);
                                break;
                            }
                            default: {
                                LogUtilities.logInfo("JAAS TextOutputCallback message: " + ((TextOutputCallback)callback2).getMessage(), (ILogger)ProtocolStream.this.m_log);
                            }
                        }
                    }
                    if (bl) continue;
                    LogUtilities.logError("Unsupported Callback: " + callback, (ILogger)ProtocolStream.this.m_log);
                    throw new UnsupportedCallbackException(callback);
                }
            }
        };
    }

    private PrivilegedExceptionAction<Object> makeGSSAuthentication() {
        return new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws GSSException, ErrorException {
                GSSManager gSSManager = GSSManager.getInstance();
                Oid oid = new Oid("1.2.840.113554.1.2.2");
                GSSCredential gSSCredential = null;
                GSSContext gSSContext = null;
                try {
                    AuthGSSContinueResponseMessage authGSSContinueResponseMessage;
                    GSSName gSSName = gSSManager.createName(ProtocolStream.this.m_connection.getKerberosServiceName() + "@" + ProtocolStream.this.m_connection.getKerberosHostName().toLowerCase(), GSSName.NT_HOSTBASED_SERVICE);
                    gSSCredential = gSSManager.createCredential(null, 0, oid, 1);
                    gSSContext = gSSManager.createContext(gSSName, oid, gSSCredential, 0);
                    gSSContext.requestMutualAuth(true);
                    gSSContext.requestCredDeleg(true);
                    byte[] byArray = new byte[]{};
                    while (!gSSContext.isEstablished()) {
                        if ((byArray = gSSContext.initSecContext(byArray, 0, byArray.length)) == null) continue;
                        ProtocolStream.this.sendMessage(new PasswordRequestMessage(byArray));
                        authGSSContinueResponseMessage = (AuthGSSContinueResponseMessage)ProtocolStream.this.readExpectedMessage(MessageType.AuthGSSContinue);
                        byArray = authGSSContinueResponseMessage.getGSSData();
                    }
                    if (!gSSContext.getCredDelegState()) {
                        LogUtilities.logInfo("Kerberos authentication succeeded but the client's TGT wasn't forwardable. Delegated access to downstream systems will fail if kerberos is required.", (ILogger)ProtocolStream.this.m_log);
                    }
                    authGSSContinueResponseMessage = null;
                    return authGSSContinueResponseMessage;
                }
                finally {
                    if (gSSCredential != null) {
                        gSSCredential.dispose();
                    }
                    if (gSSContext != null) {
                        gSSContext.dispose();
                    }
                }
            }
        };
    }

    private void readStartupMessages() throws ErrorException {
        Object object;
        ResponseMessage responseMessage;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        block5: while (true) {
            responseMessage = this.readMessage();
            switch (responseMessage.getType()) {
                case ReadyForQuery: {
                    char c = ((ReadyForQueryResponseMessage)responseMessage).getTxnState();
                    this.m_connection.setServerTxnState(c, false, false);
                    return;
                }
                case KeyData: {
                    object = (KeyDataResponseMessage)responseMessage;
                    this.m_cancelKey = ((KeyDataResponseMessage)object).getKey();
                    this.m_serverProcId = ((KeyDataResponseMessage)object).getServerProcessId();
                    continue block5;
                }
                case Error: {
                    object = (ErrorResponseMessage)responseMessage;
                    throw ((ErrorResponseMessage)object).getErrorData().buildException();
                }
            }
            break;
        }
        object = responseMessage.getType();
        throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.PROTOCOL_ERROR_UNEXPECTED_TYPE.toString(), object == null ? "null" : ((Enum)object).toString());
    }

    private Integer getProcessId() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.charAt(i))) {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (stringBuffer.length() > 0) break;
        }
        try {
            return Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void cancelCurrentStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        ProtocolStream protocolStream = new ProtocolStream(this.m_connection);
        protocolStream.sendMessage(new CancelRequestMessage(this.m_serverProcId, this.m_cancelKey));
        protocolStream.flush();
        protocolStream.close();
    }

    private int peekNextMessageType() throws IOException {
        return this.m_vStream.peekNextChar();
    }

    private WriteFileResponseMessage receiveWriteFileResponseMessage() throws IOException, ClientErrorException {
        if (this.peekNextMessageType() != 79) {
            return null;
        }
        this.m_vStream.ReceiveChar();
        int n = this.m_vStream.ReceiveIntegerR(4);
        WriteFileResponseMessage writeFileResponseMessage = new WriteFileResponseMessage(this.m_vStream, this.m_connection.getConnectionLog());
        writeFileResponseMessage.buildMessage(n - 4);
        writeFileResponseMessage.m_length = n;
        return writeFileResponseMessage;
    }

    public void sendMessage(RequestMessage requestMessage) throws ErrorException {
        this.ensureOpen();
        try {
            if (this.m_log.isEnabled() && !requestMessage.getType().equals((Object)MessageType.ClientCopyData)) {
                LogUtilities.logDebug("FE => " + Arrays.toString(requestMessage.getDebugInfo()), (ILogger)this.m_log);
            }
            requestMessage.send(this.m_vStream);
            this.m_hasOutgoingMessage = true;
        }
        catch (IOException iOException) {
            throw this.logAndConvertToNetworkException(iOException);
        }
    }

    public void putBack(ResponseMessage responseMessage) {
        this.m_incomingQueue.addFirst(responseMessage);
    }

    public void add(ResponseMessage responseMessage) {
        this.m_incomingQueue.add(responseMessage);
    }

    public boolean hasQueuedMessage() {
        return !this.m_incomingQueue.isEmpty();
    }

    public ResponseMessage resetProtocolState(String string, boolean bl) throws ErrorException {
        if (string == null) {
            string = "";
        }
        if (bl) {
            this.sendMessage(new SyncRequestMessage(string));
            this.flush();
        }
        return this.skipUntilReady();
    }

    public ResponseMessage skipUntilReady() throws ErrorException {
        ResponseMessage responseMessage = null;
        do {
            if (!(responseMessage = this.readMessage()).getType().equals((Object)MessageType.WriteFile)) continue;
            try {
                WriteFileResponseMessage writeFileResponseMessage = (WriteFileResponseMessage)responseMessage;
                writeFileResponseMessage.skipFileContent();
            }
            catch (IOException iOException) {
                throw this.logAndConvertToNetworkException(iOException);
            }
        } while (!responseMessage.getType().equals((Object)MessageType.ReadyForQuery));
        return responseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage readMessage() throws ErrorException {
        this.ensureOpen();
        try {
            if (this.m_hasOutgoingMessage) {
                this.m_vStream.flush();
                this.m_hasOutgoingMessage = false;
            }
            ResponseMessage responseMessage = null;
            LinkedList<ResponseMessage> linkedList = this.m_incomingQueue;
            synchronized (linkedList) {
                responseMessage = this.m_incomingQueue.poll();
            }
            if (responseMessage != null) {
                this.m_curResponse = responseMessage;
                return this.m_curResponse;
            }
            if (this.m_curResponse != null && this.m_curResponse.getType() == MessageType.DataRow) {
                ((DataRowResponseMessage)this.m_curResponse).finishReadRow();
            }
            this.m_curResponse = this.receiveOneResponseMessage();
            return this.m_curResponse;
        }
        catch (IOException iOException) {
            throw this.logAndConvertToNetworkException(iOException);
        }
    }

    private synchronized ResponseMessage receiveOneResponseMessage() throws ErrorException, IOException {
        ResponseMessage responseMessage;
        do {
            int n = this.m_vStream.ReceiveChar();
            int n2 = this.m_vStream.ReceiveIntegerR(4);
            responseMessage = null;
            block0 : switch (n) {
                case 49: {
                    responseMessage = new ParseCompleteResponseMessage(this.m_vStream);
                    break;
                }
                case 50: {
                    responseMessage = new BindCompleteResponseMessage(this.m_vStream);
                    break;
                }
                case 51: {
                    responseMessage = new CloseCompleteResponseMessage(this.m_vStream);
                    break;
                }
                case 95: {
                    responseMessage = new MarsResponseMessage(this.m_vStream);
                    break;
                }
                case 65: {
                    responseMessage = new NotificationResponseMessage(this.m_vStream);
                    break;
                }
                case 99: {
                    responseMessage = new CopyDoneResponseMessage(this.m_vStream);
                    break;
                }
                case 67: {
                    responseMessage = new CommandCompleteResponseMessage(this.m_vStream);
                    break;
                }
                case 109: {
                    responseMessage = new CommandDescriptionResponseMessage(this.m_vStream);
                    break;
                }
                case 100: {
                    responseMessage = new CopyDataResponseMessage(this.m_vStream);
                    break;
                }
                case 68: {
                    responseMessage = new DataRowResponseMessage(this.m_vStream);
                    break;
                }
                case 69: {
                    responseMessage = new ErrorResponseMessage(this.m_connection, this.m_vStream, this.m_connection.getConnectionLog());
                    break;
                }
                case 70: {
                    responseMessage = new VerifyFilesResponseMessage(this.m_vStream);
                    break;
                }
                case 72: {
                    responseMessage = new LoadFileResponseMessage(this.m_vStream);
                    break;
                }
                case 71: {
                    responseMessage = new CopyInResponseMessage(this.m_vStream);
                    break;
                }
                case 73: {
                    responseMessage = new EmptyQueryResponseMessage(this.m_vStream);
                    break;
                }
                case 74: {
                    responseMessage = new EndOfBatchResponseMessage(this.m_vStream);
                    break;
                }
                case 75: {
                    responseMessage = new KeyDataResponseMessage(this.m_vStream);
                    break;
                }
                case 78: {
                    responseMessage = new NoticeResponseMessage(this.m_connection, this.m_vStream, this.m_connection.getConnectionLog());
                    break;
                }
                case 110: {
                    responseMessage = new NoDataResponseMessage(this.m_vStream);
                    break;
                }
                case 79: {
                    responseMessage = new WriteFileResponseMessage(this.m_vStream, this.m_connection.getConnectionLog());
                    break;
                }
                case 82: {
                    int n3 = this.m_vStream.ReceiveIntegerR(4);
                    n2 -= 4;
                    switch (n3) {
                        case 0: {
                            responseMessage = new AuthOkResponseMessage(this.m_vStream);
                            break block0;
                        }
                        case 1: 
                        case 2: {
                            responseMessage = new AuthK5ResponseMessage(this.m_vStream);
                            break block0;
                        }
                        case 3: {
                            responseMessage = new AuthPasswordResponseMessage(this.m_vStream);
                            break block0;
                        }
                        case 4: {
                            responseMessage = new AuthCryptResponseMessage(this.m_vStream);
                            break block0;
                        }
                        case 7: {
                            responseMessage = new AuthGSSResponseMessage(this.m_vStream);
                            break block0;
                        }
                        case 8: {
                            responseMessage = new AuthGSSContinueResponseMessage(this.m_vStream);
                            break block0;
                        }
                        case 5: 
                        case 65541: {
                            responseMessage = new AuthHashResponseMessage(this.m_vStream, true);
                            break block0;
                        }
                        case 65536: 
                        case 66048: {
                            responseMessage = new AuthHashResponseMessage(this.m_vStream, false);
                            break block0;
                        }
                        case 6: {
                            responseMessage = new AuthSCMResponseMessage(this.m_vStream);
                            break block0;
                        }
                        case 9: {
                            responseMessage = new AuthPasswordExpiredResponseMessage(this.m_vStream);
                            break block0;
                        }
                        case 10: {
                            responseMessage = new AuthPasswordChangedResponseMessage(this.m_vStream);
                            break block0;
                        }
                        case 11: {
                            responseMessage = new AuthPasswordGraceResponseMessage(this.m_vStream);
                            break block0;
                        }
                    }
                    LogUtilities.logError("Unsupported auth message subtype: " + (char)n3, (ILogger)this.m_log);
                    throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.PROTOCOL_ERROR_UNKNOWN_TYPE.toString(), (char)n + ":" + (char)n3);
                }
                case 115: {
                    responseMessage = new PortalSuspendedResponseMessage(this.m_vStream);
                    break;
                }
                case 83: {
                    responseMessage = new ParameterStatusResponseMessage(this.m_vStream);
                    break;
                }
                case 116: {
                    responseMessage = new ParameterDescriptionResponseMessage(this.m_vStream);
                    break;
                }
                case 84: {
                    responseMessage = new RowDescriptionResponseMessage(this.m_vStream);
                    break;
                }
                case 90: {
                    responseMessage = new ReadyForQueryResponseMessage(this.m_vStream);
                    break;
                }
                default: {
                    LogUtilities.logError("Unexpected message type:" + (char)n, (ILogger)this.m_log);
                    throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.PROTOCOL_ERROR_UNKNOWN_TYPE.toString(), (char)n + "");
                }
            }
            responseMessage.buildMessage(n2 - 4);
            responseMessage.m_length = n2;
            if (n == 82) {
                responseMessage.m_length += 4;
            }
            if (this.m_log.isEnabled() && n != 68) {
                LogUtilities.logDebug("BE <= " + Arrays.toString(responseMessage.getDebugInfo()), (ILogger)this.m_log);
            }
            switch (responseMessage.getType()) {
                case ParameterStatus: {
                    this.handleParameterStatus((ParameterStatusResponseMessage)responseMessage);
                    break;
                }
                case Notice: {
                    this.handleNotice((NoticeResponseMessage)responseMessage);
                    break;
                }
                case Error: {
                    this.m_connection.setCurrentServerErrorData(((ErrorResponseMessage)responseMessage).getErrorData());
                }
            }
        } while (this.isAsynchronousMessage(responseMessage));
        return responseMessage;
    }

    private boolean isAsynchronousMessage(ResponseMessage responseMessage) {
        return responseMessage.getType() == MessageType.ParameterStatus || responseMessage.getType() == MessageType.Notice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int expediteWriteFileMessage() throws ErrorException {
        block10: {
            if (this.m_vStream == null || this.m_vStream.available() == 0) {
                return 0;
            }
            try {
                int n = this.peekNextMessageType();
                if (n != 79) {
                    return -1;
                }
                WriteFileResponseMessage writeFileResponseMessage = this.receiveWriteFileResponseMessage();
                if (writeFileResponseMessage == null) {
                    return 0;
                }
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("BE <= " + Arrays.toString(writeFileResponseMessage.getDebugInfo()), (ILogger)this.m_log);
                }
                if (writeFileResponseMessage.usingReturnRejectedFormat()) {
                    LinkedList<ResponseMessage> linkedList = this.m_incomingQueue;
                    synchronized (linkedList) {
                        this.m_incomingQueue.add(writeFileResponseMessage);
                        break block10;
                    }
                }
                writeFileResponseMessage.writeToDisk();
            }
            catch (IOException iOException) {
                throw this.logAndConvertToNetworkException(iOException);
            }
        }
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleParameterStatus(ParameterStatusResponseMessage parameterStatusResponseMessage) throws ClientErrorException {
        String string = parameterStatusResponseMessage.getParameterName();
        String string2 = parameterStatusResponseMessage.getParameterValue();
        LogUtilities.logInfo("Session parameter " + string + " set to " + string2, (ILogger)this.m_log);
        if (string.equals("standard_conforming_strings")) {
            this.m_connection.setUseStandardConformingStrings(string2.equals("on"));
            return;
        } else if (string.equals("MARS")) {
            this.m_connection.setMarsEnabled(string2.equals("on"));
            return;
        } else if (string.equals("server_version")) {
            this.m_connection.setServerVersion(string2);
            return;
        } else if (string.equals("client_locale")) {
            try {
                this.m_connection.setServerLocale(string2, false);
                return;
            }
            catch (ErrorException errorException) {}
            return;
        } else if (string.equals("long_string_types")) {
            this.m_connection.setLongStringsEnabled(string2.equals("on"));
            return;
        } else if (string.equals("auto_commit")) {
            try {
                boolean bl;
                boolean bl2 = string2.equals("on");
                boolean bl3 = bl = this.m_connection.getProperty(19).getLong() == 1L;
                if ((!bl2 || bl) && (bl2 || !bl)) return;
                Variant variant = new Variant(3, bl2 ? 1L : 0L);
                this.m_connection.setPropertySDKOnly(19, variant);
                return;
            }
            catch (UtilsException utilsException) {
                throw new ClientErrorException(DiagState.DIAG_GENERAL_ERROR, utilsException.getMessage());
            }
            catch (ErrorException errorException) {
                throw new ClientErrorException(DiagState.DIAG_GENERAL_ERROR, errorException.getMessage());
            }
        } else if (string.equals("client_label")) {
            this.m_connection.setSessionLabel(string2);
            try {
                this.m_connection.setLocalClientInfoProperty("APPLICATIONNAME", string2);
                return;
            }
            catch (ClientInfoException clientInfoException) {
                throw new ClientErrorException(DiagState.DIAG_GENERAL_ERROR, clientInfoException.getMessage());
            }
        } else {
            if (!string.equals("protocol_version")) return;
            this.m_connection.setEffectiveProtocolVersion(string2);
        }
    }

    public ResponseMessage readExpectedMessage(MessageType messageType) throws ErrorException {
        return this.readExpectedMessage(new MessageType[]{messageType});
    }

    public ResponseMessage readExpectedMessage(MessageType[] messageTypeArray) throws ErrorException {
        ResponseMessage responseMessage = this.readMessage();
        MessageType messageType = responseMessage.getType();
        for (MessageType messageType2 : messageTypeArray) {
            if (!messageType.equals((Object)messageType2)) continue;
            return responseMessage;
        }
        LogUtilities.logError("Message read (" + (Object)((Object)messageType) + ") did not match any of the expected types: " + Arrays.toString((Object[])messageTypeArray), (ILogger)this.m_log);
        switch (messageType) {
            case Error: {
                ServerErrorData serverErrorData = ((ErrorResponseMessage)responseMessage).getErrorData();
                throw serverErrorData.buildException();
            }
        }
        throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.PROTOCOL_ERROR_UNEXPECTED_TYPE.toString(), messageType.toString());
    }

    private void handleNotice(NoticeResponseMessage noticeResponseMessage) {
        IWarningListener iWarningListener;
        ServerErrorData serverErrorData = noticeResponseMessage.getNotice();
        this.m_connection.setCurrentServerErrorData(serverErrorData);
        LogUtilities.logWarning(serverErrorData.toString(), (ILogger)this.m_log);
        String string = serverErrorData.getSQLState();
        if (string == null) {
            string = "01000";
        }
        IWarningListener iWarningListener2 = iWarningListener = this.m_currentWarningListener == null ? this.m_connection.getWarningListener() : this.m_currentWarningListener;
        if (iWarningListener != null) {
            iWarningListener.postWarning(new Warning(string, serverErrorData.getMessage(), serverErrorData.getErrorCode()));
        }
    }

    public void setWarningListener(IWarningListener iWarningListener) {
        this.m_currentWarningListener = iWarningListener;
    }

    public void clearWarningListener() {
        this.m_currentWarningListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (this.m_isClosed) {
            return;
        }
        try {
            this.m_vStream.close();
        }
        catch (IOException iOException) {
            LogUtilities.logError(iOException, (ILogger)this.m_log);
        }
        finally {
            this.m_isClosed = true;
        }
    }

    public void flush() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.ensureOpen();
        try {
            this.m_vStream.flush();
            this.m_hasOutgoingMessage = false;
        }
        catch (IOException iOException) {
            throw this.logAndConvertToNetworkException(iOException);
        }
    }

    public void ensureOpen() throws ErrorException {
        if (this.m_initComplete && this.m_connection.isClosed()) {
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_CONNECTION_CLOSED.toString());
        }
    }

    public void enableOpenChecking() {
        this.m_initComplete = true;
    }

    private ErrorException logAndConvertToNetworkException(IOException iOException) {
        LogUtilities.logError(iOException, (ILogger)this.m_log);
        return new RecoverableException(DiagState.DIAG_COMM_LINK_FAILURE, 101, VMessageKey.NETWORK_ERROR_GENERAL.toString(), new String[]{iOException.toString()}, (Throwable)iOException);
    }
}

