/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.utilities;

import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class Variant {
    public static final long UINT32_MAX_VALUE = 0xFFFFFFFFL;
    public static final long UINT32_MIN_VALUE = 0L;
    public static final BigInteger UINT64_MAX_VALUE = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    public static final BigInteger UINT64_MIN_VALUE = BigInteger.ZERO;
    private static final BigInteger CHAR_MIN_VALUE_AS_BIGINT = BigInteger.valueOf(0L);
    private static final BigInteger CHAR_MAX_VALUE_AS_BIGINT = BigInteger.valueOf(65535L);
    private static final BigInteger SHORT_MIN_VALUE_AS_BIGINT = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger SHORT_MAX_VALUE_AS_BIGINT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger INT_MIN_VALUE_AS_BIGINT = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger INT_MAX_VALUE_AS_BIGINT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger LONG_MIN_VALUE_AS_BIGINT = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX_VALUE_AS_BIGINT = BigInteger.valueOf(Long.MAX_VALUE);
    public static final int TYPE_WSTRING = 0;
    public static final int TYPE_UINT16 = 2;
    public static final int TYPE_UINT32 = 3;
    public static final int TYPE_UINT64 = 4;
    public static final int TYPE_INT16 = 5;
    public static final int TYPE_INT32 = 6;
    public static final int TYPE_INT64 = 7;
    public static final int TYPE_NULL = 8;
    private int m_type;
    private Object m_value;

    public Variant(int type, Object value) throws IncorrectTypeException, NumericOverflowException {
        switch (type) {
            case 0: {
                if (value == null || value instanceof String) break;
                throw new IncorrectTypeException();
            }
            case 5: {
                if (value instanceof Short) break;
                throw new IncorrectTypeException();
            }
            case 2: {
                if (value instanceof Character) break;
                throw new IncorrectTypeException();
            }
            case 6: {
                if (value instanceof Integer) break;
                throw new IncorrectTypeException();
            }
            case 3: {
                if (!(value instanceof Long)) {
                    throw new IncorrectTypeException();
                }
                long lvalue = (Long)value;
                if (0xFFFFFFFFL >= lvalue && 0L <= lvalue) break;
                throw new NumericOverflowException();
            }
            case 7: {
                if (value instanceof Long) break;
                throw new IncorrectTypeException();
            }
            case 4: {
                if (value instanceof Long) {
                    long longVal = (Long)value;
                    if (0L > longVal) {
                        throw new NumericOverflowException();
                    }
                    value = BigInteger.valueOf((Long)value);
                    break;
                }
                if (value instanceof BigInteger) {
                    BigInteger bigIntVal = (BigInteger)value;
                    if (UINT64_MAX_VALUE.compareTo(bigIntVal) >= 0 && UINT64_MIN_VALUE.compareTo(bigIntVal) <= 0) break;
                    throw new NumericOverflowException();
                }
                throw new IncorrectTypeException();
            }
            case 8: {
                if (null == value) break;
                throw new IncorrectTypeException();
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
        this.m_type = type;
        this.m_value = value;
    }

    public Variant(String value) {
        this.m_value = value;
        this.m_type = 0;
    }

    public char getChar() throws NumericOverflowException, IncorrectTypeException {
        switch (this.m_type) {
            case 2: {
                return ((Character)this.m_value).charValue();
            }
            case 5: {
                int value = ((Short)this.m_value).intValue();
                if (0 <= value) {
                    return (char)value;
                }
                throw new NumericOverflowException();
            }
            case 3: {
                long value = (Long)this.m_value;
                if (65535L >= value) {
                    return (char)value;
                }
                throw new NumericOverflowException();
            }
            case 6: {
                int value = (Integer)this.m_value;
                if (65535 >= value && 0 <= value) {
                    return (char)value;
                }
                throw new NumericOverflowException();
            }
            case 7: {
                long value = (Long)this.m_value;
                if (65535L >= value && 0L <= value) {
                    return (char)value;
                }
                throw new NumericOverflowException();
            }
            case 4: {
                BigInteger bigIntVal = (BigInteger)this.m_value;
                if (CHAR_MAX_VALUE_AS_BIGINT.compareTo(bigIntVal) < 0 || CHAR_MIN_VALUE_AS_BIGINT.compareTo(bigIntVal) > 0) {
                    throw new NumericOverflowException();
                }
                return (char)bigIntVal.shortValue();
            }
            case 0: {
                try {
                    long value = Long.parseLong((String)this.m_value);
                    if (65535L >= value && 0L <= value) {
                        return (char)value;
                    }
                    throw new NumericOverflowException();
                }
                catch (NumberFormatException e) {
                    throw new IncorrectTypeException();
                }
            }
            case 8: {
                throw new IncorrectTypeException();
            }
        }
        throw new IncorrectTypeException();
    }

    public int getInt() throws NumericOverflowException, IncorrectTypeException {
        switch (this.m_type) {
            case 2: {
                return ((Character)this.m_value).charValue();
            }
            case 5: {
                return ((Short)this.m_value).intValue();
            }
            case 3: {
                long value = (Long)this.m_value;
                if (Integer.MAX_VALUE >= value) {
                    return (int)value;
                }
                throw new NumericOverflowException();
            }
            case 6: {
                return (Integer)this.m_value;
            }
            case 7: {
                long value = (Long)this.m_value;
                if (Integer.MAX_VALUE >= value && Integer.MIN_VALUE <= value) {
                    return (short)value;
                }
                throw new NumericOverflowException();
            }
            case 4: {
                BigInteger bigIntVal = (BigInteger)this.m_value;
                if (INT_MAX_VALUE_AS_BIGINT.compareTo(bigIntVal) < 0 || INT_MIN_VALUE_AS_BIGINT.compareTo(bigIntVal) > 0) {
                    throw new NumericOverflowException();
                }
                return bigIntVal.intValue();
            }
            case 0: {
                try {
                    long value = Long.parseLong((String)this.m_value);
                    if (Integer.MAX_VALUE >= value && Integer.MIN_VALUE <= value) {
                        return (int)value;
                    }
                    throw new NumericOverflowException();
                }
                catch (NumberFormatException e) {
                    throw new IncorrectTypeException();
                }
            }
            case 8: {
                throw new IncorrectTypeException();
            }
        }
        throw new IncorrectTypeException();
    }

    public long getLong() throws IncorrectTypeException, NumericOverflowException {
        switch (this.m_type) {
            case 2: {
                return ((Character)this.m_value).charValue();
            }
            case 5: {
                return ((Short)this.m_value).longValue();
            }
            case 3: {
                return (Long)this.m_value;
            }
            case 6: {
                return ((Integer)this.m_value).longValue();
            }
            case 7: {
                return (Long)this.m_value;
            }
            case 4: {
                BigInteger bigIntVal = (BigInteger)this.m_value;
                if (LONG_MAX_VALUE_AS_BIGINT.compareTo(bigIntVal) < 0 || LONG_MIN_VALUE_AS_BIGINT.compareTo(bigIntVal) > 0) {
                    throw new NumericOverflowException();
                }
                return bigIntVal.longValue();
            }
            case 0: {
                try {
                    return Long.parseLong((String)this.m_value);
                }
                catch (NumberFormatException e) {
                    throw new IncorrectTypeException();
                }
            }
            case 8: {
                throw new IncorrectTypeException();
            }
        }
        throw new IncorrectTypeException();
    }

    public BigInteger getBigInteger() throws IncorrectTypeException {
        switch (this.m_type) {
            case 2: {
                return BigInteger.valueOf(((Character)this.m_value).charValue());
            }
            case 5: {
                return BigInteger.valueOf(((Short)this.m_value).shortValue());
            }
            case 3: {
                return BigInteger.valueOf((Long)this.m_value);
            }
            case 6: {
                return BigInteger.valueOf(((Integer)this.m_value).intValue());
            }
            case 7: {
                return BigInteger.valueOf((Long)this.m_value);
            }
            case 4: {
                return (BigInteger)this.m_value;
            }
            case 0: {
                try {
                    return new BigInteger((String)this.m_value);
                }
                catch (NumberFormatException e) {
                    throw new IncorrectTypeException();
                }
            }
            case 8: {
                throw new IncorrectTypeException();
            }
        }
        throw new IncorrectTypeException();
    }

    public short getShort() throws NumericOverflowException, IncorrectTypeException {
        switch (this.m_type) {
            case 2: {
                char value = ((Character)this.m_value).charValue();
                if (Short.MAX_VALUE >= value) {
                    return (short)value;
                }
                throw new NumericOverflowException();
            }
            case 5: {
                return (Short)this.m_value;
            }
            case 3: {
                long value = (Long)this.m_value;
                if (32767L >= value) {
                    return (short)value;
                }
                throw new NumericOverflowException();
            }
            case 6: {
                int value = (Integer)this.m_value;
                if (Short.MAX_VALUE >= value && Short.MIN_VALUE <= value) {
                    return (short)value;
                }
                throw new NumericOverflowException();
            }
            case 7: {
                long value = (Long)this.m_value;
                if (32767L >= value && -32768L <= value) {
                    return (short)value;
                }
                throw new NumericOverflowException();
            }
            case 4: {
                BigInteger bigIntVal = (BigInteger)this.m_value;
                if (SHORT_MAX_VALUE_AS_BIGINT.compareTo(bigIntVal) < 0 || SHORT_MIN_VALUE_AS_BIGINT.compareTo(bigIntVal) > 0) {
                    throw new NumericOverflowException();
                }
                return bigIntVal.shortValue();
            }
            case 0: {
                try {
                    long value = Long.parseLong((String)this.m_value);
                    if (32767L >= value && -32768L <= value) {
                        return (short)value;
                    }
                    throw new NumericOverflowException();
                }
                catch (NumberFormatException e) {
                    throw new IncorrectTypeException();
                }
            }
            case 8: {
                throw new IncorrectTypeException();
            }
        }
        throw new IncorrectTypeException();
    }

    public String getString() {
        if (null == this.m_value) {
            return null;
        }
        if (2 == this.m_type) {
            char value = ((Character)this.m_value).charValue();
            return String.valueOf((int)value);
        }
        return this.m_value.toString();
    }

    public byte[] getStringAsUTF8() throws IncorrectTypeException, UnsupportedEncodingException {
        if (null == this.m_value) {
            return null;
        }
        return this.getString().getBytes("UTF-8");
    }

    public int getType() {
        return this.m_type;
    }

    public String toString() {
        String type = null;
        switch (this.m_type) {
            case 0: {
                type = "TYPE_WSTRING";
                break;
            }
            case 2: {
                type = "TYPE_UINT16";
                break;
            }
            case 3: {
                type = "TYPE_UINT32";
                break;
            }
            case 4: {
                type = "TYPE_UINT64";
                break;
            }
            case 5: {
                type = "TYPE_INT16";
                break;
            }
            case 6: {
                type = "TYPE_INT32";
                break;
            }
            case 7: {
                type = "TYPE_INT64";
                break;
            }
            default: {
                type = "TYPE_NULL";
            }
        }
        if (null == this.m_value) {
            return "Variant[type: " + type + ", value: null]";
        }
        return "Variant[type: " + type + ", value: " + this.getString() + "]";
    }

    public boolean equals(Object other) {
        if (null == other || !(other instanceof Variant)) {
            return false;
        }
        Variant otherAsVariant = (Variant)other;
        if (null == this.m_value) {
            return null == otherAsVariant.m_value;
        }
        return this.m_value.equals(otherAsVariant.m_value);
    }

    public int hashCode() {
        if (null != this.m_value) {
            return this.m_value.hashCode();
        }
        return 0;
    }
}

