/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.interfaces.ILogHandler;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.SettingReader;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileHandler
implements ILogHandler {
    private static final int DEFAULT_FILE_SIZE = 0x1400000;
    private static final int DEFAULT_FILE_COUNT = 50;
    public static final String LOG_PRINT_WRITER_KEY = "LogPrintWriter";
    private static final String LOG_FILE_EXTENSION = ".log";
    private static final String EXTENSION_SEPERATOR = ".";
    private static final Pattern FILE_SIZE_PATTERN = Pattern.compile("\\s*(\\d+)\\s*(k|g|m|)b?\\s*", 2);
    private File m_currentLogFile;
    private String m_fileName;
    private boolean isRotationOn = false;
    private String m_logDirectory;
    private PrintWriter m_logWriter = null;
    private int m_maxFileSize;
    private int m_maxFileCount;
    private ArrayList<String> m_rotationFileNames;

    public FileHandler(String filename) throws Exception {
        int separator = filename.lastIndexOf(File.separator);
        this.m_logDirectory = filename.substring(0, separator);
        this.m_fileName = filename.substring(separator + 1);
        if (-1 != separator) {
            this.createDirectory();
        }
        this.prepareLogWriter();
    }

    @Override
    public void writeLog(String formattedLine) throws Exception {
        this.m_logWriter.println(formattedLine);
        this.m_logWriter.flush();
        if (this.isRotationOn && 0 != this.m_maxFileSize && this.m_currentLogFile.length() >= (long)this.m_maxFileSize) {
            this.closeFile();
            this.rotateLogFiles();
            this.openFile();
        }
    }

    private void createDirectory() throws ErrorException {
        File directory = new File(this.m_logDirectory);
        if (!directory.exists() && !directory.mkdir()) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CANNOT_CREATE_LOGGING_PATH.name(), this.m_logDirectory, ExceptionType.DEFAULT);
        }
    }

    private int convertStringToMaxFileSize(String inString) {
        int maxBytes = 0x1400000;
        if (null == inString || inString.isEmpty()) {
            return maxBytes;
        }
        Matcher fileSizematcher = FILE_SIZE_PATTERN.matcher(inString);
        if (fileSizematcher.find()) {
            try {
                maxBytes = Integer.valueOf(fileSizematcher.group(1)) * this.suffixToMultiplier(fileSizematcher.group(2).toLowerCase());
            }
            catch (NumberFormatException e) {
                this.m_logWriter.println(e.getMessage());
                this.m_logWriter.flush();
            }
        }
        return maxBytes;
    }

    private int convertStringToMaxFileCount(String inString) {
        if (null != inString && !inString.isEmpty()) {
            int fileCount = Integer.valueOf(inString);
            if (fileCount < 0) {
                return 50;
            }
            return fileCount;
        }
        return 50;
    }

    private void closeFile() {
        if (this.isOpen()) {
            this.m_currentLogFile = null;
            if (null != this.m_logWriter) {
                this.m_logWriter.close();
            }
        }
    }

    private void deleteOldestFile() throws IOException {
        String last = this.m_rotationFileNames.get(this.m_rotationFileNames.size() - 1);
        File file = new File(last);
        if (file.exists()) {
            file.delete();
        }
        for (int i = this.m_rotationFileNames.size() - 2; i >= 0; --i) {
            File dest;
            File current = new File(this.m_rotationFileNames.get(i));
            if (current.exists() && !current.renameTo(dest = new File(last))) {
                throw new IOException("cannot rename file: " + current.getName() + " to: " + last);
            }
            last = this.m_rotationFileNames.get(i);
        }
    }

    private ArrayList<String> initializeFileNamesForLogRotation(String logDirectory, String fileExt, int maxFileCount) {
        this.m_rotationFileNames = new ArrayList();
        if (this.m_fileName.contains(EXTENSION_SEPERATOR)) {
            fileExt = this.m_fileName.substring(this.m_fileName.lastIndexOf(EXTENSION_SEPERATOR), this.m_fileName.length());
            this.m_fileName = this.m_fileName.substring(0, this.m_fileName.lastIndexOf(EXTENSION_SEPERATOR));
        }
        this.m_rotationFileNames.add(logDirectory + File.separator + this.m_fileName + fileExt);
        for (int i = 1; i < maxFileCount; ++i) {
            this.m_rotationFileNames.add(logDirectory + File.separator + this.m_fileName + EXTENSION_SEPERATOR + i + fileExt);
        }
        return this.m_rotationFileNames;
    }

    private boolean isOpen() {
        return null != this.m_logWriter;
    }

    private void openFile() throws FileNotFoundException {
        this.m_currentLogFile = new File(this.m_rotationFileNames.get(0));
        FileOutputStream outStream = new FileOutputStream(this.m_rotationFileNames.get(0), true);
        this.m_logWriter = new PrintWriter(outStream);
    }

    private void rotateLogFiles() throws Exception {
        assert (!this.m_rotationFileNames.isEmpty());
        this.deleteOldestFile();
    }

    private void prepareLogWriter() throws Exception {
        this.m_logWriter = (PrintWriter)SettingReader.readAdditionalSetting(LOG_PRINT_WRITER_KEY);
        if (null == this.m_logWriter) {
            String fullFilename = this.m_logDirectory + File.separator + this.m_fileName;
            if (null != fullFilename && 0 != fullFilename.length()) {
                FileOutputStream outStream = new FileOutputStream(fullFilename, true);
                this.m_logWriter = new PrintWriter(outStream);
                this.updateLoggingFileSettings();
                return;
            }
            throw new Exception("Failed to create log writer");
        }
    }

    private Integer suffixToMultiplier(String sizeChar) {
        if (sizeChar.equals("g")) {
            return 0x40000000;
        }
        if (sizeChar.equals("m")) {
            return 0x100000;
        }
        if (sizeChar.equals("k")) {
            return 1024;
        }
        throw new NumberFormatException("Invalid file size unit.");
    }

    private void updateLoggingFileSettings() {
        this.m_currentLogFile = new File(this.m_logDirectory + File.separator + this.m_fileName);
        this.m_maxFileCount = this.convertStringToMaxFileCount(SettingReader.readSetting("maxFileCount"));
        this.m_maxFileSize = this.convertStringToMaxFileSize(SettingReader.readSetting("maxFileSize"));
        if (1 < this.m_maxFileCount) {
            this.isRotationOn = true;
            this.m_rotationFileNames = this.initializeFileNamesForLogRotation(this.m_logDirectory, LOG_FILE_EXTENSION, this.m_maxFileCount);
        }
    }
}

