/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dataengine;

import com.vertica.dsi.dataengine.utilities.ColumnMetadata;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.Updatable;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.util.ClientErrorException;
import com.vertica.util.TypeUtils;

public class ColumnDescription
extends ColumnMetadata {
    private int m_baseTypeOid;
    private int m_typemod;
    private short m_sqlType;

    public ColumnDescription(String string, String string2, String string3, String string4, int n, int n2, int n3, int n4, String string5) throws NumericOverflowException, ClientErrorException {
        super(TypeUtils.createTypeMetadata(n, n4, string5));
        this.m_baseTypeOid = n;
        this.m_sqlType = this.getTypeMetadata().getType();
        this.m_typemod = n4;
        this.setTableName(string3);
        this.setName(string);
        this.setLabel(string);
        this.setSchemaName(string2);
        this.setCatalogName(string4);
        this.setNullable(n2 == 1 ? Nullable.NULLABLE : Nullable.NO_NULLS);
        this.setAutoUnique(n3 == 1);
        boolean bl = "".equals(string2) || "v_catalog".equals(string2) || "v_monitor".equals(string2) || "v_internal".equals(string2) || "".equals(string3) || this.isAutoUnique();
        this.setUpdatable(bl ? Updatable.READ_ONLY : Updatable.UNKNOWN);
        if (this.m_baseTypeOid == 116 || this.m_baseTypeOid == 115 || this.m_baseTypeOid == 8 || this.m_baseTypeOid == 4 || this.m_baseTypeOid == 9 || this.m_baseTypeOid == 117 || this.m_baseTypeOid == 17) {
            this.setColumnLength(TypeUtils.getColumnSize(n, n4));
        }
    }

    public int getSQLType() {
        return this.m_sqlType;
    }

    public int getTypeOID() {
        return this.m_baseTypeOid;
    }

    public int getTypeMod() {
        return this.m_typemod;
    }

    public String toDebugString() {
        String string;
        String string2 = this.getSchemaName();
        if ("".equals(string2)) {
            string2 = "<none>";
        }
        if ("".equals(string = this.getSchemaName())) {
            string = "<none>";
        }
        TypeMetadata typeMetadata = this.getTypeMetadata();
        return "OID: " + this.m_baseTypeOid + " typemod: " + this.m_typemod + " SQL type: " + this.m_sqlType + " schema: " + string2 + " table: " + string + " name: " + this.getName() + " nullable: " + (Object)((Object)this.getNullable()) + " autounique: " + this.isAutoUnique() + " precision: " + typeMetadata.getPrecision() + " scale: " + typeMetadata.getScale();
    }
}

