/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import com.vertica.core.VConnection;
import com.vertica.dataengine.VDataEngine;
import com.vertica.dataengine.VQueryExecutor;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.core.impl.DSIStatement;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.BadAttrValException;
import com.vertica.dsi.exceptions.UtilsException;
import com.vertica.io.CloseRequestMessage;
import com.vertica.io.FlushRequestMessage;
import com.vertica.io.MessageType;
import com.vertica.io.ProtocolStream;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.GeneralException;
import com.vertica.util.ClientErrorException;
import com.vertica.util.LRSWork;

public class VStatement
extends DSIStatement {
    private VConnection m_connection;
    private ProtocolStream m_protocolStream;
    private DSILogger m_log;
    private long m_resultBufferSize;
    private String m_statementName;
    private long m_maxRows;
    private boolean m_directBatchInsert;

    public VStatement(VConnection vConnection) throws ErrorException {
        super(vConnection);
        this.m_connection = vConnection;
        this.m_protocolStream = this.m_connection.getProtocolStream();
        this.m_log = this.m_connection.getConnectionLog();
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_resultBufferSize = this.m_connection.getResultBufferSize();
        this.m_directBatchInsert = this.m_connection.getDirectBatchInsert();
        this.m_maxRows = 0L;
        this.m_statementName = "";
    }

    public void fallbackToUnnamed() throws ErrorException {
        this.close();
        this.m_statementName = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws ErrorException {
        block6: {
            LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
            this.m_connection.lock();
            try {
                if (this.m_connection.isClosed() || "".equals(this.m_statementName)) break block6;
                VQueryExecutor vQueryExecutor = this.m_connection.getCurrentCopyExecutor();
                if (this.m_connection.inLRS() || vQueryExecutor != null) {
                    this.m_connection.enqueueLRSWork(new LRSWork(){

                        @Override
                        public void execute() throws ErrorException {
                            VStatement.this.closeStatementOnServer();
                        }
                    });
                    if (vQueryExecutor == null || vQueryExecutor.getStatement() != this) break block6;
                    try {
                        this.m_connection.endCurrentCopy();
                        break block6;
                    }
                    catch (ErrorException errorException) {
                        this.m_connection.handleError(false, errorException);
                        throw errorException;
                    }
                }
                this.closeStatementOnServer();
            }
            finally {
                this.m_connection.unlock();
            }
        }
    }

    private void closeStatementOnServer() throws ErrorException {
        LogUtilities.logInfo("Closing statement " + this.m_statementName, (ILogger)this.m_log);
        ErrorException errorException = null;
        try {
            this.m_connection.clearLastServerErrorData();
            this.m_connection.endCurrentCopy();
        }
        catch (ErrorException errorException2) {
            errorException = errorException2;
            try {
                this.m_connection.handleError(false, errorException2);
            }
            catch (ErrorException errorException3) {
                LogUtilities.logError(errorException3, (ILogger)this.m_log);
                errorException = errorException3;
            }
        }
        try {
            if (!this.m_connection.isClosed()) {
                this.m_protocolStream.sendMessage(new CloseRequestMessage(this.m_statementName, false));
                this.m_protocolStream.sendMessage(new FlushRequestMessage());
                this.m_protocolStream.readExpectedMessage(MessageType.CloseComplete);
            }
        }
        catch (GeneralException generalException) {
            LogUtilities.logError(generalException, (ILogger)this.m_log);
            errorException = generalException;
        }
        if (errorException != null) {
            throw errorException;
        }
    }

    @Override
    public VDataEngine createDataEngine() throws GeneralException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return new VDataEngine(this, this.m_connection.getSimpleQueriesOnly());
    }

    public VConnection getConnection() {
        return this.m_connection;
    }

    public long getResultBufferSize() {
        return this.m_resultBufferSize;
    }

    public void setResultBufferSize(long l) {
        LogUtilities.logFunctionEntrance(this.m_log, l);
        this.m_resultBufferSize = l;
    }

    public String makeStatementName() {
        this.m_statementName = this.m_connection.makeStatementName();
        return this.m_statementName;
    }

    public boolean getDirectBatchInsert() {
        return this.m_directBatchInsert;
    }

    public long getMaxRows() {
        return this.m_maxRows;
    }

    private void setMaxRows(long l) {
        LogUtilities.logFunctionEntrance(this.m_log, l);
        this.m_maxRows = l;
    }

    public void setDirectBatchInsert(boolean bl) {
        LogUtilities.logFunctionEntrance(this.m_log, bl);
        this.m_directBatchInsert = bl;
    }

    @Override
    public void setProperty(int n, Variant variant) throws BadAttrValException, ErrorException {
        if (n == 2) {
            try {
                this.setMaxRows(variant.getLong());
            }
            catch (UtilsException utilsException) {
                throw new ClientErrorException(DiagState.DIAG_GENERAL_ERROR, utilsException.getMessage());
            }
        }
        super.setProperty(n, variant);
    }
}

