/*
 * Decompiled with CFR 0.152.
 */
package com.javax0.license3j.licensor.hardware;

import com.javax0.license3j.licensor.hardware.HashCalculator;
import com.javax0.license3j.licensor.hardware.InterfaceSelector;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.UUID;
import org.bouncycastle.crypto.digests.MD5Digest;

public class UUIDCalculator {
    private final HashCalculator calculator;

    public UUIDCalculator(InterfaceSelector selector) {
        this.calculator = new HashCalculator(selector);
    }

    public UUID getMachineId(boolean useNetwork, boolean useHostName, boolean useArchitecture) throws UnsupportedEncodingException, SocketException, UnknownHostException {
        MD5Digest md5 = new MD5Digest();
        md5.reset();
        if (useNetwork) {
            this.calculator.updateWithNetworkData(md5);
        }
        if (useHostName) {
            this.calculator.updateWithHostName(md5);
        }
        if (useArchitecture) {
            this.calculator.updateWithArchitecture(md5);
        }
        byte[] digest = new byte[16];
        md5.doFinal(digest, 0);
        return UUID.nameUUIDFromBytes(digest);
    }

    public String getMachineIdString(boolean useNetwork, boolean useHostName, boolean useArchitecture) throws UnsupportedEncodingException, SocketException, UnknownHostException {
        UUID uuid = this.getMachineId(useNetwork, useHostName, useArchitecture);
        if (uuid != null) {
            return uuid.toString();
        }
        return null;
    }

    public boolean assertUUID(UUID uuid, boolean useNetwork, boolean useHostName, boolean useArchitecture) throws UnsupportedEncodingException, SocketException, UnknownHostException {
        UUID machineUUID = this.getMachineId(useNetwork, useHostName, useArchitecture);
        return machineUUID != null && machineUUID.equals(uuid);
    }

    public boolean assertUUID(String uuid, boolean useNetwork, boolean useHostName, boolean useArchitecture) {
        try {
            return this.assertUUID(UUID.fromString(uuid), useNetwork, useHostName, useArchitecture);
        }
        catch (Exception e) {
            return false;
        }
    }
}

