/*
 * Decompiled with CFR 0.152.
 */
package com.javax0.license3j.licensor.encrypt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

public class PGPHelper {
    private int hashAlgorithm = 10;
    private PGPSecretKey key = null;

    public static boolean keyIsAppropriate(PGPSecretKey key, String userId, String keyUserId) {
        return key.isSigningKey() && (userId == null || userId.equals(keyUserId));
    }

    public void setKey(PGPSecretKey key) {
        this.key = key;
    }

    private PGPSignatureGenerator signatureGenerator(String keyPassPhrase) throws PGPException {
        JcaPGPContentSignerBuilder csBuilder = new JcaPGPContentSignerBuilder(this.key.getPublicKey().getAlgorithm(), this.hashAlgorithm);
        PGPSignatureGenerator generator = new PGPSignatureGenerator((PGPContentSignerBuilder)csBuilder);
        PGPPrivateKey privateKey = this.extractPGPPrivateKey(keyPassPhrase.toCharArray());
        this.init(generator, privateKey);
        return generator;
    }

    private PGPPrivateKey extractPGPPrivateKey(char[] keyPassPhrase) throws PGPException {
        PGPDigestCalculatorProvider calcProvider = new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build();
        PBESecretKeyDecryptor decryptor = new JcePBESecretKeyDecryptorBuilder(calcProvider).setProvider("BC").build(keyPassPhrase);
        return this.key.extractPrivateKey(decryptor);
    }

    private void setHashedSubpackets(PGPSignatureGenerator signatureGenerator) {
        Iterator it = this.key.getPublicKey().getUserIDs();
        if (it.hasNext()) {
            PGPSignatureSubpacketGenerator generator = new PGPSignatureSubpacketGenerator();
            generator.setSignerUserID(false, (String)it.next());
            signatureGenerator.setHashedSubpackets(generator.generate());
        }
    }

    private void init(PGPSignatureGenerator signatureGenerator, PGPPrivateKey pgpPrivKey) throws PGPException {
        signatureGenerator.init(0, pgpPrivKey);
        this.setHashedSubpackets(signatureGenerator);
    }

    private PGPCompressedDataGenerator compressedDataGenerator() {
        return new PGPCompressedDataGenerator(2);
    }

    private void encode(String licensePlain, PGPSignatureGenerator signatureGenerator, OutputStream outputStream) throws IOException {
        int ch;
        PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
        OutputStream literalDataStream = literalDataGenerator.open(outputStream, 'b', "licenseFileName-Ignored", new Date(), new byte[1024]);
        ByteArrayInputStream fIn = new ByteArrayInputStream(licensePlain.getBytes("utf-8"));
        while ((ch = ((InputStream)fIn).read()) >= 0) {
            literalDataStream.write(ch);
            signatureGenerator.update((byte)ch);
        }
        literalDataGenerator.close();
    }

    public void setHashAlgorithm(int hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public byte[] encodeLicense(String keyPassPhraseString, String licensePlain) throws IOException, PGPException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArmoredOutputStream aos = new ArmoredOutputStream((OutputStream)baos);
        PGPCompressedDataGenerator generator = this.compressedDataGenerator();
        BCPGOutputStream output = new BCPGOutputStream(generator.open((OutputStream)aos));
        PGPSignatureGenerator signatureGenerator = this.signatureGenerator(keyPassPhraseString);
        signatureGenerator.generateOnePassVersion(false).encode((OutputStream)output);
        this.encode(licensePlain, signatureGenerator, (OutputStream)output);
        signatureGenerator.generate().encode((OutputStream)output);
        generator.close();
        aos.close();
        return baos.toByteArray();
    }
}

