/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.tabs;

import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.util.Objects;

@Tests(value={Tabs.class})
public class TabsTester<T extends Tabs>
extends ComponentTester<T> {
    public TabsTester(T component) {
        super(component);
    }

    public void select(String label2) {
        Objects.requireNonNull(label2, "label must not be null");
        this.ensureComponentIsUsable();
        Tab tab = this.findTab(label2);
        this.doSelectTab(tab, "Tab with label '" + label2 + "' cannot be selected because it is not usable");
    }

    public void select(int index) {
        this.ensureComponentIsUsable();
        this.doSelectTab(this.findTab(index), "Tab at index " + index + " cannot be selected because it is not usable");
    }

    public boolean isSelected(String label2) {
        this.ensureComponentIsUsable();
        return this.findTab(label2).isSelected();
    }

    public boolean isSelected(int index) {
        this.ensureComponentIsUsable();
        return this.findTab(index).isSelected();
    }

    public Tab getTab(String label2) {
        Objects.requireNonNull(label2, "label must not be null");
        this.ensureComponentIsUsable();
        Tab tab = this.findTab(label2);
        if (tab != null && !tab.isVisible()) {
            throw new IllegalStateException("Tab with label '" + label2 + "' cannot be selected because it is not usable");
        }
        return tab;
    }

    public Tab getTab(int index) {
        this.ensureComponentIsUsable();
        Tab tab = this.findTab(index);
        if (tab != null && !tab.isVisible()) {
            throw new IllegalStateException("Tab at index " + index + " cannot be selected because it is not usable");
        }
        return tab;
    }

    private Tab findTab(String label2) {
        return ((Tabs)this.getComponent()).getChildren().filter(Tab.class::isInstance).map(Tab.class::cast).filter(t -> label2.equals(t.getLabel())).findFirst().orElseThrow(() -> new IllegalArgumentException("Tab with label '" + label2 + "' does not exist"));
    }

    private Tab findTab(int index) {
        if (index > ((Tabs)this.getComponent()).getComponentCount()) {
            throw new IllegalArgumentException("Invalid tab index " + index);
        }
        Tab tab = null;
        if (index >= 0) {
            tab = (Tab)((Tabs)this.getComponent()).getComponentAt(index);
        }
        return tab;
    }

    private void doSelectTab(Tab tab, String errorMessage) {
        if (!(tab == null || tab.isEnabled() && tab.isVisible())) {
            throw new IllegalStateException(errorMessage);
        }
        ((Tabs)this.getComponent()).setSelectedTab(tab);
    }
}

