/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security.stateless;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.util.WebUtils;

class SerializedJwtSplitCookieRepository {
    private static final String JWT_HEADER_AND_PAYLOAD_COOKIE_NAME = "jwt.headerAndPayload";
    private static final String JWT_SIGNATURE_COOKIE_NAME = "jwt.signature";
    private long expiresIn = 1800L;

    SerializedJwtSplitCookieRepository() {
    }

    void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
    }

    String loadSerializedJwt(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        Cookie jwtHeaderAndPayload = WebUtils.getCookie((HttpServletRequest)request, (String)JWT_HEADER_AND_PAYLOAD_COOKIE_NAME);
        if (jwtHeaderAndPayload == null) {
            return null;
        }
        Cookie jwtSignature = WebUtils.getCookie((HttpServletRequest)request, (String)JWT_SIGNATURE_COOKIE_NAME);
        if (jwtSignature == null) {
            return null;
        }
        return jwtHeaderAndPayload.getValue() + "." + jwtSignature.getValue();
    }

    void saveSerializedJwt(String serializedJwt, HttpServletRequest request, HttpServletResponse response) {
        if (serializedJwt == null) {
            this.removeJwtSplitCookies(request, response);
        } else {
            this.setJwtSplitCookies(serializedJwt, request, response);
        }
    }

    boolean containsSerializedJwt(HttpServletRequest request) {
        Cookie jwtHeaderAndPayload = WebUtils.getCookie((HttpServletRequest)request, (String)JWT_HEADER_AND_PAYLOAD_COOKIE_NAME);
        Cookie jwtSignature = WebUtils.getCookie((HttpServletRequest)request, (String)JWT_SIGNATURE_COOKIE_NAME);
        return jwtHeaderAndPayload != null && jwtSignature != null;
    }

    private void setJwtSplitCookies(String serializedJwt, HttpServletRequest request, HttpServletResponse response) {
        String[] parts = serializedJwt.split("\\.");
        String jwtHeaderAndPayload = parts[0] + "." + parts[1];
        String jwtSignature = parts[2];
        Cookie headerAndPayload = new Cookie(JWT_HEADER_AND_PAYLOAD_COOKIE_NAME, jwtHeaderAndPayload);
        headerAndPayload.setHttpOnly(false);
        headerAndPayload.setSecure(request.isSecure());
        headerAndPayload.setPath(this.getRequestContextPath(request));
        headerAndPayload.setMaxAge((int)this.expiresIn - 1);
        response.addCookie(headerAndPayload);
        Cookie signature = new Cookie(JWT_SIGNATURE_COOKIE_NAME, jwtSignature);
        signature.setHttpOnly(true);
        signature.setSecure(request.isSecure());
        signature.setPath(this.getRequestContextPath(request));
        signature.setMaxAge((int)this.expiresIn - 1);
        response.addCookie(signature);
    }

    private void removeJwtSplitCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie jwtHeaderAndPayloadRemove = new Cookie(JWT_HEADER_AND_PAYLOAD_COOKIE_NAME, null);
        jwtHeaderAndPayloadRemove.setPath(this.getRequestContextPath(request));
        jwtHeaderAndPayloadRemove.setMaxAge(0);
        jwtHeaderAndPayloadRemove.setSecure(request.isSecure());
        jwtHeaderAndPayloadRemove.setHttpOnly(false);
        response.addCookie(jwtHeaderAndPayloadRemove);
        Cookie jwtSignatureRemove = new Cookie(JWT_SIGNATURE_COOKIE_NAME, null);
        jwtSignatureRemove.setPath(this.getRequestContextPath(request));
        jwtSignatureRemove.setMaxAge(0);
        jwtSignatureRemove.setSecure(request.isSecure());
        jwtSignatureRemove.setHttpOnly(true);
        response.addCookie(jwtSignatureRemove);
    }

    private String getRequestContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        return "".equals(contextPath) ? "/" : contextPath;
    }
}

