/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class PrefixTree
implements Serializable {
    private final Node root = new Node();

    PrefixTree(Collection<String> prefixes) {
        this.root.terminal = false;
        prefixes.forEach(this::addPrefix);
    }

    void addPrefix(String prefix) {
        if (prefix.isEmpty()) {
            throw new IllegalArgumentException("empty prefix");
        }
        this.root.addPrefix(prefix);
    }

    boolean hasPrefix(String s) {
        Node node = this.root;
        int slen = s.length();
        int sidx = 0;
        while (node != null) {
            if (node.terminal) {
                return true;
            }
            if (sidx < slen) {
                node = (Node)node.children.get(Character.valueOf(s.charAt(sidx++)));
                continue;
            }
            return false;
        }
        return false;
    }

    static class Node
    implements Serializable {
        private final Map<Character, Node> children = new HashMap<Character, Node>();
        private boolean terminal = true;

        Node() {
        }

        void addPrefix(String prefix) {
            this.terminal = false;
            char ch = prefix.charAt(0);
            this.children.putIfAbsent(Character.valueOf(ch), new Node());
            if (prefix.length() > 1) {
                this.children.get(Character.valueOf(ch)).addPrefix(prefix.substring(1));
            }
        }
    }
}

