/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.ComponentDataGenerator;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementAttachListener;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Optional;

@JsModule(value="./flow-component-renderer.js")
public class ComponentRenderer<COMPONENT extends Component, SOURCE>
extends LitRenderer<SOURCE> {
    private Element container;
    private Element owner;
    private SerializableSupplier<COMPONENT> componentSupplier;
    private SerializableFunction<SOURCE, COMPONENT> componentFunction;
    private SerializableBiFunction<Component, SOURCE, Component> componentUpdateFunction;
    private SerializableBiConsumer<COMPONENT, SOURCE> itemConsumer;

    public ComponentRenderer(SerializableSupplier<COMPONENT> componentSupplier, SerializableBiConsumer<COMPONENT, SOURCE> itemConsumer) {
        this.componentSupplier = componentSupplier;
        this.itemConsumer = itemConsumer;
    }

    public ComponentRenderer(SerializableSupplier<COMPONENT> componentSupplier) {
        this(componentSupplier, null);
    }

    public ComponentRenderer(SerializableFunction<SOURCE, COMPONENT> componentFunction) {
        this(componentFunction, null);
    }

    public ComponentRenderer(SerializableFunction<SOURCE, COMPONENT> componentFunction, SerializableBiFunction<Component, SOURCE, Component> componentUpdateFunction) {
        this.componentFunction = componentFunction;
        this.componentUpdateFunction = componentUpdateFunction;
    }

    @Override
    protected String getTemplateExpression() {
        return "${Vaadin.FlowComponentHost.getNode(appId, item.nodeid)}";
    }

    Element getOwner() {
        return this.owner;
    }

    @Override
    public Rendering<SOURCE> render(Element owner, DataKeyMapper<SOURCE> keyMapper, String rendererName) {
        this.owner = owner;
        this.container = new Element("div");
        this.container.addAttachListener((ElementAttachListener & Serializable)event -> this.container.executeJs("Vaadin.FlowComponentHost.patchVirtualContainer(this)", new Object[0]));
        owner.appendVirtualChild(new Element[]{this.container});
        Rendering<SOURCE> rendering = super.render(owner, keyMapper, rendererName);
        return this.configureRendering(rendering, keyMapper);
    }

    Rendering<SOURCE> configureRendering(final Rendering<SOURCE> rendering, final DataKeyMapper<SOURCE> keyMapper) {
        return new Rendering<SOURCE>(){

            @Override
            public Optional<DataGenerator<SOURCE>> getDataGenerator() {
                CompositeDataGenerator generator = new CompositeDataGenerator();
                ComponentDataGenerator componentDataGenerator = new ComponentDataGenerator(ComponentRenderer.this, keyMapper == null ? null : arg_0 -> ((DataKeyMapper)keyMapper).key(arg_0));
                componentDataGenerator.setContainer(ComponentRenderer.this.container);
                componentDataGenerator.setNodeIdPropertyName(ComponentRenderer.this.getPropertyNamespace() + "nodeid");
                generator.addDataGenerator(componentDataGenerator);
                generator.addDataGenerator(rendering.getDataGenerator().get());
                return Optional.of(generator);
            }

            @Override
            public Registration getRegistration() {
                return rendering.getRegistration();
            }
        };
    }

    public COMPONENT createComponent(SOURCE item) {
        if (this.componentFunction != null) {
            return (COMPONENT)((Component)this.componentFunction.apply(item));
        }
        Component component = (Component)this.componentSupplier.get();
        if (this.itemConsumer != null) {
            this.itemConsumer.accept((Object)component, item);
        }
        return (COMPONENT)component;
    }

    public Component updateComponent(Component currentComponent, SOURCE item) {
        if (this.componentUpdateFunction != null) {
            return (Component)this.componentUpdateFunction.apply((Object)currentComponent, item);
        }
        return this.createComponent(item);
    }
}

