/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.menubar;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.contextmenu.HasMenuItems;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.MenuItemsArrayGenerator;
import com.vaadin.flow.component.contextmenu.MenuManager;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.menubar.MenuBarRootItem;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-menu-bar")
@JsModule.Container(value={@JsModule(value="./menubarConnector.js"), @JsModule(value="@vaadin/vaadin-menu-bar/src/vaadin-menu-bar.js")})
@NpmPackage(value="@vaadin/vaadin-menu-bar", version="1.0.5")
public class MenuBar
extends Component
implements HasMenuItems,
HasSize,
HasStyle,
HasTheme {
    private MenuManager<MenuBar, MenuItem, SubMenu> menuManager;
    private MenuItemsArrayGenerator<MenuItem> menuItemsArrayGenerator = new MenuItemsArrayGenerator((Component)this);
    private boolean updateScheduled = false;

    public MenuBar() {
        this.menuManager = new MenuManager((Component)this, this::resetContent, (SerializableBiFunction & Serializable)(menu, contentReset) -> new MenuBarRootItem(this, (SerializableRunnable)contentReset), MenuItem.class, null);
        this.addAttachListener((ComponentEventListener & Serializable)event -> {
            this.initConnector();
            this.resetContent();
        });
    }

    public MenuItem addItem(String text) {
        return (MenuItem)this.menuManager.addItem(text);
    }

    public MenuItem addItem(Component component) {
        return (MenuItem)this.menuManager.addItem(component);
    }

    public MenuItem addItem(String text, ComponentEventListener<ClickEvent<MenuItem>> clickListener) {
        return (MenuItem)this.menuManager.addItem(text, clickListener);
    }

    public MenuItem addItem(Component component, ComponentEventListener<ClickEvent<MenuItem>> clickListener) {
        return (MenuItem)this.menuManager.addItem(component, clickListener);
    }

    public List<MenuItem> getItems() {
        return this.menuManager.getItems();
    }

    public void remove(MenuItem ... items) {
        this.menuManager.remove((Component[])items);
    }

    public void removeAll() {
        this.menuManager.removeAll();
    }

    public Stream<Component> getChildren() {
        return this.menuManager.getChildren();
    }

    public void setOpenOnHover(boolean openOnHover) {
        this.getElement().setProperty("openOnHover", openOnHover);
    }

    public boolean isOpenOnHover() {
        return this.getElement().getProperty("openOnHover", false);
    }

    public void addThemeVariants(MenuBarVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(MenuBarVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(MenuBarVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(MenuBarVariant::getVariantName).collect(Collectors.toList()));
    }

    void resetContent() {
        this.menuItemsArrayGenerator.generate();
        this.updateButtons();
    }

    void updateButtons() {
        if (this.updateScheduled) {
            return;
        }
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            this.getElement().executeJs("this.$connector.updateButtons()", new Serializable[0]);
            this.updateScheduled = false;
        });
        this.updateScheduled = true;
    }

    private void initConnector() {
        this.getElement().executeJs("window.Vaadin.Flow.menubarConnector.initLazy(this)", new Serializable[0]);
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }
}

