/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.serialization;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.map.MapBase;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.streams.DownloadHandler;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.module.SimpleModule;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.ser.std.StdSerializer;

public class MapSerializer {
    private final ObjectMapper mapper;
    private final Map<Object, StreamRegistration> streamRegistrationCache = new HashMap<Object, StreamRegistration>();

    public MapSerializer(MapBase map) {
        SimpleModule mapModule = new SimpleModule().addSerializer(StreamResource.class, (ValueSerializer)new StreamResourceSerializer()).addSerializer(DownloadHandler.class, (ValueSerializer)new DownloadHandlerSerializer());
        this.mapper = ((JsonMapper.Builder)JsonMapper.builder().addModule((JacksonModule)mapModule)).build();
        map.addDetachListener((ComponentEventListener & Serializable)event -> {
            this.streamRegistrationCache.values().forEach(StreamRegistration::unregister);
            this.streamRegistrationCache.clear();
        });
    }

    public BaseJsonNode toJson(Object value) {
        return (BaseJsonNode)this.mapper.valueToTree(value);
    }

    @Deprecated(since="24.8", forRemoval=true)
    private class StreamResourceSerializer
    extends StdSerializer<StreamResource> {
        public StreamResourceSerializer() {
            super(StreamResource.class);
        }

        public void serialize(StreamResource value, JsonGenerator gen, SerializationContext context) {
            if (value == null) {
                gen.writeNull();
                return;
            }
            URI uri = this.getURI(value);
            gen.writeString(uri.toString());
        }

        private URI getURI(StreamResource resource) {
            StreamRegistration registration = MapSerializer.this.streamRegistrationCache.get(resource);
            if (registration == null) {
                StreamResourceRegistry resourceRegistry = UI.getCurrentOrThrow().getSession().getResourceRegistry();
                registration = resourceRegistry.registerResource((AbstractStreamResource)resource);
                MapSerializer.this.streamRegistrationCache.put(resource, registration);
            }
            return registration.getResourceUri();
        }
    }

    private class DownloadHandlerSerializer
    extends StdSerializer<DownloadHandler> {
        public DownloadHandlerSerializer() {
            super(DownloadHandler.class);
        }

        public void serialize(DownloadHandler value, JsonGenerator gen, SerializationContext context) {
            if (value == null) {
                gen.writeNull();
                return;
            }
            URI uri = this.getURI(value);
            gen.writeString(uri.toString());
        }

        private URI getURI(DownloadHandler resource) {
            StreamRegistration registration = MapSerializer.this.streamRegistrationCache.get(resource);
            if (registration == null) {
                StreamResourceRegistry resourceRegistry = UI.getCurrentOrThrow().getSession().getResourceRegistry();
                registration = resourceRegistry.registerResource((ElementRequestHandler)resource);
                MapSerializer.this.streamRegistrationCache.put(resource, registration);
            }
            return registration.getResourceUri();
        }
    }
}

